/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import org.apache.flink.api.common.eventtime.AscendingTimestampsWatermarks;
import org.apache.flink.api.common.eventtime.TestingWatermarkOutput;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.junit.Assert;
import org.junit.Test;

public class AscendingTimestampsWatermarksTest {
    @Test
    public void testWatermarkBeforeRecords() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        AscendingTimestampsWatermarks watermarks = new AscendingTimestampsWatermarks();
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)output.lastWatermark().getTimestamp());
    }

    @Test
    public void testWatermarkAfterEvent() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        AscendingTimestampsWatermarks watermarks = new AscendingTimestampsWatermarks();
        watermarks.onEvent(new Object(), 1337L, (WatermarkOutput)output);
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assert.assertEquals((long)1336L, (long)output.lastWatermark().getTimestamp());
    }

    @Test
    public void testWatermarkAfterEventWithLowerTimestamp() {
        TestingWatermarkOutput output = new TestingWatermarkOutput();
        AscendingTimestampsWatermarks watermarks = new AscendingTimestampsWatermarks();
        watermarks.onEvent(new Object(), 12345L, (WatermarkOutput)output);
        watermarks.onEvent(new Object(), 12340L, (WatermarkOutput)output);
        watermarks.onPeriodicEmit((WatermarkOutput)output);
        Assert.assertEquals((long)12344L, (long)output.lastWatermark().getTimestamp());
    }
}

