/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.eventtime;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.eventtime.AscendingTimestampsWatermarks;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarksWithIdleness;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.junit.Assert;
import org.junit.Test;

public class WatermarksWithIdlenessTest {
    @Test(expected=IllegalArgumentException.class)
    public void testZeroTimeout() {
        new WatermarksWithIdleness((WatermarkGenerator)new AscendingTimestampsWatermarks(), Duration.ZERO);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeTimeout() {
        new WatermarksWithIdleness((WatermarkGenerator)new AscendingTimestampsWatermarks(), Duration.ofMillis(-1L));
    }

    @Test
    public void testInitiallyActive() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = new WatermarksWithIdleness.IdlenessTimer((Clock)clock, Duration.ofMillis(10L));
        Assert.assertFalse((boolean)timer.checkIfIdle());
    }

    @Test
    public void testIdleWithoutEvents() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = new WatermarksWithIdleness.IdlenessTimer((Clock)clock, Duration.ofMillis(10L));
        timer.checkIfIdle();
        clock.advanceTime(11L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)timer.checkIfIdle());
    }

    @Test
    public void testRepeatedIdleChecks() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = WatermarksWithIdlenessTest.createTimerAndMakeIdle(clock, Duration.ofMillis(122L));
        Assert.assertTrue((boolean)timer.checkIfIdle());
        clock.advanceTime(100L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)timer.checkIfIdle());
    }

    @Test
    public void testActiveAfterIdleness() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = WatermarksWithIdlenessTest.createTimerAndMakeIdle(clock, Duration.ofMillis(10L));
        timer.activity();
        Assert.assertFalse((boolean)timer.checkIfIdle());
    }

    @Test
    public void testIdleActiveIdle() {
        ManualClock clock = new ManualClock(System.nanoTime());
        WatermarksWithIdleness.IdlenessTimer timer = WatermarksWithIdlenessTest.createTimerAndMakeIdle(clock, Duration.ofMillis(122L));
        timer.activity();
        Assert.assertFalse((boolean)timer.checkIfIdle());
        timer.checkIfIdle();
        clock.advanceTime(Duration.ofMillis(123L));
        Assert.assertTrue((boolean)timer.checkIfIdle());
    }

    private static WatermarksWithIdleness.IdlenessTimer createTimerAndMakeIdle(ManualClock clock, Duration idleTimeout) {
        WatermarksWithIdleness.IdlenessTimer timer = new WatermarksWithIdleness.IdlenessTimer((Clock)clock, idleTimeout);
        timer.checkIfIdle();
        clock.advanceTime(Duration.ofMillis(idleTimeout.toMillis() + 1L));
        Assert.assertTrue((boolean)timer.checkIfIdle());
        return timer;
    }
}

