/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.File;
import org.apache.flink.api.common.io.DelimitedInputFormat;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.OptimizerOptions;
import org.apache.flink.testutils.TestConfigUtils;
import org.apache.flink.testutils.TestFileSystem;
import org.apache.flink.testutils.TestFileUtils;
import org.apache.flink.types.IntValue;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DelimitedInputFormatSamplingTest {
    private static final String TEST_DATA1 = "123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n";
    private static final String TEST_DATA2 = "12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n";
    private static final int TEST_DATA_1_LINES = "123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n".split("\n").length;
    private static final int TEST_DATA_1_LINEWIDTH = "123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n".split("\n")[0].length();
    private static final int TEST_DATA_2_LINEWIDTH = "12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n".split("\n")[0].length();
    private static final int TOTAL_SIZE = "123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n123456789\n".length() + "12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n12345\n".length();
    private static final int DEFAULT_NUM_SAMPLES = 4;
    private static Configuration CONFIG;
    @ClassRule
    public static TemporaryFolder tempFolder;
    private static File testTempFolder;

    @BeforeClass
    public static void initialize() {
        try {
            testTempFolder = tempFolder.newFolder();
            CONFIG = TestConfigUtils.loadGlobalConf(new String[]{OptimizerOptions.DELIMITED_FORMAT_MIN_LINE_SAMPLES.key(), OptimizerOptions.DELIMITED_FORMAT_MAX_LINE_SAMPLES.key()}, new String[]{"4", "4"}, testTempFolder);
        }
        catch (Throwable t) {
            Assert.fail((String)"Could not load the global configuration.");
        }
    }

    @Test
    public void testNumSamplesOneFile() {
        try {
            String tempFile = TestFileUtils.createTempFile(TEST_DATA1);
            Configuration conf = new Configuration();
            TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
            format.setFilePath(tempFile.replace("file", "test"));
            format.configure(conf);
            TestFileSystem.resetStreamOpenCounter();
            format.getStatistics(null);
            Assert.assertEquals((String)"Wrong number of samples taken.", (long)4L, (long)TestFileSystem.getNumtimeStreamOpened());
            TestDelimitedInputFormat format2 = new TestDelimitedInputFormat(CONFIG);
            format2.setFilePath(tempFile.replace("file", "test"));
            format2.setNumLineSamples(8);
            format2.configure(conf);
            TestFileSystem.resetStreamOpenCounter();
            format2.getStatistics(null);
            Assert.assertEquals((String)"Wrong number of samples taken.", (long)8L, (long)TestFileSystem.getNumtimeStreamOpened());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testNumSamplesMultipleFiles() {
        try {
            String tempFile = TestFileUtils.createTempFileDir(testTempFolder, TEST_DATA1, TEST_DATA1, TEST_DATA1, TEST_DATA1);
            Configuration conf = new Configuration();
            TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
            format.setFilePath(tempFile.replace("file", "test"));
            format.configure(conf);
            TestFileSystem.resetStreamOpenCounter();
            format.getStatistics(null);
            Assert.assertEquals((String)"Wrong number of samples taken.", (long)4L, (long)TestFileSystem.getNumtimeStreamOpened());
            TestDelimitedInputFormat format2 = new TestDelimitedInputFormat(CONFIG);
            format2.setFilePath(tempFile.replace("file", "test"));
            format2.setNumLineSamples(8);
            format2.configure(conf);
            TestFileSystem.resetStreamOpenCounter();
            format2.getStatistics(null);
            Assert.assertEquals((String)"Wrong number of samples taken.", (long)8L, (long)TestFileSystem.getNumtimeStreamOpened());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSamplingOneFile() {
        try {
            String tempFile = TestFileUtils.createTempFile(TEST_DATA1);
            Configuration conf = new Configuration();
            TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
            format.setFilePath(tempFile);
            format.configure(conf);
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            int numLines = TEST_DATA_1_LINES;
            float avgWidth = (float)TEST_DATA1.length() / (float)TEST_DATA_1_LINES;
            Assert.assertTrue((String)"Wrong record count.", (boolean)(stats.getNumberOfRecords() < (long)(numLines + 1) & stats.getNumberOfRecords() > (long)(numLines - 1)));
            Assert.assertTrue((String)"Wrong avg record size.", (boolean)(stats.getAverageRecordWidth() < avgWidth + 1.0f & stats.getAverageRecordWidth() > avgWidth - 1.0f));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSamplingDirectory() {
        try {
            String tempFile = TestFileUtils.createTempFileDir(testTempFolder, TEST_DATA1, TEST_DATA2);
            Configuration conf = new Configuration();
            TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
            format.setFilePath(tempFile);
            format.configure(conf);
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            int maxNumLines = (int)Math.ceil((double)TOTAL_SIZE / (double)Math.min(TEST_DATA_1_LINEWIDTH, TEST_DATA_2_LINEWIDTH));
            int minNumLines = (int)((double)TOTAL_SIZE / (double)Math.max(TEST_DATA_1_LINEWIDTH, TEST_DATA_2_LINEWIDTH));
            float maxAvgWidth = (float)TOTAL_SIZE / (float)minNumLines;
            float minAvgWidth = (float)TOTAL_SIZE / (float)maxNumLines;
            if (!(stats.getNumberOfRecords() <= (long)maxNumLines & stats.getNumberOfRecords() >= (long)minNumLines)) {
                System.err.println("Records: " + stats.getNumberOfRecords() + " out of (" + minNumLines + ", " + maxNumLines + ").");
                Assert.fail((String)"Wrong record count.");
            }
            if (!(stats.getAverageRecordWidth() <= maxAvgWidth & stats.getAverageRecordWidth() >= minAvgWidth)) {
                Assert.fail((String)"Wrong avg record size.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDifferentDelimiter() {
        try {
            String DELIMITER = "12345678-";
            String testData = TEST_DATA1.replace("\n", "12345678-");
            String tempFile = TestFileUtils.createTempFile(testData);
            Configuration conf = new Configuration();
            TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
            format.setFilePath(tempFile);
            format.setDelimiter("12345678-");
            format.configure(conf);
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            int numLines = TEST_DATA_1_LINES;
            float avgWidth = (float)testData.length() / (float)TEST_DATA_1_LINES;
            Assert.assertTrue((String)"Wrong record count.", (boolean)(stats.getNumberOfRecords() < (long)(numLines + 1) & stats.getNumberOfRecords() > (long)(numLines - 1)));
            Assert.assertTrue((String)"Wrong avg record size.", (boolean)(stats.getAverageRecordWidth() < avgWidth + 1.0f & stats.getAverageRecordWidth() > avgWidth - 1.0f));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSamplingOverlyLongRecord() {
        try {
            String tempFile = TestFileUtils.createTempFile(2 * (Integer)OptimizerOptions.DELIMITED_FORMAT_MAX_SAMPLE_LEN.defaultValue());
            Configuration conf = new Configuration();
            TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
            format.setFilePath(tempFile);
            format.configure(conf);
            Assert.assertNull((String)"Expected exception due to overly long record.", (Object)format.getStatistics(null));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCachedStatistics() {
        try {
            String tempFile = TestFileUtils.createTempFile(TEST_DATA1);
            Configuration conf = new Configuration();
            TestDelimitedInputFormat format = new TestDelimitedInputFormat(CONFIG);
            format.setFilePath("test://" + tempFile);
            format.configure(conf);
            TestFileSystem.resetStreamOpenCounter();
            FileInputFormat.FileBaseStatistics stats = format.getStatistics(null);
            Assert.assertEquals((String)"Wrong number of samples taken.", (long)4L, (long)TestFileSystem.getNumtimeStreamOpened());
            TestDelimitedInputFormat format2 = new TestDelimitedInputFormat(CONFIG);
            format2.setFilePath("test://" + tempFile);
            format2.configure(conf);
            TestFileSystem.resetStreamOpenCounter();
            FileInputFormat.FileBaseStatistics stats2 = format2.getStatistics((BaseStatistics)stats);
            Assert.assertTrue((String)"Using cached statistics should cicumvent sampling.", (0 == TestFileSystem.getNumtimeStreamOpened() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Using cached statistics should cicumvent sampling.", (stats == stats2 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    static {
        tempFolder = new TemporaryFolder();
    }

    private static final class TestDelimitedInputFormat
    extends DelimitedInputFormat<IntValue> {
        private static final long serialVersionUID = 1L;

        TestDelimitedInputFormat(Configuration configuration) {
            super(null, configuration);
        }

        public IntValue readRecord(IntValue reuse, byte[] bytes, int offset, int numBytes) {
            throw new UnsupportedOperationException();
        }
    }
}

