/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.File;
import java.io.IOException;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.testutils.TestFileUtils;
import org.apache.flink.types.IntValue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class EnumerateNestedFilesTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    protected Configuration config;
    private DummyFileInputFormat format;

    @Before
    public void setup() {
        this.config = new Configuration();
        this.format = new DummyFileInputFormat();
    }

    @After
    public void setdown() throws Exception {
        if (this.format != null) {
            this.format.close();
        }
    }

    @Test
    public void testNoNestedDirectoryTrue() {
        try {
            String filePath = TestFileUtils.createTempFile("foo");
            this.format.setFilePath(new Path(filePath));
            this.config.setBoolean("recursive.file.enumeration", true);
            this.format.configure(this.config);
            FileInputSplit[] splits = this.format.createInputSplits(1);
            Assert.assertEquals((long)1L, (long)splits.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testOneNestedDirectoryTrue() {
        try {
            String firstLevelDir = TestFileUtils.randomFileName();
            String secondLevelDir = TestFileUtils.randomFileName();
            File insideNestedDir = this.tempFolder.newFolder(new String[]{firstLevelDir, secondLevelDir});
            File nestedDir = insideNestedDir.getParentFile();
            TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), "paella");
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "kalamari");
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "fideua");
            this.format.setFilePath(new Path(nestedDir.toURI().toString()));
            this.config.setBoolean("recursive.file.enumeration", true);
            this.format.configure(this.config);
            FileInputSplit[] splits = this.format.createInputSplits(1);
            Assert.assertEquals((long)3L, (long)splits.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testOneNestedDirectoryFalse() {
        try {
            String firstLevelDir = TestFileUtils.randomFileName();
            String secondLevelDir = TestFileUtils.randomFileName();
            File insideNestedDir = this.tempFolder.newFolder(new String[]{firstLevelDir, secondLevelDir});
            File nestedDir = insideNestedDir.getParentFile();
            TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), "paella");
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "kalamari");
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "fideua");
            this.format.setFilePath(new Path(nestedDir.toURI().toString()));
            this.config.setBoolean("recursive.file.enumeration", false);
            this.format.configure(this.config);
            FileInputSplit[] splits = this.format.createInputSplits(1);
            Assert.assertEquals((long)1L, (long)splits.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testTwoNestedDirectoriesTrue() {
        try {
            String firstLevelDir = TestFileUtils.randomFileName();
            String secondLevelDir = TestFileUtils.randomFileName();
            String thirdLevelDir = TestFileUtils.randomFileName();
            File nestedNestedDir = this.tempFolder.newFolder(new String[]{firstLevelDir, secondLevelDir, thirdLevelDir});
            File insideNestedDir = nestedNestedDir.getParentFile();
            File nestedDir = insideNestedDir.getParentFile();
            TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), "paella");
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "kalamari");
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "fideua");
            TestFileUtils.createTempFileInDirectory(nestedNestedDir.getAbsolutePath(), "bravas");
            this.format.setFilePath(new Path(nestedDir.toURI().toString()));
            this.config.setBoolean("recursive.file.enumeration", true);
            this.format.configure(this.config);
            FileInputSplit[] splits = this.format.createInputSplits(1);
            Assert.assertEquals((long)4L, (long)splits.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testOnlyLevel2NestedDirectories() {
        try {
            String rootDir = TestFileUtils.randomFileName();
            String nestedDir = TestFileUtils.randomFileName();
            String firstNestedNestedDir = TestFileUtils.randomFileName();
            String secondNestedNestedDir = TestFileUtils.randomFileName();
            File testDir = this.tempFolder.newFolder(rootDir);
            this.tempFolder.newFolder(new String[]{rootDir, nestedDir});
            File nestedNestedDir1 = this.tempFolder.newFolder(new String[]{rootDir, nestedDir, firstNestedNestedDir});
            File nestedNestedDir2 = this.tempFolder.newFolder(new String[]{rootDir, nestedDir, secondNestedNestedDir});
            TestFileUtils.createTempFileInDirectory(nestedNestedDir1.getAbsolutePath(), "paella");
            TestFileUtils.createTempFileInDirectory(nestedNestedDir1.getAbsolutePath(), "kalamari");
            TestFileUtils.createTempFileInDirectory(nestedNestedDir2.getAbsolutePath(), "fideua");
            TestFileUtils.createTempFileInDirectory(nestedNestedDir2.getAbsolutePath(), "bravas");
            this.format.setFilePath(new Path(testDir.getAbsolutePath()));
            this.config.setBoolean("recursive.file.enumeration", true);
            this.format.configure(this.config);
            FileInputSplit[] splits = this.format.createInputSplits(1);
            Assert.assertEquals((long)4L, (long)splits.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testTwoNestedDirectoriesWithFilteredFilesTrue() {
        try {
            String firstLevelDir = TestFileUtils.randomFileName();
            String secondLevelDir = TestFileUtils.randomFileName();
            String thirdLevelDir = TestFileUtils.randomFileName();
            String secondLevelFilterDir = "_" + TestFileUtils.randomFileName();
            String thirdLevelFilterDir = "_" + TestFileUtils.randomFileName();
            File nestedNestedDirFiltered = this.tempFolder.newFolder(new String[]{firstLevelDir, secondLevelDir, thirdLevelDir, thirdLevelFilterDir});
            File nestedNestedDir = nestedNestedDirFiltered.getParentFile();
            File insideNestedDir = nestedNestedDir.getParentFile();
            File nestedDir = insideNestedDir.getParentFile();
            File insideNestedDirFiltered = this.tempFolder.newFolder(new String[]{firstLevelDir, secondLevelFilterDir});
            File filteredFile = new File(nestedDir, "_IWillBeFiltered");
            filteredFile.createNewFile();
            TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), "paella");
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "kalamari");
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), "fideua");
            TestFileUtils.createTempFileInDirectory(nestedNestedDir.getAbsolutePath(), "bravas");
            TestFileUtils.createTempFileInDirectory(insideNestedDirFiltered.getAbsolutePath(), "kalamari");
            TestFileUtils.createTempFileInDirectory(insideNestedDirFiltered.getAbsolutePath(), "fideua");
            TestFileUtils.createTempFileInDirectory(nestedNestedDirFiltered.getAbsolutePath(), "bravas");
            this.format.setFilePath(new Path(nestedDir.toURI().toString()));
            this.config.setBoolean("recursive.file.enumeration", true);
            this.format.configure(this.config);
            FileInputSplit[] splits = this.format.createInputSplits(1);
            Assert.assertEquals((long)4L, (long)splits.length);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetStatisticsOneFileInNestedDir() {
        try {
            long SIZE = 512000L;
            String firstLevelDir = TestFileUtils.randomFileName();
            String secondLevelDir = TestFileUtils.randomFileName();
            File insideNestedDir = this.tempFolder.newFolder(new String[]{firstLevelDir, secondLevelDir});
            File nestedDir = insideNestedDir.getParentFile();
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), 512000L);
            this.format.setFilePath(new Path(nestedDir.toURI().toString()));
            this.config.setBoolean("recursive.file.enumeration", true);
            this.format.configure(this.config);
            FileInputFormat.FileBaseStatistics stats = this.format.getStatistics(null);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)512000L, (long)stats.getTotalInputSize());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetStatisticsMultipleNestedFiles() {
        try {
            long SIZE1 = 2077L;
            long SIZE2 = 31909L;
            long SIZE3 = 10L;
            long SIZE4 = 71L;
            long TOTAL = 34067L;
            String firstLevelDir = TestFileUtils.randomFileName();
            String secondLevelDir = TestFileUtils.randomFileName();
            String secondLevelDir2 = TestFileUtils.randomFileName();
            File insideNestedDir = this.tempFolder.newFolder(new String[]{firstLevelDir, secondLevelDir});
            File insideNestedDir2 = this.tempFolder.newFolder(new String[]{firstLevelDir, secondLevelDir2});
            File nestedDir = insideNestedDir.getParentFile();
            TestFileUtils.createTempFileInDirectory(nestedDir.getAbsolutePath(), 2077L);
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), 31909L);
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), 10L);
            TestFileUtils.createTempFileInDirectory(insideNestedDir2.getAbsolutePath(), 71L);
            this.format.setFilePath(new Path(nestedDir.toURI().toString()));
            this.config.setBoolean("recursive.file.enumeration", true);
            this.format.configure(this.config);
            FileInputFormat.FileBaseStatistics stats = this.format.getStatistics(null);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)34067L, (long)stats.getTotalInputSize());
            Thread.sleep(1000L);
            TestFileUtils.createTempFileInDirectory(insideNestedDir.getAbsolutePath(), 42L);
            FileInputFormat.FileBaseStatistics stats2 = this.format.getStatistics((BaseStatistics)stats);
            Assert.assertNotEquals((Object)stats2, (Object)stats);
            Assert.assertEquals((String)"The file size from the statistics is wrong.", (long)34109L, (long)stats2.getTotalInputSize());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    private class DummyFileInputFormat
    extends FileInputFormat<IntValue> {
        private static final long serialVersionUID = 1L;

        private DummyFileInputFormat() {
        }

        public boolean reachedEnd() throws IOException {
            return true;
        }

        public IntValue nextRecord(IntValue reuse) throws IOException {
            return null;
        }
    }
}

