/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.operators.SelectorFunctionKeysTest;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeExtractionTest;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;

@RunWith(value=PowerMockRunner.class)
public class ExpressionKeysTest {
    @Test
    public void testBasicType() {
        BasicTypeInfo longType = BasicTypeInfo.LONG_TYPE_INFO;
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys("*", (TypeInformation)longType);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])ek.computeLogicalKeyPositions());
    }

    @Test(expected=InvalidProgramException.class)
    public void testGenericNonKeyType() {
        GenericTypeInfo genericType = new GenericTypeInfo(GenericNonKeyType.class);
        new Keys.ExpressionKeys("*", (TypeInformation)genericType);
    }

    @Test
    public void testKeyGenericType() {
        GenericTypeInfo genericType = new GenericTypeInfo(GenericKeyType.class);
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys("*", (TypeInformation)genericType);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])ek.computeLogicalKeyPositions());
    }

    @Test
    public void testTupleRangeCheck() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method rangeCheckFieldsMethod = Whitebox.getMethod(Keys.class, (String)"rangeCheckFields", (Class[])new Class[]{int[].class, Integer.TYPE});
        rangeCheckFieldsMethod.invoke(null, new int[]{1, 2, 3, 4}, 4);
        rangeCheckFieldsMethod.invoke(null, new int[]{0}, 0);
        Throwable ex = null;
        try {
            rangeCheckFieldsMethod.invoke(null, new int[]{5}, 0);
        }
        catch (Throwable iae) {
            ex = iae;
        }
        Assert.assertNotNull((Object)ex);
    }

    @Test
    public void testStandardTupleKeys() {
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        for (int i = 1; i < 8; ++i) {
            int[] ints = new int[i];
            for (int j = 0; j < i; ++j) {
                ints[j] = j;
            }
            int[] inInts = Arrays.copyOf(ints, ints.length);
            Keys.ExpressionKeys ek = new Keys.ExpressionKeys(inInts, (TypeInformation)typeInfo);
            Assert.assertArrayEquals((int[])ints, (int[])ek.computeLogicalKeyPositions());
            Assert.assertEquals((long)ints.length, (long)ek.computeLogicalKeyPositions().length);
            ArrayUtils.reverse((int[])ints);
            inInts = Arrays.copyOf(ints, ints.length);
            ek = new Keys.ExpressionKeys(inInts, (TypeInformation)typeInfo);
            Assert.assertArrayEquals((int[])ints, (int[])ek.computeLogicalKeyPositions());
            Assert.assertEquals((long)ints.length, (long)ek.computeLogicalKeyPositions().length);
        }
    }

    @Test
    public void testInvalidTuple() throws Throwable {
        String[][] tests;
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        for (String[] test : tests = new String[][]{{"f0.f1"}, {"f11"}, {"f-35"}, {"f0.f33"}, {"f1.f33"}}) {
            Throwable e = null;
            try {
                new Keys.ExpressionKeys(test, (TypeInformation)typeInfo);
            }
            catch (Throwable t) {
                e = t;
            }
            Assert.assertNotNull((Object)e);
        }
    }

    @Test(expected=InvalidProgramException.class)
    public void testTupleNonKeyField() {
        TupleTypeInfo ti = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, TypeExtractor.getForClass(GenericNonKeyType.class)});
        new Keys.ExpressionKeys(2, (TypeInformation)ti);
    }

    @Test
    public void testTupleKeyExpansion() {
        TupleTypeInfo typeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        Keys.ExpressionKeys fpk = new Keys.ExpressionKeys(0, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(1, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(2, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new int[]{0, 1, 2}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(null, (TypeInformation)typeInfo, true);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys("*", (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys("_", (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys("f2", (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"f0", "f1.f0", "f1.f1", "f1.f2", "f2"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"f0", "f1.f0", "f1.f1", "f2"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 4}, (int[])fpk.computeLogicalKeyPositions());
        fpk = new Keys.ExpressionKeys(new String[]{"f2", "f0"}, (TypeInformation)typeInfo);
        Assert.assertArrayEquals((int[])new int[]{4, 0}, (int[])fpk.computeLogicalKeyPositions());
        TupleTypeInfo complexTypeInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, new TupleTypeInfo(new TypeInformation[]{new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}), BasicTypeInfo.STRING_TYPE_INFO});
        Keys.ExpressionKeys complexFpk = new Keys.ExpressionKeys(0, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys(new int[]{0, 1, 2}, (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys("*", (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys("_", (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys("f1.f0.*", (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys("f1.f0", (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])complexFpk.computeLogicalKeyPositions());
        complexFpk = new Keys.ExpressionKeys("f2", (TypeInformation)complexTypeInfo);
        Assert.assertArrayEquals((int[])new int[]{6}, (int[])complexFpk.computeLogicalKeyPositions());
    }

    @Test
    public void testPojoKeys() {
        TypeInformation ti = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys("*", ti);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys("p1.*", ti);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys("p2.*", ti);
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys("p1", ti);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys("p2", ti);
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys("i0", ti);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])ek.computeLogicalKeyPositions());
    }

    @Test
    public void testTupleWithNestedPojo() {
        TupleTypeInfo ti = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, TypeExtractor.getForClass(Pojo1.class), TypeExtractor.getForClass(PojoWithMultiplePojos.class)});
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(0, (TypeInformation)ti);
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(1, (TypeInformation)ti);
        Assert.assertArrayEquals((int[])new int[]{1, 2}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(2, (TypeInformation)ti);
        Assert.assertArrayEquals((int[])new int[]{3, 4, 5, 6, 7}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys(new int[0], (TypeInformation)ti, true);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys("*", (TypeInformation)ti);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7}, (int[])ek.computeLogicalKeyPositions());
        ek = new Keys.ExpressionKeys("f2.p1.*", (TypeInformation)ti);
        Assert.assertArrayEquals((int[])new int[]{4, 5}, (int[])ek.computeLogicalKeyPositions());
    }

    @Test
    public void testOriginalTypes() {
        TupleTypeInfo ti = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, TypeExtractor.getForClass(Pojo1.class), TypeExtractor.getForClass(PojoWithMultiplePojos.class)});
        Keys.ExpressionKeys ek = new Keys.ExpressionKeys(0, (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys(1, (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo1.class)}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys(2, (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{TypeExtractor.getForClass(PojoWithMultiplePojos.class)}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys(new int[0], (TypeInformation)ti, true);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, TypeExtractor.getForClass(Pojo1.class), TypeExtractor.getForClass(PojoWithMultiplePojos.class)}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys("*", (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{ti}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys("f1", (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo1.class)}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys("f1.*", (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo1.class)}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys("f2.*", (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{TypeExtractor.getForClass(PojoWithMultiplePojos.class)}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys("f2.p2", (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo2.class)}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys("f2.p2.*", (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo2.class)}, (Object[])ek.getOriginalKeyFieldTypes());
        ek = new Keys.ExpressionKeys("f2.p2._", (TypeInformation)ti);
        Assert.assertArrayEquals((Object[])new TypeInformation[]{TypeExtractor.getForClass(Pojo2.class)}, (Object[])ek.getOriginalKeyFieldTypes());
    }

    @Test(expected=InvalidProgramException.class)
    public void testNonKeyPojoField() {
        TypeInformation ti = TypeExtractor.getForClass(PojoWithNonKeyField.class);
        new Keys.ExpressionKeys("b", ti);
    }

    @Test
    public void testInvalidPojo() throws Throwable {
        String[][] tests;
        TypeInformation ti = TypeExtractor.getForClass(PojoTypeExtractionTest.ComplexNestedClass.class);
        for (String[] test : tests = new String[][]{{"nonexistent"}, {"date.abc"}}) {
            Throwable e = null;
            try {
                new Keys.ExpressionKeys(test, ti);
            }
            catch (Throwable t) {
                e = t;
            }
            Assert.assertNotNull((Object)e);
        }
    }

    @Test
    public void testAreCompatible1() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(Pojo1.class);
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("a", t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys("b", t1);
        Assert.assertTrue((boolean)ek1.areCompatible((Keys)ek2));
        Assert.assertTrue((boolean)ek2.areCompatible((Keys)ek1));
    }

    @Test
    public void testAreCompatible2() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(Pojo1.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("a", t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(0, (TypeInformation)t2);
        Assert.assertTrue((boolean)ek1.areCompatible((Keys)ek2));
        Assert.assertTrue((boolean)ek2.areCompatible((Keys)ek1));
    }

    @Test
    public void testAreCompatible3() throws Keys.IncompatibleKeysException {
        BasicTypeInfo t1 = BasicTypeInfo.STRING_TYPE_INFO;
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("*", (TypeInformation)t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(0, (TypeInformation)t2);
        Assert.assertTrue((boolean)ek1.areCompatible((Keys)ek2));
        Assert.assertTrue((boolean)ek2.areCompatible((Keys)ek1));
    }

    @Test
    public void testAreCompatible4() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new String[]{"p1", "i0"}, t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(new int[]{0, 0, 2}, (TypeInformation)t2);
        Assert.assertTrue((boolean)ek1.areCompatible((Keys)ek2));
        Assert.assertTrue((boolean)ek2.areCompatible((Keys)ek1));
    }

    @Test
    public void testAreCompatible5() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new String[]{"p1.b", "p2.a2"}, t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys("*", (TypeInformation)t2);
        Assert.assertTrue((boolean)ek1.areCompatible((Keys)ek2));
        Assert.assertTrue((boolean)ek2.areCompatible((Keys)ek1));
    }

    @Test(expected=Keys.IncompatibleKeysException.class)
    public void testAreCompatible6() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(Pojo1.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("a", t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(1, (TypeInformation)t2);
        ek1.areCompatible((Keys)ek2);
    }

    @Test(expected=Keys.IncompatibleKeysException.class)
    public void testAreCompatible7() throws Keys.IncompatibleKeysException {
        TypeInformation t1 = TypeExtractor.getForClass(Pojo1.class);
        TupleTypeInfo t2 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO});
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new String[]{"a", "b"}, t1);
        Keys.ExpressionKeys ek2 = new Keys.ExpressionKeys(0, (TypeInformation)t2);
        ek1.areCompatible((Keys)ek2);
    }

    @Test
    public void testAreCompatible8() throws Keys.IncompatibleKeysException {
        BasicTypeInfo t1 = BasicTypeInfo.STRING_TYPE_INFO;
        TypeInformation t2 = TypeExtractor.getForClass(Pojo2.class);
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys("*", (TypeInformation)t1);
        Keys.SelectorFunctionKeys ek2 = new Keys.SelectorFunctionKeys((KeySelector)new SelectorFunctionKeysTest.KeySelector1(), t2, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertTrue((boolean)ek1.areCompatible((Keys)ek2));
    }

    @Test
    public void testAreCompatible9() throws Keys.IncompatibleKeysException {
        TupleTypeInfo t1 = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});
        TypeInformation t2 = TypeExtractor.getForClass(PojoWithMultiplePojos.class);
        Keys.ExpressionKeys ek1 = new Keys.ExpressionKeys(new int[]{2, 0}, (TypeInformation)t1);
        Keys.SelectorFunctionKeys ek2 = new Keys.SelectorFunctionKeys((KeySelector)new SelectorFunctionKeysTest.KeySelector3(), t2, (TypeInformation)new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.STRING_TYPE_INFO}));
        Assert.assertTrue((boolean)ek1.areCompatible((Keys)ek2));
    }

    public static class GenericKeyType
    implements Comparable<GenericNonKeyType> {
        private String a;
        private String b;

        @Override
        public int compareTo(GenericNonKeyType o) {
            return 0;
        }
    }

    public static class GenericNonKeyType {
        private String a;
        private String b;
    }

    public static class PojoWithNonKeyField {
        public String a;
        public GenericNonKeyType b;
    }

    public static class PojoWithMultiplePojos {
        public Pojo1 p1;
        public Pojo2 p2;
        public Integer i0;
    }

    public static class Pojo2 {
        public String a2;
        public String b2;
    }

    public static class Pojo1 {
        public String a;
        public String b;
    }
}

