/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.util.TestIOData;
import org.apache.flink.api.common.operators.util.TestNonRichInputFormat;
import org.apache.flink.api.common.operators.util.TestRichInputFormat;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.junit.Assert;
import org.junit.Test;

public class GenericDataSourceBaseTest
implements Serializable {
    @Test
    public void testDataSourcePlain() {
        try {
            TestNonRichInputFormat in = new TestNonRichInputFormat();
            GenericDataSourceBase source = new GenericDataSourceBase((InputFormat)in, new OperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), "testSource");
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultMutableSafe = source.executeOnCollections(null, executionConfig);
            in.reset();
            executionConfig.enableObjectReuse();
            List resultRegular = source.executeOnCollections(null, executionConfig);
            Assert.assertEquals(Arrays.asList(TestIOData.NAMES), (Object)resultMutableSafe);
            Assert.assertEquals(Arrays.asList(TestIOData.NAMES), (Object)resultRegular);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDataSourceWithRuntimeContext() {
        try {
            TestRichInputFormat in = new TestRichInputFormat();
            GenericDataSourceBase source = new GenericDataSourceBase((InputFormat)in, new OperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), "testSource");
            HashMap accumulatorMap = new HashMap();
            HashMap cpTasks = new HashMap();
            TaskInfo taskInfo = new TaskInfo("test_source", 1, 0, 1, 0);
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            Assert.assertEquals((Object)false, (Object)in.hasBeenClosed());
            Assert.assertEquals((Object)false, (Object)in.hasBeenOpened());
            List resultMutableSafe = source.executeOnCollections((RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            Assert.assertEquals((Object)true, (Object)in.hasBeenClosed());
            Assert.assertEquals((Object)true, (Object)in.hasBeenOpened());
            in.reset();
            executionConfig.enableObjectReuse();
            Assert.assertEquals((Object)false, (Object)in.hasBeenClosed());
            Assert.assertEquals((Object)false, (Object)in.hasBeenOpened());
            List resultRegular = source.executeOnCollections((RuntimeContext)new RuntimeUDFContext(taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            Assert.assertEquals((Object)true, (Object)in.hasBeenClosed());
            Assert.assertEquals((Object)true, (Object)in.hasBeenOpened());
            Assert.assertEquals(Arrays.asList(TestIOData.RICH_NAMES), (Object)resultMutableSafe);
            Assert.assertEquals(Arrays.asList(TestIOData.RICH_NAMES), (Object)resultRegular);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

