/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.Collections;
import org.apache.flink.api.common.operators.SlotSharingGroup;
import org.apache.flink.configuration.MemorySize;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SlotSharingGroupTest {
    @Test
    public void testBuildSlotSharingGroupWithSpecificResource() {
        String name = "ssg";
        MemorySize heap = MemorySize.ofMebiBytes((long)100L);
        MemorySize offHeap = MemorySize.ofMebiBytes((long)200L);
        MemorySize managed = MemorySize.ofMebiBytes((long)300L);
        SlotSharingGroup slotSharingGroup = SlotSharingGroup.newBuilder((String)"ssg").setCpuCores(1.0).setTaskHeapMemory(heap).setTaskOffHeapMemory(offHeap).setManagedMemory(managed).setExternalResource("gpu", 1.0).build();
        MatcherAssert.assertThat((Object)slotSharingGroup.getName(), (Matcher)Matchers.is((Object)"ssg"));
        MatcherAssert.assertThat(slotSharingGroup.getCpuCores().get(), (Matcher)Matchers.is((Object)1.0));
        MatcherAssert.assertThat(slotSharingGroup.getTaskHeapMemory().get(), (Matcher)Matchers.is((Object)heap));
        MatcherAssert.assertThat(slotSharingGroup.getTaskOffHeapMemory().get(), (Matcher)Matchers.is((Object)offHeap));
        MatcherAssert.assertThat(slotSharingGroup.getManagedMemory().get(), (Matcher)Matchers.is((Object)managed));
        MatcherAssert.assertThat((Object)slotSharingGroup.getExternalResources(), (Matcher)Matchers.is(Collections.singletonMap("gpu", 1.0)));
    }

    @Test
    public void testBuildSlotSharingGroupWithUnknownResource() {
        String name = "ssg";
        SlotSharingGroup slotSharingGroup = SlotSharingGroup.newBuilder((String)"ssg").build();
        MatcherAssert.assertThat((Object)slotSharingGroup.getName(), (Matcher)Matchers.is((Object)"ssg"));
        Assert.assertFalse((boolean)slotSharingGroup.getCpuCores().isPresent());
        Assert.assertFalse((boolean)slotSharingGroup.getTaskHeapMemory().isPresent());
        Assert.assertFalse((boolean)slotSharingGroup.getManagedMemory().isPresent());
        Assert.assertFalse((boolean)slotSharingGroup.getTaskOffHeapMemory().isPresent());
        Assert.assertTrue((boolean)slotSharingGroup.getExternalResources().isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuildSlotSharingGroupWithIllegalConfig() {
        SlotSharingGroup.newBuilder((String)"ssg").setCpuCores(1.0).setTaskHeapMemory(MemorySize.ZERO).setTaskOffHeapMemoryMB(10).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuildSlotSharingGroupWithoutAllRequiredConfig() {
        SlotSharingGroup.newBuilder((String)"ssg").setCpuCores(1.0).setTaskOffHeapMemoryMB(10).build();
    }
}

