/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ListStateDescriptorTest {
    @Test
    public void testListStateDescriptor() throws Exception {
        KryoSerializer serializer = new KryoSerializer(String.class, new ExecutionConfig());
        ListStateDescriptor descr = new ListStateDescriptor("testName", (TypeSerializer)serializer);
        Assert.assertEquals((Object)"testName", (Object)descr.getName());
        Assert.assertNotNull((Object)descr.getSerializer());
        Assert.assertTrue((boolean)(descr.getSerializer() instanceof ListSerializer));
        Assert.assertNotNull((Object)descr.getElementSerializer());
        Assert.assertEquals((Object)serializer, (Object)descr.getElementSerializer());
        ListStateDescriptor copy = (ListStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)descr);
        Assert.assertEquals((Object)"testName", (Object)copy.getName());
        Assert.assertNotNull((Object)copy.getSerializer());
        Assert.assertTrue((boolean)(copy.getSerializer() instanceof ListSerializer));
        Assert.assertNotNull((Object)copy.getElementSerializer());
        Assert.assertEquals((Object)serializer, (Object)copy.getElementSerializer());
    }

    @Test
    public void testHashCodeEquals() throws Exception {
        String name = "testName";
        ListStateDescriptor original = new ListStateDescriptor("testName", String.class);
        ListStateDescriptor same = new ListStateDescriptor("testName", String.class);
        ListStateDescriptor sameBySerializer = new ListStateDescriptor("testName", (TypeSerializer)StringSerializer.INSTANCE);
        Assert.assertEquals((long)original.hashCode(), (long)same.hashCode());
        Assert.assertEquals((long)original.hashCode(), (long)sameBySerializer.hashCode());
        Assert.assertEquals((Object)original, (Object)same);
        Assert.assertEquals((Object)original, (Object)sameBySerializer);
        ListStateDescriptor clone = (ListStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assert.assertEquals((Object)original, (Object)clone);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals((Object)original, (Object)clone);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals((Object)original, (Object)same);
    }

    @Test
    public void testSerializerDuplication() {
        KryoSerializer statefulSerializer = new KryoSerializer(String.class, new ExecutionConfig());
        ListStateDescriptor descr = new ListStateDescriptor("foobar", (TypeSerializer)statefulSerializer);
        TypeSerializer serializerA = descr.getElementSerializer();
        TypeSerializer serializerB = descr.getElementSerializer();
        Assert.assertNotSame((Object)serializerA, (Object)serializerB);
        TypeSerializer listSerializerA = descr.getSerializer();
        TypeSerializer listSerializerB = descr.getSerializer();
        Assert.assertNotSame((Object)listSerializerA, (Object)listSerializerB);
    }
}

