/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class ListSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<List<String>, List<String>> {
    private static final String SPEC_NAME = "list-serializer";

    ListSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification(SPEC_NAME, flinkVersion, ListSerializerSetup.class, ListSerializerVerifier.class));
        }
        return testSpecifications;
    }

    public static final class ListSerializerVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<List<String>> {
        @Override
        public TypeSerializer<List<String>> createUpgradedSerializer() {
            return new ListSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public Matcher<List<String>> testDataMatcher() {
            ArrayList<String> data = new ArrayList<String>(2);
            data.add("Apache");
            data.add("Flink");
            return Matchers.is(data);
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<List<String>>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class ListSerializerSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<List<String>> {
        @Override
        public TypeSerializer<List<String>> createPriorSerializer() {
            return new ListSerializer((TypeSerializer)StringSerializer.INSTANCE);
        }

        @Override
        public List<String> createTestData() {
            ArrayList<String> data = new ArrayList<String>(2);
            data.add("Apache");
            data.add("Flink");
            return data;
        }
    }
}

