/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.connector.source.mocks;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.connector.source.SourceSplit;

public class MockSourceSplit
implements SourceSplit,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int id;
    private final BlockingQueue<Integer> records;
    private final int endIndex;
    private int index;

    public MockSourceSplit(int id) {
        this(id, 0);
    }

    public MockSourceSplit(int id, int startingIndex) {
        this(id, startingIndex, Integer.MAX_VALUE);
    }

    public MockSourceSplit(int id, int startingIndex, int endIndex) {
        this.id = id;
        this.endIndex = endIndex;
        this.index = startingIndex;
        this.records = new LinkedBlockingQueue<Integer>();
    }

    public String splitId() {
        return Integer.toString(this.id);
    }

    public int index() {
        return this.index;
    }

    public int endIndex() {
        return this.endIndex;
    }

    public boolean isAvailable() {
        return !this.isFinished() && !this.records.isEmpty();
    }

    public boolean isFinished() {
        return this.index == this.endIndex;
    }

    public int[] getNext(boolean blocking) throws InterruptedException {
        int[] nArray;
        Integer value;
        Integer n = value = blocking ? this.records.take() : (Integer)this.records.poll();
        if (value == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = value;
            nArray = nArray2;
            nArray2[1] = this.index++;
        }
        return nArray;
    }

    public void addRecord(int record) {
        if (!this.records.offer(record)) {
            throw new IllegalStateException("Failed to add record to split.");
        }
    }

    public int hashCode() {
        return Objects.hash(this.id, Arrays.hashCode((Object[])this.records.toArray(new Integer[0])), this.endIndex, this.index);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MockSourceSplit)) {
            return false;
        }
        MockSourceSplit that = (MockSourceSplit)obj;
        return this.id == that.id && this.index == that.index && Arrays.equals((Object[])this.records.toArray(new Integer[0]), (Object[])that.records.toArray(new Integer[0])) && this.endIndex == that.endIndex;
    }

    public String toString() {
        return String.format("MockSourceSplit(id=%d, num_records=%d, endIndex=%d, currentIndex=%d)", this.id, this.records.size(), this.endIndex, this.index);
    }
}

