/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.dag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransformationTest
extends TestLogger {
    private Transformation<Void> transformation;

    @Before
    public void setUp() {
        this.transformation = new TestTransformation<Void>("t", null, 1);
    }

    @Test
    public void testGetNewNodeIdIsThreadSafe() throws Exception {
        int numThreads = 10;
        int numIdsPerThread = 100;
        ArrayList<1> threads = new ArrayList<1>();
        final OneShotLatch startLatch = new OneShotLatch();
        final List idLists = Collections.synchronizedList(new ArrayList());
        for (int x = 0; x < 10; ++x) {
            threads.add(new CheckedThread(){

                public void go() throws Exception {
                    startLatch.await();
                    ArrayList<Integer> ids = new ArrayList<Integer>();
                    for (int c = 0; c < 100; ++c) {
                        ids.add(Transformation.getNewNodeId());
                    }
                    idLists.add(ids);
                }
            });
        }
        threads.forEach(Thread::start);
        startLatch.trigger();
        for (CheckedThread checkedThread : threads) {
            checkedThread.sync();
        }
        Set deduplicatedIds = idLists.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Assert.assertEquals((long)1000L, (long)deduplicatedIds.size());
    }

    @Test
    public void testDeclareManagedMemoryUseCase() {
        this.transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, 123);
        this.transformation.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.STATE_BACKEND);
        Assert.assertThat(this.transformation.getManagedMemoryOperatorScopeUseCaseWeights().get(ManagedMemoryUseCase.OPERATOR), (Matcher)Matchers.is((Object)123));
        Assert.assertThat((Object)this.transformation.getManagedMemorySlotScopeUseCases(), (Matcher)Matchers.contains((Object[])new ManagedMemoryUseCase[]{ManagedMemoryUseCase.STATE_BACKEND}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeclareManagedMemoryOperatorScopeUseCaseFailWrongScope() {
        this.transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.PYTHON, 123);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeclareManagedMemoryOperatorScopeUseCaseFailZeroWeight() {
        this.transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeclareManagedMemoryOperatorScopeUseCaseFailNegativeWeight() {
        this.transformation.declareManagedMemoryUseCaseAtOperatorScope(ManagedMemoryUseCase.OPERATOR, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeclareManagedMemorySlotScopeUseCaseFailWrongScope() {
        this.transformation.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.OPERATOR);
    }

    private static class TestTransformation<T>
    extends Transformation<T> {
        public TestTransformation(String name, TypeInformation<T> outputType, int parallelism) {
            super(name, outputType, parallelism);
        }

        public List<Transformation<?>> getTransitivePredecessors() {
            return Collections.emptyList();
        }

        public List<Transformation<?>> getInputs() {
            return Collections.emptyList();
        }
    }
}

