/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.ValueTypeInfo;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Value;
import org.junit.Assert;
import org.junit.Test;

public class PojoTypeExtractionTest {
    @Test
    public void testDuplicateFieldException() {
        TypeInformation ti = TypeExtractor.createTypeInfo(HasDuplicateField.class);
        Assert.assertTrue((boolean)(ti instanceof GenericTypeInfo));
    }

    @Test
    public void testPojoWithGenericFields() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(PojoWithGenericFields.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
    }

    @Test
    public void testIncorrectPojos() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(IncorrectPojo.class);
        Assert.assertTrue((boolean)(typeForClass instanceof GenericTypeInfo));
        typeForClass = TypeExtractor.createTypeInfo(WrongCtorPojo.class);
        Assert.assertTrue((boolean)(typeForClass instanceof GenericTypeInfo));
    }

    @Test
    public void testCorrectPojos() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(BeanStylePojo.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
        typeForClass = TypeExtractor.createTypeInfo(TypedPojoGetterSetterCheck.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
    }

    @Test
    public void testPojoWC() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(WC.class);
        this.checkWCPojoAsserts(typeForClass);
        WC t = new WC();
        t.complex = new ComplexNestedClass();
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)t);
        this.checkWCPojoAsserts(typeForObject);
    }

    private void checkWCPojoAsserts(TypeInformation<?> typeInfo) {
        int pos;
        Assert.assertFalse((boolean)typeInfo.isBasicType());
        Assert.assertFalse((boolean)typeInfo.isTupleType());
        Assert.assertEquals((long)10L, (long)typeInfo.getTotalFields());
        Assert.assertTrue((boolean)(typeInfo instanceof PojoTypeInfo));
        PojoTypeInfo pojoType = (PojoTypeInfo)typeInfo;
        ArrayList ffd = new ArrayList();
        String[] fields = new String[]{"count", "complex.date", "complex.collection", "complex.nothing", "complex.someFloat", "complex.someNumberWith\u00dcnic\u00f6deN\u00e4me", "complex.valueType", "complex.word.f0", "complex.word.f1", "complex.word.f2"};
        int[] positions = new int[]{9, 1, 0, 2, 3, 4, 5, 6, 7, 8};
        Assert.assertEquals((long)fields.length, (long)positions.length);
        for (int i = 0; i < fields.length; ++i) {
            pojoType.getFlatFields(fields[i], 0, ffd);
            Assert.assertEquals((String)"Too many keys returned", (long)1L, (long)ffd.size());
            Assert.assertEquals((String)("position of field " + fields[i] + " wrong"), (long)positions[i], (long)((CompositeType.FlatFieldDescriptor)ffd.get(0)).getPosition());
            ffd.clear();
        }
        pojoType.getFlatFields("complex.word.*", 0, ffd);
        Assert.assertEquals((long)3L, (long)ffd.size());
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            pos = ffdE.getPosition();
            Assert.assertTrue((pos <= 8 ? 1 : 0) != 0);
            Assert.assertTrue((6 <= pos ? 1 : 0) != 0);
            if (pos == 6) {
                Assert.assertEquals(Long.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 7) {
                Assert.assertEquals(Long.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos != 8) continue;
            Assert.assertEquals(String.class, (Object)ffdE.getType().getTypeClass());
        }
        ffd.clear();
        pojoType.getFlatFields("complex.word._", 0, ffd);
        Assert.assertEquals((long)3L, (long)ffd.size());
        ffd.clear();
        pojoType.getFlatFields("complex.*", 0, ffd);
        Assert.assertEquals((long)9L, (long)ffd.size());
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            pos = ffdE.getPosition();
            Assert.assertTrue((ffdE.getPosition() <= 8 ? 1 : 0) != 0);
            Assert.assertTrue((0 <= ffdE.getPosition() ? 1 : 0) != 0);
            if (pos == 0) {
                Assert.assertEquals(List.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 1) {
                Assert.assertEquals(Date.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 2) {
                Assert.assertEquals(Object.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 3) {
                Assert.assertEquals(Float.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 4) {
                Assert.assertEquals(Integer.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 5) {
                Assert.assertEquals(MyValue.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 6) {
                Assert.assertEquals(Long.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 7) {
                Assert.assertEquals(Long.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos == 8) {
                Assert.assertEquals(String.class, (Object)ffdE.getType().getTypeClass());
            }
            if (pos != 9) continue;
            Assert.assertEquals(Integer.class, (Object)ffdE.getType().getTypeClass());
        }
        ffd.clear();
        pojoType.getFlatFields("*", 0, ffd);
        Assert.assertEquals((long)10L, (long)ffd.size());
        for (CompositeType.FlatFieldDescriptor ffdE : ffd) {
            Assert.assertTrue((ffdE.getPosition() <= 9 ? 1 : 0) != 0);
            Assert.assertTrue((0 <= ffdE.getPosition() ? 1 : 0) != 0);
            if (ffdE.getPosition() != 9) continue;
            Assert.assertEquals(Integer.class, (Object)ffdE.getType().getTypeClass());
        }
        ffd.clear();
        TypeInformation typeComplexNested = pojoType.getTypeAt(0);
        Assert.assertTrue((boolean)(typeComplexNested instanceof PojoTypeInfo));
        Assert.assertEquals((long)7L, (long)typeComplexNested.getArity());
        Assert.assertEquals((long)9L, (long)typeComplexNested.getTotalFields());
        PojoTypeInfo pojoTypeComplexNested = (PojoTypeInfo)typeComplexNested;
        boolean dateSeen = false;
        boolean intSeen = false;
        boolean floatSeen = false;
        boolean tupleSeen = false;
        boolean objectSeen = false;
        boolean writableSeen = false;
        boolean collectionSeen = false;
        for (int i = 0; i < pojoTypeComplexNested.getArity(); ++i) {
            PojoField field = pojoTypeComplexNested.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("date")) {
                if (dateSeen) {
                    Assert.fail((String)"already seen");
                }
                dateSeen = true;
                Assert.assertEquals((Object)BasicTypeInfo.DATE_TYPE_INFO, (Object)field.getTypeInformation());
                Assert.assertEquals(Date.class, (Object)field.getTypeInformation().getTypeClass());
                continue;
            }
            if (name.equals("someNumberWith\u00dcnic\u00f6deN\u00e4me")) {
                if (intSeen) {
                    Assert.fail((String)"already seen");
                }
                intSeen = true;
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.getTypeInformation());
                Assert.assertEquals(Integer.class, (Object)field.getTypeInformation().getTypeClass());
                continue;
            }
            if (name.equals("someFloat")) {
                if (floatSeen) {
                    Assert.fail((String)"already seen");
                }
                floatSeen = true;
                Assert.assertEquals((Object)BasicTypeInfo.FLOAT_TYPE_INFO, (Object)field.getTypeInformation());
                Assert.assertEquals(Float.class, (Object)field.getTypeInformation().getTypeClass());
                continue;
            }
            if (name.equals("word")) {
                if (tupleSeen) {
                    Assert.fail((String)"already seen");
                }
                tupleSeen = true;
                Assert.assertTrue((boolean)(field.getTypeInformation() instanceof TupleTypeInfo));
                Assert.assertEquals(Tuple3.class, (Object)field.getTypeInformation().getTypeClass());
                TupleTypeInfo tupleTypeFromComplexNested = (TupleTypeInfo)field.getTypeInformation();
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tupleTypeFromComplexNested.getTypeAt(0));
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)tupleTypeFromComplexNested.getTypeAt(1));
                Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)tupleTypeFromComplexNested.getTypeAt(2));
                continue;
            }
            if (name.equals("nothing")) {
                if (objectSeen) {
                    Assert.fail((String)"already seen");
                }
                objectSeen = true;
                Assert.assertEquals((Object)new GenericTypeInfo(Object.class), (Object)field.getTypeInformation());
                Assert.assertEquals(Object.class, (Object)field.getTypeInformation().getTypeClass());
                continue;
            }
            if (name.equals("valueType")) {
                if (writableSeen) {
                    Assert.fail((String)"already seen");
                }
                writableSeen = true;
                Assert.assertEquals((Object)new ValueTypeInfo(MyValue.class), (Object)field.getTypeInformation());
                Assert.assertEquals(MyValue.class, (Object)field.getTypeInformation().getTypeClass());
                continue;
            }
            if (name.equals("collection")) {
                if (collectionSeen) {
                    Assert.fail((String)"already seen");
                }
                collectionSeen = true;
                Assert.assertEquals((Object)new GenericTypeInfo(List.class), (Object)field.getTypeInformation());
                continue;
            }
            Assert.fail((String)("field " + field + " is not expected"));
        }
        Assert.assertTrue((String)"Field was not present", (boolean)dateSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)intSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)floatSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)tupleSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)objectSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)writableSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)collectionSeen);
        TypeInformation typeAtOne = pojoType.getTypeAt(1);
        Assert.assertTrue((boolean)(typeAtOne instanceof BasicTypeInfo));
        Assert.assertEquals((Object)typeInfo.getTypeClass(), WC.class);
        Assert.assertEquals((long)typeInfo.getArity(), (long)2L);
    }

    @Test
    public void testPojoAllPublic() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(AllPublic.class);
        this.checkAllPublicAsserts(typeForClass);
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)new AllPublic());
        this.checkAllPublicAsserts(typeForObject);
    }

    private void checkAllPublicAsserts(TypeInformation<?> typeInformation) {
        Assert.assertTrue((boolean)(typeInformation instanceof PojoTypeInfo));
        Assert.assertEquals((long)10L, (long)typeInformation.getArity());
        Assert.assertEquals((long)12L, (long)typeInformation.getTotalFields());
        boolean arrayListSeen = false;
        boolean multisetSeen = false;
        boolean strArraySeen = false;
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeInformation;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("somethingFancy")) {
                if (arrayListSeen) {
                    Assert.fail((String)"already seen");
                }
                arrayListSeen = true;
                Assert.assertTrue((boolean)(field.getTypeInformation() instanceof GenericTypeInfo));
                Assert.assertEquals(ArrayList.class, (Object)field.getTypeInformation().getTypeClass());
                continue;
            }
            if (name.equals("fancyIds")) {
                if (multisetSeen) {
                    Assert.fail((String)"already seen");
                }
                multisetSeen = true;
                Assert.assertTrue((boolean)(field.getTypeInformation() instanceof GenericTypeInfo));
                Assert.assertEquals(FancyCollectionSubtype.class, (Object)field.getTypeInformation().getTypeClass());
                continue;
            }
            if (name.equals("fancyArray")) {
                if (strArraySeen) {
                    Assert.fail((String)"already seen");
                }
                strArraySeen = true;
                Assert.assertEquals((Object)BasicArrayTypeInfo.STRING_ARRAY_TYPE_INFO, (Object)field.getTypeInformation());
                Assert.assertEquals(String[].class, (Object)field.getTypeInformation().getTypeClass());
                continue;
            }
            if (Arrays.asList("date", "someNumberWith\u00dcnic\u00f6deN\u00e4me", "someFloat", "word", "nothing", "valueType", "collection").contains(name)) continue;
            Assert.fail((String)("field " + field + " is not expected"));
        }
        Assert.assertTrue((String)"Field was not present", (boolean)arrayListSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)multisetSeen);
        Assert.assertTrue((String)"Field was not present", (boolean)strArraySeen);
    }

    @Test
    public void testPojoExtendingTuple() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(FromTuple.class);
        this.checkFromTuplePojo(typeForClass);
        FromTuple ft = new FromTuple();
        ft.f0 = "";
        ft.f1 = "";
        ft.f2 = 0L;
        TypeInformation typeForObject = TypeExtractor.getForObject((Object)((Object)ft));
        this.checkFromTuplePojo(typeForObject);
    }

    private void checkFromTuplePojo(TypeInformation<?> typeInformation) {
        Assert.assertTrue((boolean)(typeInformation instanceof PojoTypeInfo));
        Assert.assertEquals((long)4L, (long)typeInformation.getTotalFields());
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeInformation;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("special")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("f0") || name.equals("f1")) {
                Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("f2")) {
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            Assert.fail((String)"unexpected field");
        }
    }

    @Test
    public void testPojoWithGenerics() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(ParentSettingGenerics.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("field1")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("field2")) {
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("field3")) {
                Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("key")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            Assert.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    public void testPojoWithGenericsSomeFieldsGeneric() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(PojoWithGenerics.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("field1")) {
                Assert.assertEquals((Object)new GenericTypeInfo(Object.class), (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("field2")) {
                Assert.assertEquals((Object)new GenericTypeInfo(Object.class), (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("key")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            Assert.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    public void testPojoWithComplexHierarchy() {
        TypeInformation typeForClass = TypeExtractor.createTypeInfo(ComplexHierarchyTop.class);
        Assert.assertTrue((boolean)(typeForClass instanceof PojoTypeInfo));
        PojoTypeInfo pojoTypeForClass = (PojoTypeInfo)typeForClass;
        for (int i = 0; i < pojoTypeForClass.getArity(); ++i) {
            PojoField field = pojoTypeForClass.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("field1")) {
                Assert.assertTrue((boolean)(field.getTypeInformation() instanceof PojoTypeInfo));
                continue;
            }
            if (name.equals("field2")) {
                Assert.assertTrue((boolean)(field.getTypeInformation() instanceof TupleTypeInfo));
                Assert.assertTrue((boolean)((TupleTypeInfo)field.getTypeInformation()).getTypeAt(0).equals((Object)BasicTypeInfo.STRING_TYPE_INFO));
                continue;
            }
            if (name.equals("key")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            Assert.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    public void testGenericPojoTypeInference1() {
        MyMapper function = new MyMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithGenerics<Long, String>>(){}));
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        for (int i = 0; i < pti.getArity(); ++i) {
            PojoField field = pti.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("field1")) {
                Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("field2")) {
                Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("key")) {
                Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            Assert.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    public void testGenericPojoTypeInference2() {
        MyMapper2 function = new MyMapper2();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<Tuple2<Character, Boolean>>(){}));
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        for (int i = 0; i < pti.getArity(); ++i) {
            PojoField field = pti.getPojoFieldAt(i);
            String name = field.getField().getName();
            if (name.equals("extraField")) {
                Assert.assertEquals((Object)BasicTypeInfo.CHAR_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("f0")) {
                Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("f1")) {
                Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            if (name.equals("f2")) {
                Assert.assertEquals((Object)BasicTypeInfo.LONG_TYPE_INFO, (Object)field.getTypeInformation());
                continue;
            }
            Assert.fail((String)("Unexpected field " + field));
        }
    }

    @Test
    public void testGenericPojoTypeInference3() {
        MyMapper3 function = new MyMapper3();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoTuple<Character, Boolean, Boolean>>(){}));
        Assert.assertTrue((boolean)(ti instanceof TupleTypeInfo));
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.CHAR_TYPE_INFO, (Object)tti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)tti.getTypeAt(1));
    }

    @Test
    public void testGenericPojoTypeInference4() {
        MyMapper4 function = new MyMapper4();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithParameterizedFields1<Byte>>(){}));
        Assert.assertEquals((Object)BasicTypeInfo.BYTE_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testGenericPojoTypeInference5() {
        MyMapper5 function = new MyMapper5();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithParameterizedFields2<Byte>>(){}));
        Assert.assertEquals((Object)BasicTypeInfo.BYTE_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testGenericPojoTypeInference6() {
        MyMapper6 function = new MyMapper6();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithParameterizedFields3<Integer>>(){}));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testGenericPojoTypeInference7() {
        MyMapper7 function = new MyMapper7();
        TypeInformation ti = TypeExtractor.getMapReturnTypes(function, (TypeInformation)TypeInformation.of((TypeHint)new TypeHint<PojoWithParameterizedFields4<Integer>>(){}));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testRecursivePojo1() {
        TypeInformation ti = TypeExtractor.createTypeInfo(RecursivePojo1.class);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        Assert.assertEquals(GenericTypeInfo.class, ((PojoTypeInfo)ti).getPojoFieldAt(0).getTypeInformation().getClass());
    }

    @Test
    public void testRecursivePojo2() {
        TypeInformation ti = TypeExtractor.createTypeInfo(RecursivePojo2.class);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        PojoField pf = ((PojoTypeInfo)ti).getPojoFieldAt(0);
        Assert.assertTrue((boolean)(pf.getTypeInformation() instanceof TupleTypeInfo));
        Assert.assertEquals(GenericTypeInfo.class, ((TupleTypeInfo)pf.getTypeInformation()).getTypeAt(0).getClass());
    }

    @Test
    public void testRecursivePojo3() {
        TypeInformation ti = TypeExtractor.createTypeInfo(RecursivePojo3.class);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        PojoField pf = ((PojoTypeInfo)ti).getPojoFieldAt(0);
        Assert.assertTrue((boolean)(pf.getTypeInformation() instanceof PojoTypeInfo));
        Assert.assertEquals(GenericTypeInfo.class, ((PojoTypeInfo)pf.getTypeInformation()).getPojoFieldAt(0).getTypeInformation().getClass());
    }

    @Test
    public void testDualUseOfPojo() {
        DuplicateMapper function = new DuplicateMapper();
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)function, (TypeInformation)TypeExtractor.createTypeInfo(FooBarPojo.class));
        Assert.assertTrue((boolean)(ti instanceof TupleTypeInfo));
        TupleTypeInfo tti = (TupleTypeInfo)ti;
        Assert.assertTrue((boolean)(tti.getTypeAt(0) instanceof PojoTypeInfo));
        Assert.assertTrue((boolean)(tti.getTypeAt(1) instanceof PojoTypeInfo));
    }

    @Test
    public void testPojoWithRecursiveGenericField() {
        TypeInformation ti = TypeExtractor.createTypeInfo(PojoWithRecursiveGenericField.class);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        Assert.assertEquals(GenericTypeInfo.class, ((PojoTypeInfo)ti).getPojoFieldAt(0).getTypeInformation().getClass());
    }

    @Test
    public void testPojosWithMutualRecursion() {
        TypeInformation ti = TypeExtractor.createTypeInfo(MutualPojoB.class);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        TypeInformation pti = ((PojoTypeInfo)ti).getPojoFieldAt(0).getTypeInformation();
        Assert.assertTrue((boolean)(pti instanceof PojoTypeInfo));
        Assert.assertEquals(GenericTypeInfo.class, ((PojoTypeInfo)pti).getPojoFieldAt(0).getTypeInformation().getClass());
    }

    @Test
    public void testRecursivePojoWithTypeVariable() {
        TypeInformation ti = TypeExtractor.createTypeInfo(MyType.class);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        TypeInformation pti = ((PojoTypeInfo)ti).getPojoFieldAt(0).getTypeInformation();
        Assert.assertTrue((boolean)(pti instanceof PojoTypeInfo));
        Assert.assertEquals(GenericTypeInfo.class, ((PojoTypeInfo)pti).getPojoFieldAt(0).getTypeInformation().getClass());
    }

    @Test
    public void testLombokPojo() {
        TypeInformation ti = TypeExtractor.getForClass(TestLombok.class);
        Assert.assertTrue((boolean)(ti instanceof PojoTypeInfo));
        PojoTypeInfo pti = (PojoTypeInfo)ti;
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)pti.getTypeAt(0));
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)pti.getTypeAt(1));
    }

    public static class TestLombok {
        private int age = 10;
        private String name;

        public int getAge() {
            return this.age;
        }

        public String getName() {
            return this.name;
        }

        public void setAge(int age) {
            this.age = age;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class MyType
    extends Container<Container<Object>> {
    }

    public static class Container<T> {
        public T field;
    }

    public static class MutualPojoB {
        public MutualPojoA field;
    }

    public static class MutualPojoA {
        public MutualPojoB field;
    }

    public static class PojoWithRecursiveGenericField<K, V> {
        public PojoWithRecursiveGenericField<K, V> parent;
    }

    public static class DuplicateMapper
    implements MapFunction<FooBarPojo, Tuple2<FooBarPojo, FooBarPojo>> {
        public Tuple2<FooBarPojo, FooBarPojo> map(FooBarPojo value) throws Exception {
            return null;
        }
    }

    public static class FooBarPojo {
        public int foo;
        public int bar;
    }

    public static class NestedPojo {
        public RecursivePojo3 field;
    }

    public static class RecursivePojo3 {
        public NestedPojo field;
    }

    public static class RecursivePojo2 {
        public Tuple1<RecursivePojo2> field;
    }

    public static class RecursivePojo1 {
        public RecursivePojo1 field;
    }

    public static class PojoWithParameterizedFields4<Z> {
        public Tuple1<Z>[] field;
    }

    public static class MyMapper7<A>
    implements MapFunction<PojoWithParameterizedFields4<A>, A> {
        private static final long serialVersionUID = 1L;

        public A map(PojoWithParameterizedFields4<A> value) throws Exception {
            return null;
        }
    }

    public static class MyMapper6<A>
    implements MapFunction<PojoWithParameterizedFields3<A>, A> {
        private static final long serialVersionUID = 1L;

        public A map(PojoWithParameterizedFields3<A> value) throws Exception {
            return null;
        }
    }

    public static class PojoWithParameterizedFields3<Z> {
        public Z[] field;
    }

    public static class MyMapper5<A>
    implements MapFunction<PojoWithParameterizedFields2<A>, A> {
        private static final long serialVersionUID = 1L;

        public A map(PojoWithParameterizedFields2<A> value) throws Exception {
            return null;
        }
    }

    public static class PojoWithParameterizedFields2<Z> {
        public PojoWithGenerics<Z, Z> field;
    }

    public static class MyMapper4<A>
    implements MapFunction<PojoWithParameterizedFields1<A>, A> {
        private static final long serialVersionUID = 1L;

        public A map(PojoWithParameterizedFields1<A> value) throws Exception {
            return null;
        }
    }

    public static class PojoWithParameterizedFields1<Z> {
        public Tuple2<Z, Z> field;
    }

    public static class MyMapper3<D, E>
    implements MapFunction<PojoTuple<E, D, D>, Tuple2<E, D>> {
        private static final long serialVersionUID = 1L;

        public Tuple2<E, D> map(PojoTuple<E, D, D> value) throws Exception {
            return null;
        }
    }

    public static class MyMapper2<D, E>
    implements MapFunction<Tuple2<E, D>, PojoTuple<E, D, D>> {
        private static final long serialVersionUID = 1L;

        public PojoTuple<E, D, D> map(Tuple2<E, D> value) throws Exception {
            return null;
        }
    }

    public static class PojoTuple<A, B, C>
    extends Tuple3<B, C, Long> {
        private static final long serialVersionUID = 1L;
        public A extraField;
    }

    public static class MyMapper<T>
    implements MapFunction<PojoWithGenerics<Long, T>, PojoWithGenerics<T, T>> {
        private static final long serialVersionUID = 1L;

        public PojoWithGenerics<T, T> map(PojoWithGenerics<Long, T> value) throws Exception {
            return null;
        }
    }

    public static class GenericPojoGetterSetterCheck<T> {
        T packageProtected;

        public T getPackageProtected() {
            return this.packageProtected;
        }
    }

    public static class TypedPojoGetterSetterCheck
    extends GenericPojoGetterSetterCheck<String> {
        public void setPackageProtected(String in) {
            this.packageProtected = in;
        }
    }

    public static class PojoWithGenericFields {
        private Collection<String> users;
        private boolean favorited;

        public boolean isFavorited() {
            return this.favorited;
        }

        public void setFavorited(boolean favorited) {
            this.favorited = favorited;
        }

        public Collection<String> getUsers() {
            return this.users;
        }

        public void setUsers(Collection<String> users) {
            this.users = users;
        }
    }

    public static class WrongCtorPojo {
        public int a;

        public WrongCtorPojo(int a) {
            this.a = a;
        }
    }

    public static class BeanStylePojo {
        public String abc;
        private int field;

        public int getField() {
            return this.field;
        }

        public void setField(int f) {
            this.field = f;
        }
    }

    public static class IncorrectPojo {
        private int isPrivate;

        public int getIsPrivate() {
            return this.isPrivate;
        }
    }

    public static class FromTuple
    extends Tuple3<String, String, Long> {
        private static final long serialVersionUID = 1L;
        public int special;
    }

    public static class ComplexHierarchy<T>
    extends PojoWithGenerics<FromTuple, T> {
    }

    public static class ComplexHierarchyTop
    extends ComplexHierarchy<Tuple1<String>> {
    }

    public static class PojoWithGenerics<T1, T2> {
        public int key;
        public T1 field1;
        public T2 field2;
    }

    public static class ParentSettingGenerics
    extends PojoWithGenerics<Integer, Long> {
        public String field3;
    }

    public static class FancyCollectionSubtype<T>
    extends HashSet<T> {
        private static final long serialVersionUID = -3494469602638179921L;
    }

    public static class AllPublic
    extends ComplexNestedClass {
        public ArrayList<String> somethingFancy;
        public FancyCollectionSubtype<Integer> fancyIds;
        public String[] fancyArray;
    }

    public static class ComplexNestedClass {
        public static int ignoreStaticField;
        public transient int ignoreTransientField;
        public Date date;
        public Integer someNumberWith\u00dcnic\u00f6deN\u00e4me;
        public float someFloat;
        public Tuple3<Long, Long, String> word;
        public Object nothing;
        public MyValue valueType;
        public List<String> collection;
    }

    public static class WC {
        public ComplexNestedClass complex;
        private int count;

        public int getCount() {
            return this.count;
        }

        public void setCount(int c) {
            this.count = c;
        }
    }

    public static class HasDuplicateField
    extends WC {
        private int count;
    }

    public static class MyValue
    implements Value {
        private static final long serialVersionUID = 8607223484689147046L;

        public void write(DataOutputView out) throws IOException {
        }

        public void read(DataInputView in) throws IOException {
        }
    }
}

