/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Assert;
import org.junit.Test;

public class PojoTypeInformationTest {
    @Test
    public void testSimplePojoTypeExtraction() {
        TypeInformation type = TypeExtractor.getForClass(SimplePojo.class);
        Assert.assertTrue((String)"Extracted type is not a composite/pojo type but should be.", (boolean)(type instanceof CompositeType));
    }

    @Test
    public void testNestedPojoTypeExtraction() {
        TypeInformation type = TypeExtractor.getForClass(NestedPojoOuter.class);
        Assert.assertTrue((String)"Extracted type is not a Pojo type but should be.", (boolean)(type instanceof CompositeType));
    }

    @Test
    public void testRecursivePojoTypeExtraction() {
        TypeInformation type = TypeExtractor.getForClass(Recursive1Pojo.class);
        Assert.assertTrue((String)"Extracted type is not a Pojo type but should be.", (boolean)(type instanceof CompositeType));
    }

    @Test
    public void testRecursivePojoObjectTypeExtraction() {
        TypeInformation type = TypeExtractor.getForObject((Object)new Recursive1Pojo());
        Assert.assertTrue((String)"Extracted type is not a Pojo type but should be.", (boolean)(type instanceof CompositeType));
    }

    public static class Recursive2Pojo {
        public String strField;
        public Recursive1Pojo rec;
    }

    public static class Recursive1Pojo {
        public Integer intField;
        public Recursive2Pojo rec;
    }

    public static class NestedPojoOuter {
        public Integer intField;
        public NestedPojoInner inner;
    }

    public static class NestedPojoInner {
        public String field;
    }

    public static class SimplePojo {
        public String str;
        public Boolean Bl;
        public boolean bl;
        public Byte Bt;
        public byte bt;
        public Short Shrt;
        public short shrt;
        public Integer Intgr;
        public int intgr;
        public Long Lng;
        public long lng;
        public Float Flt;
        public float flt;
        public Double Dbl;
        public double dbl;
        public Character Ch;
        public char ch;
        public int[] primIntArray;
        public Integer[] intWrapperArray;
    }
}

