/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.testutils.BlockerSync;
import org.apache.flink.core.testutils.CheckedThread;
import org.junit.Assert;
import org.junit.Test;

public class KryoSerializerConcurrencyTest {
    @Test
    public void testDuplicateSerializerWithDefaultSerializerClass() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.addDefaultKryoSerializer(WrappedString.class, TestSerializer.class);
        this.runDuplicateSerializerTest(executionConfig);
    }

    @Test
    public void testDuplicateSerializerWithDefaultSerializerInstance() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.addDefaultKryoSerializer(WrappedString.class, (Serializer)new TestSerializer());
        this.runDuplicateSerializerTest(executionConfig);
    }

    @Test
    public void testDuplicateSerializerWithRegisteredSerializerClass() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.registerTypeWithKryoSerializer(WrappedString.class, TestSerializer.class);
        this.runDuplicateSerializerTest(executionConfig);
    }

    @Test
    public void testDuplicateSerializerWithRegisteredSerializerInstance() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.registerTypeWithKryoSerializer(WrappedString.class, (Serializer)new TestSerializer());
        this.runDuplicateSerializerTest(executionConfig);
    }

    private void runDuplicateSerializerTest(ExecutionConfig executionConfig) {
        KryoSerializer original = new KryoSerializer(WrappedString.class, executionConfig);
        KryoSerializer duplicate = original.duplicate();
        WrappedString testString = new WrappedString("test");
        String copyWithOriginal = ((WrappedString)original.copy((Object)testString)).content;
        String copyWithDuplicate = ((WrappedString)duplicate.copy((Object)testString)).content;
        Assert.assertTrue((boolean)copyWithOriginal.startsWith(testString.content));
        Assert.assertTrue((boolean)copyWithDuplicate.startsWith(testString.content));
        Assert.assertNotEquals((Object)copyWithOriginal, (Object)copyWithDuplicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentUseOfSerializer() throws Exception {
        final KryoSerializer serializer = new KryoSerializer(String.class, new ExecutionConfig());
        BlockerSync sync = new BlockerSync();
        DataOutputSerializer regularOut = new DataOutputSerializer(32);
        LockingView lockingOut = new LockingView(sync);
        CheckedThread thread = new CheckedThread("serializer", (DataOutputView)lockingOut){
            final /* synthetic */ DataOutputView val$lockingOut;
            {
                this.val$lockingOut = dataOutputView;
                super(x0);
            }

            public void go() throws Exception {
                serializer.serialize((Object)"a value", this.val$lockingOut);
            }
        };
        thread.start();
        sync.awaitBlocker();
        try {
            serializer.serialize((Object)"value", (DataOutputView)regularOut);
            Assert.fail((String)"should have failed with an exception");
        }
        catch (IllegalStateException illegalStateException) {
        }
        finally {
            sync.releaseBlocker();
        }
        thread.sync();
    }

    public static class TestSerializer
    extends Serializer<WrappedString>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public void write(Kryo kryo, Output output, WrappedString object) {
            output.writeString(object.content);
        }

        public WrappedString read(Kryo kryo, Input input, Class<WrappedString> type) {
            return new WrappedString(input.readString() + " " + System.identityHashCode(this));
        }
    }

    public static class WrappedString {
        private final String content;

        WrappedString(String content) {
            this.content = content;
        }

        public String toString() {
            return "WrappedString{content='" + this.content + '\'' + '}';
        }
    }

    private static class LockingView
    extends DataOutputSerializer {
        private final BlockerSync blocker;

        LockingView(BlockerSync blocker) {
            super(32);
            this.blocker = blocker;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.blocker.blockNonInterruptible();
        }
    }
}

