/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoPojosForMigrationTests;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

class KryoSerializerUpgradeTest
extends TypeSerializerUpgradeTestBase<Object, Object> {
    KryoSerializerUpgradeTest() {
    }

    @Override
    public Collection<TypeSerializerUpgradeTestBase.TestSpecification<?, ?>> createTestSpecifications() throws Exception {
        ArrayList testSpecifications = new ArrayList();
        for (FlinkVersion flinkVersion : MIGRATION_VERSIONS) {
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("kryo-type-serializer-empty-config", flinkVersion, KryoTypeSerializerEmptyConfigSetup.class, KryoTypeSerializerEmptyConfigVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("kryo-type-serializer-unrelated-config-after-restore", flinkVersion, KryoTypeSerializerEmptyConfigSetup.class, KryoTypeSerializerWithUnrelatedConfigVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("kryo-type-serializer-changed-registration-order", flinkVersion, KryoTypeSerializerChangedRegistrationOrderSetup.class, KryoTypeSerializerChangedRegistrationOrderVerifier.class));
            testSpecifications.add(new TypeSerializerUpgradeTestBase.TestSpecification("kryo-custom-type-serializer-changed-registration-order", flinkVersion, KryoCustomTypeSerializerChangedRegistrationOrderSetup.class, KryoCustomTypeSerializerChangedRegistrationOrderVerifier.class));
        }
        return testSpecifications;
    }

    public static final class DummyClassTwo {
    }

    public static final class DummyClassOne {
    }

    public static final class KryoCustomTypeSerializerChangedRegistrationOrderVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerKryoType(DummyClassOne.class);
            executionConfig.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Dog.class, KryoPojosForMigrationTests.DogV2KryoSerializer.class);
            executionConfig.registerKryoType(DummyClassTwo.class);
            executionConfig.registerKryoType(KryoPojosForMigrationTests.Cat.class);
            executionConfig.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Parrot.class, KryoPojosForMigrationTests.ParrotKryoSerializer.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, executionConfig);
        }

        @Override
        public Matcher<KryoPojosForMigrationTests.Animal> testDataMatcher() {
            return Matchers.is((Object)new KryoPojosForMigrationTests.Dog("Hasso"));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.hasSameCompatibilityAs(TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)new KryoSerializer(KryoPojosForMigrationTests.Animal.class, new ExecutionConfig())));
        }
    }

    public static final class KryoCustomTypeSerializerChangedRegistrationOrderSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createPriorSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Dog.class, KryoPojosForMigrationTests.DogKryoSerializer.class);
            executionConfig.registerKryoType(KryoPojosForMigrationTests.Cat.class);
            executionConfig.registerTypeWithKryoSerializer(KryoPojosForMigrationTests.Parrot.class, KryoPojosForMigrationTests.ParrotKryoSerializer.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, executionConfig);
        }

        @Override
        public KryoPojosForMigrationTests.Animal createTestData() {
            return new KryoPojosForMigrationTests.Dog("Hasso");
        }
    }

    public static final class KryoTypeSerializerChangedRegistrationOrderVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerKryoType(DummyClassOne.class);
            executionConfig.registerKryoType(KryoPojosForMigrationTests.Dog.class);
            executionConfig.registerKryoType(DummyClassTwo.class);
            executionConfig.registerKryoType(KryoPojosForMigrationTests.Cat.class);
            executionConfig.registerKryoType(KryoPojosForMigrationTests.Parrot.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, executionConfig);
        }

        @Override
        public Matcher<KryoPojosForMigrationTests.Animal> testDataMatcher() {
            return Matchers.is((Object)new KryoPojosForMigrationTests.Dog("Hasso"));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.hasSameCompatibilityAs(TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)new KryoSerializer(KryoPojosForMigrationTests.Animal.class, new ExecutionConfig())));
        }
    }

    public static final class KryoTypeSerializerChangedRegistrationOrderSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createPriorSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerKryoType(KryoPojosForMigrationTests.Dog.class);
            executionConfig.registerKryoType(KryoPojosForMigrationTests.Cat.class);
            executionConfig.registerKryoType(KryoPojosForMigrationTests.Parrot.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, executionConfig);
        }

        @Override
        public KryoPojosForMigrationTests.Animal createTestData() {
            return new KryoPojosForMigrationTests.Dog("Hasso");
        }
    }

    public static final class KryoTypeSerializerWithUnrelatedConfigVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerKryoType(DummyClassOne.class);
            executionConfig.registerTypeWithKryoSerializer(DummyClassTwo.class, DefaultSerializers.StringSerializer.class);
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, executionConfig);
        }

        @Override
        public Matcher<KryoPojosForMigrationTests.Animal> testDataMatcher() {
            return Matchers.is((Object)new KryoPojosForMigrationTests.Dog("Hasso"));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.hasSameCompatibilityAs(TypeSerializerSchemaCompatibility.compatibleWithReconfiguredSerializer((TypeSerializer)new KryoSerializer(KryoPojosForMigrationTests.Animal.class, new ExecutionConfig())));
        }
    }

    public static final class KryoTypeSerializerEmptyConfigVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createUpgradedSerializer() {
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, new ExecutionConfig());
        }

        @Override
        public Matcher<KryoPojosForMigrationTests.Animal> testDataMatcher() {
            return Matchers.is((Object)new KryoPojosForMigrationTests.Dog("Hasso"));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<KryoPojosForMigrationTests.Animal>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class KryoTypeSerializerEmptyConfigSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<KryoPojosForMigrationTests.Animal> {
        @Override
        public TypeSerializer<KryoPojosForMigrationTests.Animal> createPriorSerializer() {
            return new KryoSerializer(KryoPojosForMigrationTests.Animal.class, new ExecutionConfig());
        }

        @Override
        public KryoPojosForMigrationTests.Animal createTestData() {
            return new KryoPojosForMigrationTests.Dog("Hasso");
        }
    }
}

