/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class SecurityOptionsTest
extends TestLogger {
    @Test
    public void checkEnableSSL() {
        Configuration oldConf = new Configuration();
        oldConf.setBoolean(SecurityOptions.SSL_ENABLED, true);
        Assert.assertTrue((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)oldConf));
        Assert.assertTrue((boolean)SecurityOptions.isRestSSLEnabled((Configuration)oldConf));
        Configuration newOptions = new Configuration();
        newOptions.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, true);
        newOptions.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        Assert.assertTrue((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)newOptions));
        Assert.assertFalse((boolean)SecurityOptions.isRestSSLEnabled((Configuration)newOptions));
        Configuration precedence = new Configuration();
        precedence.setBoolean(SecurityOptions.SSL_ENABLED, true);
        precedence.setBoolean(SecurityOptions.SSL_INTERNAL_ENABLED, false);
        precedence.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        Assert.assertFalse((boolean)SecurityOptions.isInternalSSLEnabled((Configuration)precedence));
        Assert.assertFalse((boolean)SecurityOptions.isRestSSLEnabled((Configuration)precedence));
    }

    @Test
    public void checkEnableRestSSLAuthentication() {
        Configuration noSSLOptions = new Configuration();
        noSSLOptions.setBoolean(SecurityOptions.SSL_REST_ENABLED, false);
        noSSLOptions.setBoolean(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, true);
        Assert.assertFalse((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)noSSLOptions));
        Configuration defaultOptions = new Configuration();
        defaultOptions.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        Assert.assertFalse((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)defaultOptions));
        Configuration options = new Configuration();
        options.setBoolean(SecurityOptions.SSL_REST_ENABLED, true);
        options.setBoolean(SecurityOptions.SSL_REST_AUTHENTICATION_ENABLED, true);
        Assert.assertTrue((boolean)SecurityOptions.isRestSSLAuthenticationEnabled((Configuration)options));
    }
}

