/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class MemorySegmentTestBase {
    private final Random random = new Random();
    private final int pageSize;

    MemorySegmentTestBase(int pageSize) {
        this.pageSize = pageSize;
    }

    abstract MemorySegment createSegment(int var1);

    abstract MemorySegment createSegment(int var1, Object var2);

    @Test
    public void testByteAccess() {
        int pos;
        int i;
        int i2;
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.put(-1, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(this.pageSize, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MAX_VALUE, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MIN_VALUE, (byte)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(this.pageSize);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 < this.pageSize; ++i2) {
            segment.put(i2, (byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 < this.pageSize; ++i2) {
            Assert.assertEquals((long)((byte)this.random.nextInt()), (long)segment.get(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            segment.put(pos, (byte)this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            Assert.assertEquals((long)((byte)this.random.nextInt()), (long)segment.get(pos));
        }
    }

    @Test
    public void testBooleanAccess() {
        int pos;
        int i;
        int i2;
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.putBoolean(-1, false);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(this.pageSize, false);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(Integer.MAX_VALUE, false);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putBoolean(Integer.MIN_VALUE, false);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(this.pageSize);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getBoolean(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 < this.pageSize; ++i2) {
            segment.putBoolean(i2, this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 < this.pageSize; ++i2) {
            Assert.assertEquals((Object)this.random.nextBoolean(), (Object)segment.getBoolean(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            segment.putBoolean(pos, this.random.nextBoolean());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize);
            if (occupied[pos]) continue;
            occupied[pos] = true;
            Assert.assertEquals((Object)this.random.nextBoolean(), (Object)segment.getBoolean(pos));
        }
    }

    @Test
    public void testCopyUnsafeIndexOutOfBounds() {
        byte[] bytes = new byte[this.pageSize];
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.copyToUnsafe(1, (Object)bytes, 0, this.pageSize);
            Assert.fail((String)"should fail with an IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            segment.copyFromUnsafe(1, (Object)bytes, 0, this.pageSize);
            Assert.fail((String)"should fail with an IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testEqualTo() {
        MemorySegment seg1 = this.createSegment(this.pageSize);
        MemorySegment seg2 = this.createSegment(this.pageSize);
        byte[] referenceArray = new byte[this.pageSize];
        seg1.put(0, referenceArray);
        seg2.put(0, referenceArray);
        int i = new Random().nextInt(this.pageSize - 8);
        seg1.put(i, (byte)10);
        Assert.assertFalse((boolean)seg1.equalTo(seg2, i, i, 9));
        seg1.put(i, (byte)0);
        Assert.assertTrue((boolean)seg1.equalTo(seg2, i, i, 9));
        seg1.put(i + 8, (byte)10);
        Assert.assertFalse((boolean)seg1.equalTo(seg2, i, i, 9));
    }

    @Test
    public void testCharAccess() {
        int pos;
        int i;
        int i2;
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.putChar(-1, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(this.pageSize, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(Integer.MIN_VALUE, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(Integer.MAX_VALUE, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putChar(0x7FFFFFFE, 'a');
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(this.pageSize);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getChar(0x7FFFFFFE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 2; i2 += 2) {
            segment.putChar(i2, (char)this.random.nextInt(65535));
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 2; i2 += 2) {
            Assert.assertEquals((long)((char)this.random.nextInt(65535)), (long)segment.getChar(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            segment.putChar(pos, (char)this.random.nextInt(65535));
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            Assert.assertEquals((long)((char)this.random.nextInt(65535)), (long)segment.getChar(pos));
        }
    }

    @Test
    public void testShortAccess() {
        int pos;
        int i;
        int i2;
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.putShort(-1, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(this.pageSize, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(Integer.MIN_VALUE, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(Integer.MAX_VALUE, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putShort(0x7FFFFFFE, (short)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(this.pageSize);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getShort(0x7FFFFFFE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 2; i2 += 2) {
            segment.putShort(i2, (short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 2; i2 += 2) {
            Assert.assertEquals((long)((short)this.random.nextInt()), (long)segment.getShort(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            segment.putShort(pos, (short)this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 1);
            if (occupied[pos] || occupied[pos + 1]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            Assert.assertEquals((long)((short)this.random.nextInt()), (long)segment.getShort(pos));
        }
    }

    @Test
    public void testIntAccess() {
        int pos;
        int i;
        int i2;
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.putInt(-1, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(this.pageSize, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(this.pageSize - 3, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(Integer.MIN_VALUE, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(Integer.MAX_VALUE, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putInt(0x7FFFFFFC, 0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(this.pageSize);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(this.pageSize - 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getInt(0x7FFFFFFC);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 4; i2 += 4) {
            segment.putInt(i2, this.random.nextInt());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 4; i2 += 4) {
            Assert.assertEquals((long)this.random.nextInt(), (long)segment.getInt(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            segment.putInt(pos, this.random.nextInt());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            Assert.assertEquals((long)this.random.nextInt(), (long)segment.getInt(pos));
        }
    }

    @Test
    public void testLongAccess() {
        int pos;
        int i;
        int i2;
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.putLong(-1, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(this.pageSize, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(this.pageSize - 7, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(Integer.MIN_VALUE, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(Integer.MAX_VALUE, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putLong(0x7FFFFFF8, 0L);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(this.pageSize);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(this.pageSize - 7);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getLong(0x7FFFFFF8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 8; i2 += 8) {
            segment.putLong(i2, this.random.nextLong());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 8; i2 += 8) {
            Assert.assertEquals((long)this.random.nextLong(), (long)segment.getLong(i2));
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            segment.putLong(pos, this.random.nextLong());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            Assert.assertEquals((long)this.random.nextLong(), (long)segment.getLong(pos));
        }
    }

    @Test
    public void testFloatAccess() {
        int pos;
        int i;
        int i2;
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.putFloat(-1, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(this.pageSize, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(this.pageSize - 3, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(Integer.MIN_VALUE, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(Integer.MAX_VALUE, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putFloat(0x7FFFFFFC, 0.0f);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(this.pageSize);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(this.pageSize - 3);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getFloat(0x7FFFFFFC);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 4; i2 += 4) {
            segment.putFloat(i2, this.random.nextFloat());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 4; i2 += 4) {
            Assert.assertEquals((double)this.random.nextFloat(), (double)segment.getFloat(i2), (double)0.0);
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            segment.putFloat(pos, this.random.nextFloat());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 3);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            Assert.assertEquals((double)this.random.nextFloat(), (double)segment.getFloat(pos), (double)0.0);
        }
    }

    @Test
    public void testDoubleAccess() {
        int pos;
        int i;
        int i2;
        MemorySegment segment = this.createSegment(this.pageSize);
        try {
            segment.putDouble(-1, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(this.pageSize, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(this.pageSize - 7, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(Integer.MIN_VALUE, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(Integer.MAX_VALUE, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.putDouble(0x7FFFFFF8, 0.0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(this.pageSize);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(this.pageSize - 7);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(Integer.MIN_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(Integer.MAX_VALUE);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.getDouble(0x7FFFFFF8);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 8; i2 += 8) {
            segment.putDouble(i2, this.random.nextDouble());
        }
        this.random.setSeed(seed);
        for (i2 = 0; i2 <= this.pageSize - 8; i2 += 8) {
            Assert.assertEquals((double)this.random.nextDouble(), (double)segment.getDouble(i2), (double)0.0);
        }
        this.random.setSeed(seed);
        boolean[] occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            segment.putDouble(pos, this.random.nextDouble());
        }
        this.random.setSeed(seed);
        occupied = new boolean[this.pageSize];
        for (i = 0; i < 1000; ++i) {
            pos = this.random.nextInt(this.pageSize - 7);
            if (occupied[pos] || occupied[pos + 1] || occupied[pos + 2] || occupied[pos + 3] || occupied[pos + 4] || occupied[pos + 5] || occupied[pos + 6] || occupied[pos + 7]) continue;
            occupied[pos] = true;
            occupied[pos + 1] = true;
            occupied[pos + 2] = true;
            occupied[pos + 3] = true;
            occupied[pos + 4] = true;
            occupied[pos + 5] = true;
            occupied[pos + 6] = true;
            occupied[pos + 7] = true;
            Assert.assertEquals((double)this.random.nextDouble(), (double)segment.getDouble(pos), (double)0.0);
        }
    }

    @Test
    public void testBulkBytePutExceptions() {
        MemorySegment segment = this.createSegment(this.pageSize);
        byte[] bytes = new byte[this.pageSize / 4 + this.pageSize % 4];
        this.random.nextBytes(bytes);
        try {
            segment.put(-1, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(-1, bytes, 4, 5);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MIN_VALUE, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MIN_VALUE, bytes, 4, 5);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(this.pageSize, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(this.pageSize, bytes, 6, 44);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(this.pageSize - bytes.length + 1, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(this.pageSize - 5, bytes, 3, 6);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MAX_VALUE, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MAX_VALUE, bytes, 10, 20);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(Integer.MAX_VALUE - bytes.length + 1, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(0x7FFFFFF4, bytes, 11, 11);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(3 * (this.pageSize / 4) + 1, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(3 * (this.pageSize / 4) + 2, bytes, 0, bytes.length - 1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(7 * (this.pageSize / 8) + 1, bytes, 0, bytes.length / 2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(0, bytes, -1, 1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(0, bytes, -1, bytes.length + 1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(0, bytes, Integer.MIN_VALUE, bytes.length);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(0, bytes, Integer.MAX_VALUE, bytes.length);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(0, bytes, Integer.MAX_VALUE - bytes.length + 1, bytes.length);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.put(-2, bytes, -1, bytes.length / 2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
    }

    @Test
    public void testBulkByteGetExceptions() {
        MemorySegment segment = this.createSegment(this.pageSize);
        byte[] bytes = new byte[this.pageSize / 4];
        try {
            segment.get(-1, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-1, bytes, 4, 5);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MIN_VALUE, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MIN_VALUE, bytes, 4, 5);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(this.pageSize, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(this.pageSize, bytes, 6, 44);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(this.pageSize - bytes.length + 1, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(this.pageSize - 5, bytes, 3, 6);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MAX_VALUE, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MAX_VALUE, bytes, 10, 20);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(Integer.MAX_VALUE - bytes.length + 1, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0x7FFFFFF4, bytes, 11, 11);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(3 * (this.pageSize / 4) + 1, bytes);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(3 * (this.pageSize / 4) + 2, bytes, 0, bytes.length - 1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(7 * (this.pageSize / 8) + 1, bytes, 0, bytes.length / 2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0, bytes, -1, 1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0, bytes, -1, bytes.length + 1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0, bytes, Integer.MIN_VALUE, bytes.length);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0, bytes, Integer.MAX_VALUE, bytes.length);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(0, bytes, Integer.MAX_VALUE - bytes.length + 1, bytes.length);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            segment.get(-2, bytes, -1, bytes.length / 2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
    }

    @Test
    public void testBulkByteAccess() {
        int dataStartPos;
        byte[] data;
        int numBytes;
        MemorySegment segment = this.createSegment(this.pageSize);
        long seed = this.random.nextLong();
        this.random.setSeed(seed);
        byte[] src = new byte[this.pageSize / 8];
        for (int i = 0; i < 8; ++i) {
            this.random.nextBytes(src);
            segment.put(i * (this.pageSize / 8), src);
        }
        this.random.setSeed(seed);
        byte[] expected = new byte[this.pageSize / 8];
        byte[] actual = new byte[this.pageSize / 8];
        for (int i = 0; i < 8; ++i) {
            this.random.nextBytes(expected);
            segment.get(i * (this.pageSize / 8), actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
        segment = this.createSegment(this.pageSize);
        byte[] expected2 = new byte[this.pageSize];
        this.random.nextBytes(expected2);
        for (int i = 0; i < 16; ++i) {
            segment.put(i * (this.pageSize / 16), expected2, i * (this.pageSize / 16), this.pageSize / 16);
        }
        byte[] actual2 = new byte[this.pageSize];
        for (int i = 0; i < 16; ++i) {
            segment.get(i * (this.pageSize / 16), actual2, i * (this.pageSize / 16), this.pageSize / 16);
        }
        Assert.assertArrayEquals((byte[])expected2, (byte[])actual2);
        segment = this.createSegment(this.pageSize);
        expected2 = new byte[this.pageSize];
        segment.put(0, expected2, 0, this.pageSize);
        for (int i = 0; i < 200; ++i) {
            numBytes = this.random.nextInt(this.pageSize - 10) + 1;
            int pos = this.random.nextInt(this.pageSize - numBytes + 1);
            data = new byte[(this.random.nextInt(3) + 1) * numBytes];
            dataStartPos = this.random.nextInt(data.length - numBytes + 1);
            this.random.nextBytes(data);
            System.arraycopy(data, dataStartPos, expected2, pos, numBytes);
            segment.put(pos, data, dataStartPos, numBytes);
        }
        byte[] validation = new byte[this.pageSize];
        segment.get(0, validation);
        Assert.assertArrayEquals((byte[])expected2, (byte[])validation);
        segment = this.createSegment(this.pageSize);
        byte[] contents = new byte[this.pageSize];
        this.random.nextBytes(contents);
        segment.put(0, contents);
        for (int i = 0; i < 200; ++i) {
            numBytes = this.random.nextInt(this.pageSize / 8) + 1;
            int pos = this.random.nextInt(this.pageSize - numBytes + 1);
            data = new byte[(this.random.nextInt(3) + 1) * numBytes];
            dataStartPos = this.random.nextInt(data.length - numBytes + 1);
            segment.get(pos, data, dataStartPos, numBytes);
            byte[] expected3 = Arrays.copyOfRange(contents, pos, pos + numBytes);
            byte[] validation2 = Arrays.copyOfRange(data, dataStartPos, dataStartPos + numBytes);
            Assert.assertArrayEquals((byte[])expected3, (byte[])validation2);
        }
    }

    @Test
    public void testDataInputOutput() throws IOException {
        int len;
        int pos;
        int len2;
        MemorySegment seg = this.createSegment(this.pageSize);
        byte[] contents = new byte[this.pageSize];
        this.random.nextBytes(contents);
        seg.put(0, contents);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(this.pageSize);
        DataOutputStream out = new DataOutputStream(buffer);
        for (pos = 0; pos < this.pageSize; pos += len2) {
            len2 = this.random.nextInt(200);
            len2 = Math.min(len2, this.pageSize - pos);
            seg.get((DataOutput)out, pos, len2);
        }
        byte[] result = buffer.toByteArray();
        Assert.assertArrayEquals((byte[])contents, (byte[])result);
        MemorySegment reader = this.createSegment(this.pageSize);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(result));
        for (pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(200);
            len = Math.min(len, this.pageSize - pos);
            reader.put((DataInput)in, pos, len);
        }
        byte[] targetBuffer = new byte[this.pageSize];
        reader.get(0, targetBuffer);
        Assert.assertArrayEquals((byte[])contents, (byte[])targetBuffer);
    }

    @Test
    public void testDataInputOutputOutOfBounds() {
        int segmentSize = 52;
        MemorySegment seg = this.createSegment(52);
        byte[] bytes = new byte[52];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        DataOutputStream out = new DataOutputStream(new ByteArrayOutputStream());
        try {
            seg.get((DataOutput)out, -1, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            seg.get((DataOutput)out, 52, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            seg.get((DataOutput)out, -52, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            seg.get((DataOutput)out, Integer.MIN_VALUE, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            seg.get((DataOutput)out, Integer.MAX_VALUE, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(new byte[52]));
        try {
            seg.put((DataInput)in, -1, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            seg.put((DataInput)in, 52, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            seg.put((DataInput)in, -52, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            seg.put((DataInput)in, Integer.MIN_VALUE, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            seg.put((DataInput)in, Integer.MAX_VALUE, 26);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
    }

    @Test
    public void testDataInputOutputStreamUnderflowOverflow() throws IOException {
        int segmentSize = 1337;
        MemorySegment seg = this.createSegment(1337);
        byte[] bytes = new byte[1337];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        DataOutputStream out = new DataOutputStream(new OutputStream(){
            int bytesSoFar = 0;

            @Override
            public void write(int b) throws IOException {
                ++this.bytesSoFar;
                if (this.bytesSoFar > 668) {
                    throw new IOException("overflow");
                }
            }
        });
        try {
            int len;
            for (int pos = 0; pos < this.pageSize; pos += len) {
                len = this.random.nextInt(133);
                len = Math.min(len, this.pageSize - pos);
                seg.get((DataOutput)out, pos, len);
            }
            Assert.fail((String)"Should fail with an IOException");
        }
        catch (IOException pos) {
            // empty catch block
        }
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(new byte[668]));
        try {
            int len;
            for (int pos = 0; pos < this.pageSize; pos += len) {
                len = this.random.nextInt(133);
                len = Math.min(len, this.pageSize - pos);
                seg.put((DataInput)in, pos, len);
            }
            Assert.fail((String)"Should fail with an EOFException");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testByteBufferGet() {
        this.testByteBufferGet(false);
        this.testByteBufferGet(true);
    }

    private void testByteBufferGet(boolean directBuffer) {
        int len;
        MemorySegment seg = this.createSegment(this.pageSize);
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        ByteBuffer target = directBuffer ? ByteBuffer.allocateDirect(3 * this.pageSize) : ByteBuffer.allocate(3 * this.pageSize);
        target.position(2 * this.pageSize);
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.get(pos, target, len);
        }
        byte[] result = new byte[this.pageSize];
        target.position(2 * this.pageSize);
        target.get(result);
        Assert.assertArrayEquals((byte[])bytes, (byte[])result);
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testHeapByteBufferGetReadOnly() {
        this.testByteBufferGetReadOnly(false);
    }

    @Test(expected=ReadOnlyBufferException.class)
    public void testOffHeapByteBufferGetReadOnly() {
        this.testByteBufferGetReadOnly(true);
    }

    private void testByteBufferGetReadOnly(boolean directBuffer) throws ReadOnlyBufferException {
        MemorySegment seg = this.createSegment(this.pageSize);
        ByteBuffer target = (directBuffer ? ByteBuffer.allocateDirect(this.pageSize) : ByteBuffer.allocate(this.pageSize)).asReadOnlyBuffer();
        seg.get(0, target, this.pageSize);
    }

    @Test
    public void testByteBufferPut() {
        this.testByteBufferPut(false);
        this.testByteBufferPut(true);
    }

    private void testByteBufferPut(boolean directBuffer) {
        int len;
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        ByteBuffer source = directBuffer ? ByteBuffer.allocateDirect(this.pageSize) : ByteBuffer.allocate(this.pageSize);
        source.put(bytes);
        source.clear();
        MemorySegment seg = this.createSegment(3 * this.pageSize);
        int offset = 2 * this.pageSize;
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.put(offset + pos, source, len);
        }
        byte[] result = new byte[this.pageSize];
        seg.get(offset, result);
        Assert.assertArrayEquals((byte[])bytes, (byte[])result);
    }

    @Test
    public void testSlicedByteBufferGet() {
        this.testSlicedByteBufferGet(false);
        this.testSlicedByteBufferGet(true);
    }

    private void testSlicedByteBufferGet(boolean directBuffer) {
        int len;
        MemorySegment seg = this.createSegment(this.pageSize);
        byte[] bytes = new byte[this.pageSize];
        this.random.nextBytes(bytes);
        seg.put(0, bytes);
        ByteBuffer target = directBuffer ? ByteBuffer.allocateDirect(this.pageSize + 49) : ByteBuffer.allocate(this.pageSize + 49);
        target.position(19).limit(19 + this.pageSize);
        ByteBuffer slicedTarget = target.slice();
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.get(pos, slicedTarget, len);
        }
        byte[] result = new byte[this.pageSize];
        target.position(19);
        target.get(result);
        Assert.assertArrayEquals((byte[])bytes, (byte[])result);
    }

    @Test
    public void testSlicedByteBufferPut() {
        this.testSlicedByteBufferPut(false);
        this.testSlicedByteBufferPut(true);
    }

    private void testSlicedByteBufferPut(boolean directBuffer) {
        int len;
        byte[] bytes = new byte[this.pageSize + 49];
        this.random.nextBytes(bytes);
        ByteBuffer source = directBuffer ? ByteBuffer.allocateDirect(this.pageSize + 49) : ByteBuffer.allocate(this.pageSize + 49);
        source.put(bytes);
        source.position(19).limit(19 + this.pageSize);
        ByteBuffer slicedSource = source.slice();
        MemorySegment seg = this.createSegment(3 * this.pageSize);
        int offset = 2 * this.pageSize;
        for (int pos = 0; pos < this.pageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 10);
            len = Math.min(len, this.pageSize - pos);
            seg.put(offset + pos, slicedSource, len);
        }
        byte[] result = new byte[this.pageSize];
        seg.get(offset, result);
        byte[] expected = Arrays.copyOfRange(bytes, 19, 19 + this.pageSize);
        Assert.assertArrayEquals((byte[])expected, (byte[])result);
    }

    @Test
    public void testByteBufferOutOfBounds() {
        int bbCapacity = this.pageSize / 10;
        int[] validOffsets = new int[]{0, 1, this.pageSize / 10 * 9};
        int[] invalidOffsets = new int[]{-1, this.pageSize + 1, -this.pageSize, Integer.MAX_VALUE, Integer.MIN_VALUE};
        int[] validLengths = new int[]{0, 1, bbCapacity, this.pageSize};
        int[] invalidLengths = new int[]{-1, -this.pageSize, Integer.MAX_VALUE, Integer.MIN_VALUE};
        MemorySegment seg = this.createSegment(this.pageSize);
        for (ByteBuffer bb : new ByteBuffer[]{ByteBuffer.allocate(bbCapacity), ByteBuffer.allocateDirect(bbCapacity)}) {
            for (int off : validOffsets) {
                for (int len : invalidLengths) {
                    try {
                        seg.put(off, bb, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException | BufferUnderflowException runtimeException) {
                        // empty catch block
                    }
                    try {
                        seg.get(off, bb, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException | BufferOverflowException runtimeException) {
                        // empty catch block
                    }
                    Assert.assertEquals((long)0L, (long)bb.position());
                    Assert.assertEquals((long)bb.capacity(), (long)bb.limit());
                }
            }
            for (int off : invalidOffsets) {
                for (int len : validLengths) {
                    try {
                        seg.put(off, bb, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException | BufferUnderflowException runtimeException) {
                        // empty catch block
                    }
                    try {
                        seg.get(off, bb, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException | BufferOverflowException runtimeException) {
                        // empty catch block
                    }
                    Assert.assertEquals((long)0L, (long)bb.position());
                    Assert.assertEquals((long)bb.capacity(), (long)bb.limit());
                }
            }
            for (int off : validOffsets) {
                for (int len : validLengths) {
                    if (off + len <= this.pageSize) continue;
                    try {
                        seg.put(off, bb, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException | BufferUnderflowException runtimeException) {
                        // empty catch block
                    }
                    try {
                        seg.get(off, bb, len);
                        Assert.fail((String)"should fail with an IndexOutOfBoundsException");
                    }
                    catch (IndexOutOfBoundsException | BufferOverflowException runtimeException) {
                        // empty catch block
                    }
                    Assert.assertEquals((long)0L, (long)bb.position());
                    Assert.assertEquals((long)bb.capacity(), (long)bb.limit());
                }
            }
        }
    }

    @Test
    public void testByteBufferOverflowUnderflow() {
        int bbCapacity = this.pageSize / 10;
        ByteBuffer bb = ByteBuffer.allocate(bbCapacity);
        MemorySegment seg = this.createSegment(this.pageSize);
        try {
            seg.get(this.pageSize / 5, bb, this.pageSize / 10 + 2);
            Assert.fail((String)"should fail with an exception");
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)bb.position());
        Assert.assertEquals((long)bb.capacity(), (long)bb.limit());
        try {
            seg.put(this.pageSize / 5, bb, this.pageSize / 10 + 2);
            Assert.fail((String)"should fail with an exception");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)bb.position());
        Assert.assertEquals((long)bb.capacity(), (long)bb.limit());
        int pos = bb.capacity() / 3;
        int limit = 2 * bb.capacity() / 3;
        bb.limit(limit);
        bb.position(pos);
        try {
            seg.get(20, bb, bb.capacity() / 3 + 3);
            Assert.fail((String)"should fail with an exception");
        }
        catch (BufferOverflowException bufferOverflowException) {
            // empty catch block
        }
        Assert.assertEquals((long)pos, (long)bb.position());
        Assert.assertEquals((long)limit, (long)bb.limit());
        try {
            seg.put(20, bb, bb.capacity() / 3 + 3);
            Assert.fail((String)"should fail with an exception");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        Assert.assertEquals((long)pos, (long)bb.position());
        Assert.assertEquals((long)limit, (long)bb.limit());
    }

    @Test
    public void testCompareBytes() {
        byte[] bytes1 = new byte[this.pageSize];
        byte[] bytes2 = new byte[this.pageSize];
        int stride = this.pageSize / 255;
        int shift = 16666;
        for (int i = 0; i < this.pageSize; ++i) {
            byte val;
            bytes1[i] = val = (byte)(i / stride & 0xFF);
            if (i + 16666 >= bytes2.length) continue;
            bytes2[i + 16666] = val;
        }
        MemorySegment seg1 = this.createSegment(this.pageSize);
        MemorySegment seg2 = this.createSegment(this.pageSize);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        for (int i = 0; i < 1000; ++i) {
            int pos1 = this.random.nextInt(bytes1.length);
            int pos2 = this.random.nextInt(bytes2.length);
            int len = Math.min(Math.min(bytes1.length - pos1, bytes2.length - pos2), this.random.nextInt(this.pageSize / 50));
            int cmp = seg1.compare(seg2, pos1, pos2, len);
            if (pos1 < pos2 - 16666) {
                Assert.assertTrue((cmp <= 0 ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((cmp >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCompareBytesWithDifferentLength() {
        byte[] bytes1 = new byte[]{97, 98, 99};
        byte[] bytes2 = new byte[]{97, 98, 99, 100};
        MemorySegment seg1 = this.createSegment(4);
        MemorySegment seg2 = this.createSegment(4);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        Assert.assertThat((Object)seg1.compare(seg2, 0, 0, 3, 4), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)seg1.compare(seg2, 0, 0, 3, 3), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)seg1.compare(seg2, 0, 0, 3, 2), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)seg1.compare(seg2, 1, 1, 2, 3), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)seg1.compare(seg2, 1, 1, 2, 2), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)seg1.compare(seg2, 1, 1, 2, 1), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testSwapBytes() {
        int len;
        int halfPageSize = this.pageSize / 2;
        byte[] bytes1 = new byte[this.pageSize];
        byte[] bytes2 = new byte[halfPageSize];
        Arrays.fill(bytes2, (byte)1);
        MemorySegment seg1 = this.createSegment(this.pageSize);
        MemorySegment seg2 = this.createSegment(halfPageSize);
        seg1.put(0, bytes1);
        seg2.put(0, bytes2);
        for (int pos = 0; pos < halfPageSize; pos += len) {
            len = this.random.nextInt(this.pageSize / 40);
            len = Math.min(len, halfPageSize - pos);
            seg1.swapBytes(new byte[len], seg2, pos + halfPageSize, pos, len);
        }
        for (int i = 0; i < halfPageSize; ++i) {
            Assert.assertEquals((long)0L, (long)seg1.get(i));
            Assert.assertEquals((long)0L, (long)seg2.get(i));
            Assert.assertEquals((long)1L, (long)seg1.get(i + halfPageSize));
        }
    }

    @Test
    public void testCheckAgainstOverflowUnderflowOnRelease() {
        MemorySegment seg = this.createSegment(512);
        seg.free();
        try {
            seg.get(0);
            Assert.fail((String)"Expecting an IllegalStateException");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof IllegalStateException || e instanceof NullPointerException ? 1 : 0) != 0);
        }
        try {
            seg.get(Integer.MAX_VALUE);
            Assert.fail((String)"Expecting an IllegalStateException");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof IllegalStateException || e instanceof NullPointerException ? 1 : 0) != 0);
        }
        try {
            seg.get(Integer.MIN_VALUE);
            Assert.fail((String)"Expecting an IllegalStateException");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof IllegalStateException || e instanceof NullPointerException ? 1 : 0) != 0);
        }
        try {
            seg.getLong(0);
            Assert.fail((String)"Expecting an IllegalStateException");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof IllegalStateException || e instanceof NullPointerException ? 1 : 0) != 0);
        }
        try {
            seg.getLong(Integer.MAX_VALUE);
            Assert.fail((String)"Expecting an IllegalStateException");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof IllegalStateException || e instanceof NullPointerException ? 1 : 0) != 0);
        }
        try {
            seg.getLong(Integer.MIN_VALUE);
            Assert.fail((String)"Expecting an IllegalStateException");
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof IllegalStateException || e instanceof NullPointerException ? 1 : 0) != 0);
        }
    }

    @Test
    public void testByteBufferWrapping() {
        MemorySegment seg = this.createSegment(1024);
        ByteBuffer buf1 = seg.wrap(13, 47);
        Assert.assertEquals((long)13L, (long)buf1.position());
        Assert.assertEquals((long)60L, (long)buf1.limit());
        Assert.assertEquals((long)47L, (long)buf1.remaining());
        ByteBuffer buf2 = seg.wrap(500, 267);
        Assert.assertEquals((long)500L, (long)buf2.position());
        Assert.assertEquals((long)767L, (long)buf2.limit());
        Assert.assertEquals((long)267L, (long)buf2.remaining());
        ByteBuffer buf3 = seg.wrap(0, 1024);
        Assert.assertEquals((long)0L, (long)buf3.position());
        Assert.assertEquals((long)1024L, (long)buf3.limit());
        Assert.assertEquals((long)1024L, (long)buf3.remaining());
        buf3.order(ByteOrder.LITTLE_ENDIAN);
        buf3.putInt(112, 651797651);
        Assert.assertEquals((long)651797651L, (long)seg.getIntLittleEndian(112));
        buf3.order(ByteOrder.BIG_ENDIAN);
        buf3.putInt(187, 992288337);
        Assert.assertEquals((long)992288337L, (long)seg.getIntBigEndian(187));
        try {
            seg.wrap(-1, 20);
            Assert.fail((String)"should throw an exception");
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            seg.wrap(10, -20);
            Assert.fail((String)"should throw an exception");
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        try {
            seg.wrap(10, 1024);
            Assert.fail((String)"should throw an exception");
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
        seg.free();
        try {
            seg.wrap(13, 47);
            Assert.fail((String)"should fail with an exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        buf3.order(ByteOrder.LITTLE_ENDIAN);
        buf3.putInt(112, 651797651);
        Assert.assertEquals((long)651797651L, (long)buf3.getInt(112));
        buf3.order(ByteOrder.BIG_ENDIAN);
        buf3.putInt(187, 992288337);
        Assert.assertEquals((long)992288337L, (long)buf3.getInt(187));
    }

    @Test
    public void testOwner() {
        Assert.assertNull((Object)this.createSegment(64).getOwner());
        Object theOwner = new Object();
        MemorySegment seg = this.createSegment(64, theOwner);
        Assert.assertEquals((Object)theOwner, (Object)seg.getOwner());
        seg.free();
        Assert.assertNotNull((Object)seg.getOwner());
    }

    @Test
    public void testSizeAndFreeing() {
        int segmentSize = 651;
        MemorySegment seg = this.createSegment(651);
        Assert.assertEquals((long)651L, (long)seg.size());
        Assert.assertFalse((boolean)seg.isFreed());
        seg.free();
        Assert.assertTrue((boolean)seg.isFreed());
        Assert.assertEquals((long)651L, (long)seg.size());
    }

    @Parameterized.Parameters(name="segment-size = {0}")
    public static Collection<Object[]> executionModes() {
        return Arrays.asList({32768}, {4096}, {524288});
    }
}

