/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class TestFileUtils {
    private static final String FILE_PREFIX = "flink_test_";
    private static final String FILE_SUFFIX = ".tmp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createTempFile(long bytes) throws IOException {
        File f = File.createTempFile(FILE_PREFIX, FILE_SUFFIX);
        f.deleteOnExit();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            while (bytes > 0L) {
                out.write(0);
                --bytes;
            }
        }
        return f.toURI().toString();
    }

    public static String createTempFileInDirectory(String dir, String contents) throws IOException {
        File f;
        while ((f = new File(dir + "/" + TestFileUtils.randomFileName())).exists()) {
        }
        f.getParentFile().mkdirs();
        f.createNewFile();
        f.deleteOnExit();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(f));){
            out.write(contents);
        }
        return f.toURI().toString();
    }

    public static String createTempFileInDirectory(String dir, long bytes) throws IOException {
        File f;
        while ((f = new File(dir + "/" + TestFileUtils.randomFileName())).exists()) {
        }
        f.getParentFile().mkdirs();
        f.createNewFile();
        f.deleteOnExit();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));){
            while (bytes > 0L) {
                out.write(0);
                --bytes;
            }
        }
        return f.toURI().toString();
    }

    public static String createTempFile(String contents) throws IOException {
        File f = File.createTempFile(FILE_PREFIX, FILE_SUFFIX);
        f.deleteOnExit();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(f));){
            out.write(contents);
        }
        return f.toURI().toString();
    }

    public static String createTempFileDir(File tempDir, long ... bytes) throws IOException {
        File f = null;
        while ((f = new File(tempDir, TestFileUtils.randomFileName())).exists()) {
        }
        f.mkdirs();
        f.deleteOnExit();
        long[] lArray = bytes;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            File child = new File(f, TestFileUtils.randomFileName());
            child.deleteOnExit();
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(child));){
                for (long l = lArray[i]; l > 0L; --l) {
                    out.write(0);
                }
                continue;
            }
        }
        return f.toURI().toString();
    }

    public static String createTempFileDir(File tempDir, String ... contents) throws IOException {
        return TestFileUtils.createTempFileDirExtension(tempDir, FILE_SUFFIX, contents);
    }

    public static String createTempFileDirExtension(File tempDir, String fileExtension, String ... contents) throws IOException {
        File f = null;
        while ((f = new File(tempDir, TestFileUtils.randomFileName(FILE_SUFFIX))).exists()) {
        }
        f.mkdirs();
        f.deleteOnExit();
        for (String s : contents) {
            File child = new File(f, TestFileUtils.randomFileName(fileExtension));
            child.deleteOnExit();
            try (BufferedWriter out = new BufferedWriter(new FileWriter(child));){
                out.write(s);
            }
        }
        return f.toURI().toString();
    }

    public static String randomFileName() {
        return TestFileUtils.randomFileName(FILE_SUFFIX);
    }

    public static String randomFileName(String fileSuffix) {
        return FILE_PREFIX + (int)(Math.random() * 2.147483647E9) + fileSuffix;
    }

    public static File createTempDir() throws IOException {
        File tempDirectory = Files.createTempDirectory(FILE_PREFIX, new FileAttribute[0]).toFile();
        tempDirectory.deleteOnExit();
        return tempDirectory;
    }

    private TestFileUtils() {
    }
}

