/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.apache.flink.testutils.executor.TestExecutorResource;

public class TestingUtils {
    private static final UUID ZERO_UUID = new UUID(0L, 0L);
    public static final Duration TESTING_DURATION = Duration.ofMinutes(2L);
    public static final Time TIMEOUT = Time.minutes((long)1L);
    public static final Duration DEFAULT_AKKA_ASK_TIMEOUT = Duration.ofSeconds(200L);

    public static Time infiniteTime() {
        return Time.milliseconds((long)Integer.MAX_VALUE);
    }

    public static Duration infiniteDuration() {
        return Duration.ofDays(365L);
    }

    public static TestExecutorExtension<ScheduledExecutorService> defaultExecutorExtension() {
        return new TestExecutorExtension(Executors::newSingleThreadScheduledExecutor);
    }

    public static TestExecutorResource<ScheduledExecutorService> defaultExecutorResource() {
        return new TestExecutorResource(Executors::newSingleThreadScheduledExecutor);
    }

    public static UUID zeroUUID() {
        return ZERO_UUID;
    }
}

