/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;

public class BooleanType
implements SerializationTestType {
    private boolean value;

    public BooleanType() {
        this.value = false;
    }

    private BooleanType(boolean value) {
        this.value = value;
    }

    @Override
    public BooleanType getRandom(Random rnd) {
        return new BooleanType(rnd.nextBoolean());
    }

    @Override
    public int length() {
        return 1;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeBoolean(this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readBoolean();
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanType) {
            BooleanType other = (BooleanType)obj;
            return this.value == other.value;
        }
        return false;
    }
}

