/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public abstract class ParserTestBase<T>
extends TestLogger {
    public abstract String[] getValidTestValues();

    public abstract T[] getValidTestResults();

    public abstract String[] getInvalidTestValues();

    public abstract boolean allowsEmptyField();

    public abstract FieldParser<T> getParser();

    public abstract Class<T> getTypeClass();

    @Test
    public void testTest() {
        Assert.assertNotNull(this.getParser());
        Assert.assertNotNull(this.getTypeClass());
        Assert.assertNotNull((Object)this.getValidTestValues());
        Assert.assertNotNull(this.getValidTestResults());
        Assert.assertNotNull((Object)this.getInvalidTestValues());
        Assert.assertTrue((this.getValidTestValues().length == this.getValidTestResults().length ? 1 : 0) != 0);
    }

    @Test
    public void testGetValue() {
        try {
            FieldParser<T> parser = this.getParser();
            Object created = parser.createValue();
            Assert.assertNotNull((String)"Null type created", (Object)created);
            Assert.assertTrue((String)"Wrong type created", (boolean)this.getTypeClass().isAssignableFrom(created.getClass()));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testValidStringInIsolation() {
        try {
            String[] testValues = this.getValidTestValues();
            T[] results = this.getValidTestResults();
            for (int i = 0; i < testValues.length; ++i) {
                FieldParser<T> parser1 = this.getParser();
                FieldParser<T> parser2 = this.getParser();
                FieldParser<T> parser3 = this.getParser();
                byte[] bytes1 = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
                byte[] bytes2 = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
                byte[] bytes3 = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
                int numRead1 = parser1.parseField(bytes1, 0, bytes1.length, new byte[]{124}, parser1.createValue());
                int numRead2 = parser2.parseField(bytes2, 0, bytes2.length, new byte[]{38, 38}, parser2.createValue());
                int numRead3 = parser3.parseField(bytes3, 0, bytes3.length, new byte[]{57, 57, 57}, parser3.createValue());
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (numRead1 != -1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (numRead2 != -1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (numRead3 != -1 ? 1 : 0) != 0);
                Assert.assertEquals((String)"Invalid number of bytes read returned.", (long)bytes1.length, (long)numRead1);
                Assert.assertEquals((String)"Invalid number of bytes read returned.", (long)bytes2.length, (long)numRead2);
                Assert.assertEquals((String)"Invalid number of bytes read returned.", (long)bytes3.length, (long)numRead3);
                Object result1 = parser1.getLastResult();
                Object result2 = parser2.getLastResult();
                Object result3 = parser3.getLastResult();
                Assert.assertEquals((String)("Parser parsed wrong. " + testValues[i]), results[i], (Object)result1);
                Assert.assertEquals((String)("Parser parsed wrong. " + testValues[i]), results[i], (Object)result2);
                Assert.assertEquals((String)("Parser parsed wrong. " + testValues[i]), results[i], (Object)result3);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testValidStringInIsolationWithEndDelimiter() {
        try {
            String[] testValues = this.getValidTestValues();
            T[] results = this.getValidTestResults();
            for (int i = 0; i < testValues.length; ++i) {
                FieldParser<T> parser1 = this.getParser();
                FieldParser<T> parser2 = this.getParser();
                String testVal1 = testValues[i] + "|";
                String testVal2 = testValues[i] + "&&&&";
                byte[] bytes1 = testVal1.getBytes(ConfigConstants.DEFAULT_CHARSET);
                byte[] bytes2 = testVal2.getBytes(ConfigConstants.DEFAULT_CHARSET);
                int numRead1 = parser1.parseField(bytes1, 0, bytes1.length, new byte[]{124}, parser1.createValue());
                int numRead2 = parser2.parseField(bytes2, 0, bytes2.length, new byte[]{38, 38, 38, 38}, parser2.createValue());
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (numRead1 != -1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (numRead2 != -1 ? 1 : 0) != 0);
                Assert.assertEquals((String)"Invalid number of bytes read returned.", (long)bytes1.length, (long)numRead1);
                Assert.assertEquals((String)"Invalid number of bytes read returned.", (long)bytes2.length, (long)numRead2);
                Object result1 = parser1.getLastResult();
                Object result2 = parser2.getLastResult();
                Assert.assertEquals((String)"Parser parsed wrong.", results[i], (Object)result1);
                Assert.assertEquals((String)"Parser parsed wrong.", results[i], (Object)result2);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testConcatenated() {
        try {
            String[] testValues = this.getValidTestValues();
            T[] results = this.getValidTestResults();
            byte[] allBytesWithDelimiter = ParserTestBase.concatenate(testValues, new char[]{'|'}, true);
            byte[] allBytesNoDelimiterEnd = ParserTestBase.concatenate(testValues, new char[]{','}, false);
            FieldParser<T> parser1 = this.getParser();
            FieldParser<T> parser2 = this.getParser();
            Object val1 = parser1.createValue();
            Object val2 = parser2.createValue();
            int pos1 = 0;
            int pos2 = 0;
            for (int i = 0; i < results.length; ++i) {
                pos1 = parser1.parseField(allBytesWithDelimiter, pos1, allBytesWithDelimiter.length, new byte[]{124}, val1);
                pos2 = parser2.parseField(allBytesNoDelimiterEnd, pos2, allBytesNoDelimiterEnd.length, new byte[]{44}, val2);
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (pos1 != -1 ? 1 : 0) != 0);
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (pos2 != -1 ? 1 : 0) != 0);
                Object result1 = parser1.getLastResult();
                Object result2 = parser2.getLastResult();
                Assert.assertEquals((String)"Parser parsed wrong.", results[i], (Object)result1);
                Assert.assertEquals((String)"Parser parsed wrong.", results[i], (Object)result2);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testConcatenatedMultiCharDelimiter() {
        try {
            String[] testValues = this.getValidTestValues();
            T[] results = this.getValidTestResults();
            byte[] allBytesWithDelimiter = ParserTestBase.concatenate(testValues, new char[]{'&', '&', '&', '&'}, true);
            byte[] allBytesNoDelimiterEnd = ParserTestBase.concatenate(testValues, new char[]{'9', '9', '9'}, false);
            FieldParser<T> parser1 = this.getParser();
            FieldParser<T> parser2 = this.getParser();
            Object val1 = parser1.createValue();
            Object val2 = parser2.createValue();
            int pos1 = 0;
            int pos2 = 0;
            for (int i = 0; i < results.length; ++i) {
                pos1 = parser1.parseField(allBytesWithDelimiter, pos1, allBytesWithDelimiter.length, new byte[]{38, 38, 38, 38}, val1);
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (pos1 != -1 ? 1 : 0) != 0);
                Object result1 = parser1.getLastResult();
                Assert.assertEquals((String)"Parser parsed wrong.", results[i], (Object)result1);
                pos2 = parser2.parseField(allBytesNoDelimiterEnd, pos2, allBytesNoDelimiterEnd.length, new byte[]{57, 57, 57}, val2);
                Assert.assertTrue((String)("Parser declared the valid value " + testValues[i] + " as invalid."), (pos2 != -1 ? 1 : 0) != 0);
                Object result2 = parser2.getLastResult();
                Assert.assertEquals((String)"Parser parsed wrong.", results[i], (Object)result2);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testInValidStringInIsolation() {
        try {
            String[] testValues = this.getInvalidTestValues();
            for (int i = 0; i < testValues.length; ++i) {
                FieldParser<T> parser = this.getParser();
                byte[] bytes = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
                int numRead = parser.parseField(bytes, 0, bytes.length, new byte[]{124}, parser.createValue());
                Assert.assertTrue((String)("Parser accepted the invalid value " + testValues[i] + "."), (numRead == -1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testInValidStringsMixedIn() {
        try {
            String[] validValues = this.getValidTestValues();
            T[] validResults = this.getValidTestResults();
            String[] invalidTestValues = this.getInvalidTestValues();
            FieldParser<T> parser = this.getParser();
            Object value = parser.createValue();
            for (String invalid : invalidTestValues) {
                String[] testLine = new String[validValues.length + 1];
                int splitPoint = validValues.length / 2;
                System.arraycopy(validValues, 0, testLine, 0, splitPoint);
                testLine[splitPoint] = invalid;
                System.arraycopy(validValues, splitPoint, testLine, splitPoint + 1, validValues.length - splitPoint);
                byte[] bytes = ParserTestBase.concatenate(testLine, new char[]{'%'}, true);
                int pos = 0;
                for (int i = 0; i < splitPoint; ++i) {
                    pos = parser.parseField(bytes, pos, bytes.length, new byte[]{37}, value);
                    Assert.assertTrue((String)("Parser declared the valid value " + validValues[i] + " as invalid."), (pos != -1 ? 1 : 0) != 0);
                    Object result = parser.getLastResult();
                    Assert.assertEquals((String)"Parser parsed wrong.", validResults[i], (Object)result);
                }
                pos = parser.parseField(bytes, pos, bytes.length, new byte[]{37}, value);
                Assert.assertTrue((String)("Parser accepted the invalid value " + invalid + "."), (pos == -1 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testStaticParseMethod() {
        try {
            Method parseMethod = null;
            try {
                parseMethod = this.getParser().getClass().getMethod("parseField", byte[].class, Integer.TYPE, Integer.TYPE, Character.TYPE);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            String[] testValues = this.getValidTestValues();
            T[] results = this.getValidTestResults();
            for (int i = 0; i < testValues.length; ++i) {
                Object result;
                byte[] bytes = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
                try {
                    result = parseMethod.invoke(null, bytes, 0, bytes.length, Character.valueOf('|'));
                }
                catch (InvocationTargetException e) {
                    e.getTargetException().printStackTrace();
                    Assert.fail((String)("Error while parsing: " + e.getTargetException().getMessage()));
                    return;
                }
                Assert.assertEquals((String)"Parser parsed wrong.", results[i], (Object)result);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    @Test
    public void testStaticParseMethodWithInvalidValues() {
        try {
            Method parseMethod = null;
            try {
                parseMethod = this.getParser().getClass().getMethod("parseField", byte[].class, Integer.TYPE, Integer.TYPE, Character.TYPE);
            }
            catch (NoSuchMethodException e) {
                return;
            }
            String[] testValues = this.getInvalidTestValues();
            for (int i = 0; i < testValues.length; ++i) {
                byte[] bytes = testValues[i].getBytes(ConfigConstants.DEFAULT_CHARSET);
                try {
                    parseMethod.invoke(null, bytes, 0, bytes.length, Character.valueOf('|'));
                    Assert.fail((String)"Static parse method accepted invalid value");
                    continue;
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }

    private static byte[] concatenate(String[] values, char[] delimiter, boolean delimiterAtEnd) {
        int len = 0;
        for (String s : values) {
            len += s.length() + delimiter.length;
        }
        if (!delimiterAtEnd) {
            len -= delimiter.length;
        }
        int currPos = 0;
        byte[] result = new byte[len];
        for (int i = 0; i < values.length; ++i) {
            String s;
            s = values[i];
            byte[] bytes = s.getBytes(ConfigConstants.DEFAULT_CHARSET);
            int numBytes = bytes.length;
            System.arraycopy(bytes, 0, result, currPos, numBytes);
            currPos += numBytes;
            if (!delimiterAtEnd && i >= values.length - 1) continue;
            for (int j = 0; j < delimiter.length; ++j) {
                result[currPos++] = (byte)delimiter[j];
            }
        }
        return result;
    }

    @Test
    public void testTrailingEmptyField() {
        try {
            FieldParser<T> parser = this.getParser();
            byte[] bytes = "||".getBytes(ConfigConstants.DEFAULT_CHARSET);
            for (int i = 0; i < 2; ++i) {
                int numRead = parser.parseField(bytes, i, bytes.length, new byte[]{124}, parser.createValue());
                Assert.assertEquals((Object)FieldParser.ParseErrorState.EMPTY_COLUMN, (Object)parser.getErrorState());
                if (this.allowsEmptyField()) {
                    Assert.assertTrue((String)"Parser declared the empty string as invalid.", (numRead != -1 ? 1 : 0) != 0);
                    Assert.assertEquals((String)"Invalid number of bytes read returned.", (long)(i + 1), (long)numRead);
                } else {
                    Assert.assertTrue((String)"Parser accepted the empty string.", (numRead == -1 ? 1 : 0) != 0);
                }
                parser.resetParserState();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Test erroneous: " + e.getMessage()));
        }
    }
}

