/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import org.apache.flink.util.NumberSequenceIterator;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class NumberSequenceIteratorTest
extends TestLogger {
    @Test
    public void testSplitRegular() {
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(0L, 10L), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(100L, 100000L), 7);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-100L, 0L), 5);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-100L, 100L), 3);
    }

    @Test
    public void testSplittingLargeRangesBy2() {
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(0L, Long.MAX_VALUE), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-1000000000L, Long.MAX_VALUE), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(Long.MIN_VALUE, Long.MAX_VALUE), 2);
    }

    @Test
    public void testSplittingTooSmallRanges() {
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(0L, 0L), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-5L, -5L), 2);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(-5L, -4L), 3);
        NumberSequenceIteratorTest.testSplitting(new NumberSequenceIterator(10L, 15L), 10);
    }

    private static void testSplitting(NumberSequenceIterator iter, int numSplits) {
        NumberSequenceIterator[] splits = iter.split(numSplits);
        Assert.assertEquals((long)numSplits, (long)splits.length);
        Assert.assertEquals((long)iter.getCurrent(), (long)splits[0].getCurrent());
        Assert.assertEquals((long)iter.getTo(), (long)splits[numSplits - 1].getTo());
        for (int i = 1; i < splits.length; ++i) {
            Assert.assertEquals((long)(splits[i - 1].getTo() + 1L), (long)splits[i].getCurrent());
        }
        NumberSequenceIteratorTest.testMaxSplitDiff(splits);
    }

    private static void testMaxSplitDiff(NumberSequenceIterator[] iters) {
        long minSplitSize = Long.MAX_VALUE;
        long maxSplitSize = Long.MIN_VALUE;
        for (NumberSequenceIterator iter : iters) {
            long diff = iter.getTo() < iter.getCurrent() ? 0L : iter.getTo() - iter.getCurrent();
            if (diff < 0L) {
                diff = Long.MAX_VALUE;
            }
            minSplitSize = Math.min(minSplitSize, diff);
            maxSplitSize = Math.max(maxSplitSize, diff);
        }
        Assert.assertTrue((maxSplitSize == minSplitSize || maxSplitSize - 1L == minSplitSize ? 1 : 0) != 0);
    }
}

