/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.time.DayOfWeek;
import java.util.Random;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilsTest
extends TestLogger {
    @Test
    public void testControlCharacters() {
        String testString = "\b \t \n \f \r default";
        String controlString = StringUtils.showControlCharacters((String)testString);
        Assert.assertEquals((Object)"\\b \\t \\n \\f \\r default", (Object)controlString);
    }

    @Test
    public void testArrayAwareToString() {
        Assert.assertEquals((Object)"null", (Object)StringUtils.arrayAwareToString(null));
        Assert.assertEquals((Object)"MONDAY", (Object)StringUtils.arrayAwareToString((Object)DayOfWeek.MONDAY));
        Assert.assertEquals((Object)"[1, 2, 3]", (Object)StringUtils.arrayAwareToString((Object)new int[]{1, 2, 3}));
        Assert.assertEquals((Object)"[[4, 5, 6], null, []]", (Object)StringUtils.arrayAwareToString((Object)new byte[][]{{4, 5, 6}, null, new byte[0]}));
        Assert.assertEquals((Object)"[[4, 5, 6], null, MONDAY]", (Object)StringUtils.arrayAwareToString((Object)new Object[]{new Integer[]{4, 5, 6}, null, DayOfWeek.MONDAY}));
    }

    @Test
    public void testStringToHexArray() {
        String hex = "019f314a";
        byte[] hexArray = StringUtils.hexStringToByte((String)hex);
        byte[] expectedArray = new byte[]{1, -97, 49, 74};
        Assert.assertArrayEquals((byte[])expectedArray, (byte[])hexArray);
    }

    @Test
    public void testHexArrayToString() {
        byte[] byteArray = new byte[]{1, -97, 49, 74};
        String hex = StringUtils.byteToHexString((byte[])byteArray);
        Assert.assertEquals((Object)"019f314a", (Object)hex);
    }

    @Test
    public void testGenerateAlphanumeric() {
        String str = StringUtils.generateRandomAlphanumericString((Random)new Random(), (int)256);
        if (!str.matches("[a-zA-Z0-9]{256}")) {
            Assert.fail((String)("Not alphanumeric: " + str));
        }
    }
}

