/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.time.Duration;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.TimeUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeUtilsPrettyPrintingTest
extends TestLogger {
    @Parameterized.Parameter
    public Duration duration;
    @Parameterized.Parameter(value=1)
    public String expectedString;

    @Parameterized.Parameters
    public static Object[][] parameters() {
        return new Object[][]{{Duration.ofMinutes(3L).plusSeconds(30L), "210 s"}, {Duration.ofNanos(100L), "100 ns"}, {Duration.ofSeconds(120L), "2 min"}, {Duration.ofMillis(200L), "200 ms"}, {Duration.ofHours(1L).plusSeconds(3L), "3603 s"}, {Duration.ofSeconds(0L), "0 ms"}, {Duration.ofMillis(60000L), "1 min"}};
    }

    @Test
    public void testFormatting() {
        Assert.assertThat((Object)TimeUtils.formatWithHighestUnit((Duration)this.duration), (Matcher)CoreMatchers.is((Object)this.expectedString));
    }
}

