/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.util.TimeUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TimeUtilsTest {
    @Test
    public void testParseDurationNanos() {
        Assert.assertEquals((long)424562L, (long)TimeUtils.parseDuration((String)"424562ns").getNano());
        Assert.assertEquals((long)424562L, (long)TimeUtils.parseDuration((String)"424562nano").getNano());
        Assert.assertEquals((long)424562L, (long)TimeUtils.parseDuration((String)"424562nanos").getNano());
        Assert.assertEquals((long)424562L, (long)TimeUtils.parseDuration((String)"424562nanosecond").getNano());
        Assert.assertEquals((long)424562L, (long)TimeUtils.parseDuration((String)"424562nanoseconds").getNano());
        Assert.assertEquals((long)424562L, (long)TimeUtils.parseDuration((String)"424562 ns").getNano());
    }

    @Test
    public void testParseDurationMicros() {
        Assert.assertEquals((long)565731000L, (long)TimeUtils.parseDuration((String)"565731\u00b5s").getNano());
        Assert.assertEquals((long)565731000L, (long)TimeUtils.parseDuration((String)"565731micro").getNano());
        Assert.assertEquals((long)565731000L, (long)TimeUtils.parseDuration((String)"565731micros").getNano());
        Assert.assertEquals((long)565731000L, (long)TimeUtils.parseDuration((String)"565731microsecond").getNano());
        Assert.assertEquals((long)565731000L, (long)TimeUtils.parseDuration((String)"565731microseconds").getNano());
        Assert.assertEquals((long)565731000L, (long)TimeUtils.parseDuration((String)"565731 \u00b5s").getNano());
    }

    @Test
    public void testParseDurationMillis() {
        Assert.assertEquals((long)1234L, (long)TimeUtils.parseDuration((String)"1234").toMillis());
        Assert.assertEquals((long)1234L, (long)TimeUtils.parseDuration((String)"1234ms").toMillis());
        Assert.assertEquals((long)1234L, (long)TimeUtils.parseDuration((String)"1234milli").toMillis());
        Assert.assertEquals((long)1234L, (long)TimeUtils.parseDuration((String)"1234millis").toMillis());
        Assert.assertEquals((long)1234L, (long)TimeUtils.parseDuration((String)"1234millisecond").toMillis());
        Assert.assertEquals((long)1234L, (long)TimeUtils.parseDuration((String)"1234milliseconds").toMillis());
        Assert.assertEquals((long)1234L, (long)TimeUtils.parseDuration((String)"1234 ms").toMillis());
    }

    @Test
    public void testParseDurationSeconds() {
        Assert.assertEquals((long)667766L, (long)TimeUtils.parseDuration((String)"667766s").getSeconds());
        Assert.assertEquals((long)667766L, (long)TimeUtils.parseDuration((String)"667766sec").getSeconds());
        Assert.assertEquals((long)667766L, (long)TimeUtils.parseDuration((String)"667766secs").getSeconds());
        Assert.assertEquals((long)667766L, (long)TimeUtils.parseDuration((String)"667766second").getSeconds());
        Assert.assertEquals((long)667766L, (long)TimeUtils.parseDuration((String)"667766seconds").getSeconds());
        Assert.assertEquals((long)667766L, (long)TimeUtils.parseDuration((String)"667766 s").getSeconds());
    }

    @Test
    public void testParseDurationMinutes() {
        Assert.assertEquals((long)7657623L, (long)TimeUtils.parseDuration((String)"7657623m").toMinutes());
        Assert.assertEquals((long)7657623L, (long)TimeUtils.parseDuration((String)"7657623min").toMinutes());
        Assert.assertEquals((long)7657623L, (long)TimeUtils.parseDuration((String)"7657623minute").toMinutes());
        Assert.assertEquals((long)7657623L, (long)TimeUtils.parseDuration((String)"7657623minutes").toMinutes());
        Assert.assertEquals((long)7657623L, (long)TimeUtils.parseDuration((String)"7657623 min").toMinutes());
    }

    @Test
    public void testParseDurationHours() {
        Assert.assertEquals((long)987654L, (long)TimeUtils.parseDuration((String)"987654h").toHours());
        Assert.assertEquals((long)987654L, (long)TimeUtils.parseDuration((String)"987654hour").toHours());
        Assert.assertEquals((long)987654L, (long)TimeUtils.parseDuration((String)"987654hours").toHours());
        Assert.assertEquals((long)987654L, (long)TimeUtils.parseDuration((String)"987654 h").toHours());
    }

    @Test
    public void testParseDurationDays() {
        Assert.assertEquals((long)987654L, (long)TimeUtils.parseDuration((String)"987654d").toDays());
        Assert.assertEquals((long)987654L, (long)TimeUtils.parseDuration((String)"987654day").toDays());
        Assert.assertEquals((long)987654L, (long)TimeUtils.parseDuration((String)"987654days").toDays());
        Assert.assertEquals((long)987654L, (long)TimeUtils.parseDuration((String)"987654 d").toDays());
    }

    @Test
    public void testParseDurationUpperCase() {
        Assert.assertEquals((long)1L, (long)TimeUtils.parseDuration((String)"1 NS").toNanos());
        Assert.assertEquals((long)1000L, (long)TimeUtils.parseDuration((String)"1 MICRO").toNanos());
        Assert.assertEquals((long)1L, (long)TimeUtils.parseDuration((String)"1 MS").toMillis());
        Assert.assertEquals((long)1L, (long)TimeUtils.parseDuration((String)"1 S").getSeconds());
        Assert.assertEquals((long)1L, (long)TimeUtils.parseDuration((String)"1 MIN").toMinutes());
        Assert.assertEquals((long)1L, (long)TimeUtils.parseDuration((String)"1 H").toHours());
        Assert.assertEquals((long)1L, (long)TimeUtils.parseDuration((String)"1 D").toDays());
    }

    @Test
    public void testParseDurationTrim() {
        Assert.assertEquals((long)155L, (long)TimeUtils.parseDuration((String)"      155      ").toMillis());
        Assert.assertEquals((long)155L, (long)TimeUtils.parseDuration((String)"      155      ms   ").toMillis());
    }

    @Test
    public void testParseDurationInvalid() {
        try {
            TimeUtils.parseDuration(null);
            Assert.fail((String)"exception expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            TimeUtils.parseDuration((String)"");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TimeUtils.parseDuration((String)"     ");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TimeUtils.parseDuration((String)"foobar or fubar or foo bazz");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TimeUtils.parseDuration((String)"16 gjah");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TimeUtils.parseDuration((String)"16 16 17 18 ms");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TimeUtils.parseDuration((String)"-100 ms");
            Assert.fail((String)"exception expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseDurationNumberOverflow() {
        TimeUtils.parseDuration((String)"100000000000000000000000000000000 ms");
    }

    @Test
    public void testGetStringInMillis() {
        Assert.assertEquals((Object)"4567ms", (Object)TimeUtils.getStringInMillis((Duration)Duration.ofMillis(4567L)));
        Assert.assertEquals((Object)"4567000ms", (Object)TimeUtils.getStringInMillis((Duration)Duration.ofSeconds(4567L)));
        Assert.assertEquals((Object)"4ms", (Object)TimeUtils.getStringInMillis((Duration)Duration.of(4567L, ChronoUnit.MICROS)));
    }

    @Test
    public void testToDuration() {
        Time time = Time.of((long)1337L, (TimeUnit)TimeUnit.MICROSECONDS);
        Duration duration = TimeUtils.toDuration((Time)time);
        Assert.assertThat((Object)duration.toNanos(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)time.getUnit().toNanos(time.getSize()))));
    }
}

