/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.util.SerializedValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExecutionConfigTest {
    @Test
    void testDoubleTypeRegistration() {
        ExecutionConfig config = new ExecutionConfig();
        List<Class> types = Arrays.asList(Double.class, Integer.class, Double.class);
        List<Class> expectedTypes = Arrays.asList(Double.class, Integer.class);
        for (Class tpe : types) {
            config.registerKryoType(tpe);
        }
        int counter = 0;
        for (Class tpe : config.getRegisteredKryoTypes()) {
            Assertions.assertThat((Class)tpe).isEqualTo((Object)expectedTypes.get(counter++));
        }
        Assertions.assertThat((int)expectedTypes.size()).isEqualTo(counter);
    }

    @Test
    void testConfigurationOfParallelism() {
        ExecutionConfig config = new ExecutionConfig();
        int parallelism = 36;
        config.setParallelism(parallelism);
        Assertions.assertThat((int)parallelism).isEqualTo(config.getParallelism());
        parallelism = -1;
        config.setParallelism(parallelism);
        Assertions.assertThat((int)parallelism).isEqualTo(config.getParallelism());
    }

    @Test
    void testDisableGenericTypes() {
        ExecutionConfig conf = new ExecutionConfig();
        GenericTypeInfo typeInfo = new GenericTypeInfo(Object.class);
        TypeSerializer serializer = typeInfo.createSerializer(conf);
        Assertions.assertThat((boolean)(serializer instanceof KryoSerializer)).isTrue();
        conf.disableGenericTypes();
        Assertions.assertThatThrownBy(() -> ExecutionConfigTest.lambda$testDisableGenericTypes$0((TypeInformation)typeInfo, conf), (String)"should have failed with an exception", (Object[])new Object[0]).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testExecutionConfigSerialization() throws IOException, ClassNotFoundException {
        Random r = new Random();
        int parallelism = 1 + r.nextInt(10);
        boolean closureCleanerEnabled = r.nextBoolean();
        boolean forceAvroEnabled = r.nextBoolean();
        boolean forceKryoEnabled = r.nextBoolean();
        boolean disableGenericTypes = r.nextBoolean();
        boolean objectReuseEnabled = r.nextBoolean();
        ExecutionConfig config = new ExecutionConfig();
        if (closureCleanerEnabled) {
            config.enableClosureCleaner();
        } else {
            config.disableClosureCleaner();
        }
        if (forceAvroEnabled) {
            config.enableForceAvro();
        } else {
            config.disableForceAvro();
        }
        if (forceKryoEnabled) {
            config.enableForceKryo();
        } else {
            config.disableForceKryo();
        }
        if (disableGenericTypes) {
            config.disableGenericTypes();
        } else {
            config.enableGenericTypes();
        }
        if (objectReuseEnabled) {
            config.enableObjectReuse();
        } else {
            config.disableObjectReuse();
        }
        config.setParallelism(parallelism);
        ExecutionConfig copy1 = (ExecutionConfig)CommonTestUtils.createCopySerializable((Serializable)config);
        ExecutionConfig copy2 = (ExecutionConfig)new SerializedValue((Object)config).deserializeValue(this.getClass().getClassLoader());
        Assertions.assertThat((Object)copy1).isNotNull();
        Assertions.assertThat((Object)copy2).isNotNull();
        Assertions.assertThat((Object)config).isEqualTo((Object)copy1);
        Assertions.assertThat((Object)config).isEqualTo((Object)copy2);
        Assertions.assertThat((boolean)closureCleanerEnabled).isEqualTo(copy1.isClosureCleanerEnabled());
        Assertions.assertThat((boolean)forceAvroEnabled).isEqualTo(copy1.isForceAvroEnabled());
        Assertions.assertThat((boolean)forceKryoEnabled).isEqualTo(copy1.isForceKryoEnabled());
        Assertions.assertThat((boolean)disableGenericTypes).isEqualTo(copy1.hasGenericTypesDisabled());
        Assertions.assertThat((boolean)objectReuseEnabled).isEqualTo(copy1.isObjectReuseEnabled());
        Assertions.assertThat((int)parallelism).isEqualTo(copy1.getParallelism());
    }

    @Test
    void testGlobalParametersNotNull() {
        ExecutionConfig config = new ExecutionConfig();
        Assertions.assertThat((Object)config.getGlobalJobParameters()).isNotNull();
    }

    @Test
    void testGlobalParametersHashCode() {
        ExecutionConfig config = new ExecutionConfig();
        ExecutionConfig anotherConfig = new ExecutionConfig();
        Assertions.assertThat((int)config.getGlobalJobParameters().hashCode()).isEqualTo(anotherConfig.getGlobalJobParameters().hashCode());
    }

    @Test
    void testReadingDefaultConfig() {
        ExecutionConfig executionConfig = new ExecutionConfig();
        Configuration configuration = new Configuration();
        executionConfig.configure((ReadableConfig)configuration, ExecutionConfigTest.class.getClassLoader());
        Assertions.assertThat((Object)executionConfig).isEqualTo((Object)new ExecutionConfig());
    }

    @Test
    void testLoadingRegisteredKryoTypesFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.registerKryoType(ExecutionConfigTest.class);
        configFromSetters.registerKryoType(TestSerializer1.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.registered-kryo-types", "org.apache.flink.api.common.ExecutionConfigTest;org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)configFromConfiguration).isEqualTo((Object)configFromSetters);
    }

    @Test
    void testLoadingRegisteredPojoTypesFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.registerPojoType(ExecutionConfigTest.class);
        configFromSetters.registerPojoType(TestSerializer1.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.registered-pojo-types", "org.apache.flink.api.common.ExecutionConfigTest;org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)configFromConfiguration).isEqualTo((Object)configFromSetters);
    }

    @Test
    void testLoadingRestartStrategyFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)10, (Time)Time.minutes((long)2L)));
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("restart-strategy", "fixeddelay");
        configuration.setString("restart-strategy.fixed-delay.attempts", "10");
        configuration.setString("restart-strategy.fixed-delay.delay", "2 min");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)configFromConfiguration).isEqualTo((Object)configFromSetters);
    }

    @Test
    void testLoadingDefaultKryoSerializersFromConfiguration() {
        ExecutionConfig configFromSetters = new ExecutionConfig();
        configFromSetters.addDefaultKryoSerializer(ExecutionConfigTest.class, TestSerializer1.class);
        configFromSetters.addDefaultKryoSerializer(TestSerializer1.class, TestSerializer2.class);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        Configuration configuration = new Configuration();
        configuration.setString("pipeline.default-kryo-serializers", "class:org.apache.flink.api.common.ExecutionConfigTest,serializer:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1;class:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer1,serializer:org.apache.flink.api.common.ExecutionConfigTest$TestSerializer2");
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)configFromConfiguration).isEqualTo((Object)configFromSetters);
    }

    @Test
    public void testLoadingSchedulerTypeFromConfiguration() {
        this.testLoadingSchedulerTypeFromConfiguration(JobManagerOptions.SchedulerType.AdaptiveBatch);
        this.testLoadingSchedulerTypeFromConfiguration(JobManagerOptions.SchedulerType.Default);
        this.testLoadingSchedulerTypeFromConfiguration(JobManagerOptions.SchedulerType.Adaptive);
    }

    private void testLoadingSchedulerTypeFromConfiguration(JobManagerOptions.SchedulerType schedulerType) {
        Configuration configuration = new Configuration();
        configuration.set(JobManagerOptions.SCHEDULER, (Object)schedulerType);
        ExecutionConfig configFromConfiguration = new ExecutionConfig();
        configFromConfiguration.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Comparable)((Comparable)configFromConfiguration.getSchedulerType().get())).isEqualTo((Object)schedulerType);
    }

    @Test
    void testNotOverridingRegisteredKryoTypesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.registerKryoType(ExecutionConfigTest.class);
        config.registerKryoType(TestSerializer1.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.add(ExecutionConfigTest.class);
        set.add(TestSerializer1.class);
        Assertions.assertThat((Collection)config.getRegisteredKryoTypes()).isEqualTo(set);
    }

    @Test
    void testNotOverridingRegisteredPojoTypesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.registerPojoType(ExecutionConfigTest.class);
        config.registerPojoType(TestSerializer1.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashSet<Class> set = new LinkedHashSet<Class>();
        set.add(ExecutionConfigTest.class);
        set.add(TestSerializer1.class);
        Assertions.assertThat((Collection)config.getRegisteredPojoTypes()).isEqualTo(set);
    }

    @Test
    void testNotOverridingRestartStrategiesWithDefaultsFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration = RestartStrategies.fixedDelayRestart((int)10, (Time)Time.minutes((long)2L));
        config.setRestartStrategy(restartStrategyConfiguration);
        config.configure((ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader());
        Assertions.assertThat((Object)config.getRestartStrategy()).isEqualTo((Object)restartStrategyConfiguration);
    }

    @Test
    void testNotOverridingDefaultKryoSerializersFromConfiguration() {
        ExecutionConfig config = new ExecutionConfig();
        config.addDefaultKryoSerializer(ExecutionConfigTest.class, TestSerializer1.class);
        config.addDefaultKryoSerializer(TestSerializer1.class, TestSerializer2.class);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
        LinkedHashMap<Class, Class> serialiers = new LinkedHashMap<Class, Class>();
        serialiers.put(ExecutionConfigTest.class, TestSerializer1.class);
        serialiers.put(TestSerializer1.class, TestSerializer2.class);
        Assertions.assertThat((Map)config.getDefaultKryoSerializerClasses()).isEqualTo(serialiers);
    }

    private static /* synthetic */ void lambda$testDisableGenericTypes$0(TypeInformation typeInfo, ExecutionConfig conf) throws Throwable {
        typeInfo.createSerializer(conf);
    }

    private static class TestSerializer2
    extends Serializer<TestSerializer1>
    implements Serializable {
        private TestSerializer2() {
        }

        public void write(Kryo kryo, Output output, TestSerializer1 object) {
        }

        public TestSerializer1 read(Kryo kryo, Input input, Class<TestSerializer1> type) {
            return null;
        }
    }

    private static class TestSerializer1
    extends Serializer<ExecutionConfigTest>
    implements Serializable {
        private TestSerializer1() {
        }

        public void write(Kryo kryo, Output output, ExecutionConfigTest object) {
        }

        public ExecutionConfigTest read(Kryo kryo, Input input, Class<ExecutionConfigTest> type) {
            return null;
        }
    }
}

