/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.DoubleMinimum;
import org.junit.Assert;
import org.junit.Test;

public class DoubleMinimumTest {
    @Test
    public void testGet() {
        DoubleMinimum min = new DoubleMinimum();
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)min.getLocalValue(), (double)0.0);
    }

    @Test
    public void testResetLocal() {
        DoubleMinimum min = new DoubleMinimum();
        double value = 13.57902468;
        min.add(value);
        Assert.assertEquals((double)value, (double)min.getLocalValue(), (double)0.0);
        min.resetLocal();
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)min.getLocalValue(), (double)0.0);
    }

    @Test
    public void testAdd() {
        DoubleMinimum min = new DoubleMinimum();
        min.add(1234.5768);
        min.add(9876.5432);
        min.add(-987.6543);
        min.add(-123.4567);
        Assert.assertEquals((double)-987.6543, (double)min.getLocalValue(), (double)0.0);
    }

    @Test
    public void testMerge() {
        DoubleMinimum min1 = new DoubleMinimum();
        min1.add(1234.5768);
        DoubleMinimum min2 = new DoubleMinimum();
        min2.add(5678.9012);
        min2.merge((Accumulator)min1);
        Assert.assertEquals((double)1234.5768, (double)min2.getLocalValue(), (double)0.0);
        min1.merge((Accumulator)min2);
        Assert.assertEquals((double)1234.5768, (double)min1.getLocalValue(), (double)0.0);
    }

    @Test
    public void testClone() {
        DoubleMinimum min = new DoubleMinimum();
        double value = 3.14159265359;
        min.add(value);
        DoubleMinimum clone = min.clone();
        Assert.assertEquals((double)value, (double)clone.getLocalValue(), (double)0.0);
    }
}

