/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import java.io.IOException;
import org.apache.flink.api.common.serialization.AbstractDeserializationSchema;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.util.JSONPObject;
import org.apache.flink.util.FlinkRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDeserializationSchemaTest {
    @Test
    public void testTypeExtractionTuple() {
        TypeInformation type = new TupleSchema().getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<Tuple2<byte[], byte[]>>(){});
        Assert.assertEquals((Object)expected, (Object)type);
    }

    @Test
    public void testTypeExtractionTupleAnonymous() {
        TypeInformation type = new AbstractDeserializationSchema<Tuple2<byte[], byte[]>>(){

            public Tuple2<byte[], byte[]> deserialize(byte[] message) throws IOException {
                throw new UnsupportedOperationException();
            }
        }.getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<Tuple2<byte[], byte[]>>(){});
        Assert.assertEquals((Object)expected, (Object)type);
    }

    @Test
    public void testTypeExtractionGeneric() {
        TypeInformation type = new JsonSchema().getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<JSONPObject>(){});
        Assert.assertEquals((Object)expected, (Object)type);
    }

    @Test
    public void testTypeExtractionGenericAnonymous() {
        TypeInformation type = new AbstractDeserializationSchema<JSONPObject>(){

            public JSONPObject deserialize(byte[] message) throws IOException {
                throw new UnsupportedOperationException();
            }
        }.getProducedType();
        TypeInformation expected = TypeInformation.of((TypeHint)new TypeHint<JSONPObject>(){});
        Assert.assertEquals((Object)expected, (Object)type);
    }

    @Test
    public void testTypeExtractionRawException() {
        try {
            new RawSchema();
            Assert.fail();
        }
        catch (FlinkRuntimeException flinkRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testTypeExtractionGenericException() {
        try {
            new GenericSchema();
            Assert.fail();
        }
        catch (FlinkRuntimeException flinkRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testIndirectGenericExtension() {
        TypeInformation type = new IndirectExtension().getProducedType();
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)type);
    }

    private static class IndirectExtension
    extends GenericSchema<String> {
        private IndirectExtension() {
        }

        @Override
        public String deserialize(byte[] message) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class GenericSchema<T>
    extends AbstractDeserializationSchema<T> {
        private GenericSchema() {
        }

        public T deserialize(byte[] message) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class RawSchema
    extends AbstractDeserializationSchema {
        private RawSchema() {
        }

        public Object deserialize(byte[] message) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class JsonSchema
    extends AbstractDeserializationSchema<JSONPObject> {
        private JsonSchema() {
        }

        public JSONPObject deserialize(byte[] message) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class TupleSchema
    extends AbstractDeserializationSchema<Tuple2<byte[], byte[]>> {
        private TupleSchema() {
        }

        public Tuple2<byte[], byte[]> deserialize(byte[] message) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

