/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.time.Time;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class StateTtlConfigTest {
    @Test
    public void testStateTtlConfigBuildWithoutCleanupInBackground() {
        StateTtlConfig ttlConfig = StateTtlConfig.newBuilder((Time)Time.seconds((long)1L)).disableCleanupInBackground().build();
        Assert.assertThat((Object)ttlConfig.getCleanupStrategies(), (Matcher)Matchers.notNullValue());
        StateTtlConfig.CleanupStrategies cleanupStrategies = ttlConfig.getCleanupStrategies();
        StateTtlConfig.IncrementalCleanupStrategy incrementalCleanupStrategy = cleanupStrategies.getIncrementalCleanupStrategy();
        StateTtlConfig.RocksdbCompactFilterCleanupStrategy rocksdbCleanupStrategy = cleanupStrategies.getRocksdbCompactFilterCleanupStrategy();
        Assert.assertThat((Object)cleanupStrategies.isCleanupInBackground(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)incrementalCleanupStrategy, (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)rocksdbCleanupStrategy, (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)cleanupStrategies.inRocksdbCompactFilter(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testStateTtlConfigBuildWithCleanupInBackground() {
        StateTtlConfig ttlConfig = StateTtlConfig.newBuilder((Time)Time.seconds((long)1L)).build();
        Assert.assertThat((Object)ttlConfig.getCleanupStrategies(), (Matcher)Matchers.notNullValue());
        StateTtlConfig.CleanupStrategies cleanupStrategies = ttlConfig.getCleanupStrategies();
        StateTtlConfig.IncrementalCleanupStrategy incrementalCleanupStrategy = cleanupStrategies.getIncrementalCleanupStrategy();
        StateTtlConfig.RocksdbCompactFilterCleanupStrategy rocksdbCleanupStrategy = cleanupStrategies.getRocksdbCompactFilterCleanupStrategy();
        Assert.assertThat((Object)cleanupStrategies.isCleanupInBackground(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)incrementalCleanupStrategy, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)rocksdbCleanupStrategy, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)cleanupStrategies.inRocksdbCompactFilter(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)incrementalCleanupStrategy.getCleanupSize(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)incrementalCleanupStrategy.runCleanupForEveryRecord(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)rocksdbCleanupStrategy.getQueryTimeAfterNumEntries(), (Matcher)Matchers.is((Object)1000L));
    }

    @Test
    public void testStateTtlConfigBuildWithNonPositiveCleanupIncrementalSize() {
        List<Integer> illegalCleanUpSizes = Arrays.asList(0, -2);
        for (Integer illegalCleanUpSize : illegalCleanUpSizes) {
            try {
                StateTtlConfig ttlConfig = StateTtlConfig.newBuilder((Time)Time.seconds((long)1L)).cleanupIncrementally(illegalCleanUpSize.intValue(), false).build();
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

