/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.CyclicBarrier;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.java.typeutils.runtime.NullableSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.testutils.CustomEqualityMatcher;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLoggerExtension;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public abstract class SerializerTestBase<T> {
    private final DeeplyEqualsChecker checker;

    protected SerializerTestBase() {
        this.checker = new DeeplyEqualsChecker();
    }

    protected SerializerTestBase(DeeplyEqualsChecker checker) {
        this.checker = checker;
    }

    protected abstract TypeSerializer<T> createSerializer();

    protected abstract int getLength();

    protected abstract Class<T> getTypeClass();

    protected abstract T[] getTestData();

    protected boolean allowNullInstances(TypeSerializer<T> serializer) {
        return serializer.getClass().getName().endsWith("KryoSerializer");
    }

    @Test
    protected void testInstantiate() {
        try {
            TypeSerializer<T> serializer = this.getSerializer();
            Object instance = serializer.createInstance();
            if (instance == null && this.allowNullInstances(serializer)) {
                return;
            }
            Assert.assertNotNull((String)"The created instance must not be null.", (Object)instance);
            Class<T> type = this.getTypeClass();
            Assert.assertNotNull((String)"The test is corrupt: type class is null.", type);
            if (!type.isAssignableFrom(instance.getClass())) {
                Assert.fail((String)("Type of the instantiated object is wrong. Expected Type: " + type + " present type " + instance.getClass()));
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    protected void testConfigSnapshotInstantiation() {
        TypeSerializerSnapshot configSnapshot = this.getSerializer().snapshotConfiguration();
        InstantiationUtil.instantiate(configSnapshot.getClass());
    }

    @Test
    protected void testSnapshotConfigurationAndReconfigure() throws Exception {
        TypeSerializer restoreSerializer;
        TypeSerializerSnapshot restoredConfig;
        byte[] serializedConfig;
        TypeSerializer<T> serializer = this.getSerializer();
        TypeSerializerSnapshot configSnapshot = serializer.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)configSnapshot);
            serializedConfig = out.toByteArray();
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            restoredConfig = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        TypeSerializerSchemaCompatibility strategy = restoredConfig.resolveSchemaCompatibility(this.getSerializer());
        if (strategy.isCompatibleAsIs()) {
            restoreSerializer = restoredConfig.restoreSerializer();
        } else if (strategy.isCompatibleWithReconfiguredSerializer()) {
            restoreSerializer = strategy.getReconfiguredSerializer();
        } else {
            throw new AssertionError((Object)("Unable to restore serializer with " + strategy));
        }
        Assert.assertEquals(serializer.getClass(), restoreSerializer.getClass());
    }

    @Test
    void testGetLength() {
        int len = this.getLength();
        if (len == 0) {
            Assert.fail((String)"Broken serializer test base - zero length cannot be the expected length");
        }
        try {
            TypeSerializer<T> serializer = this.getSerializer();
            Assert.assertEquals((long)len, (long)serializer.getLength());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    protected void testCopy() {
        try {
            T[] testData;
            TypeSerializer<T> serializer = this.getSerializer();
            for (T datum : testData = this.getData()) {
                Object copy = serializer.copy(datum);
                SerializerTestBase.checkToString(copy);
                this.deepEquals("Copied element is not equal to the original element.", datum, copy);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testCopyIntoNewElements() {
        try {
            T[] testData;
            TypeSerializer<T> serializer = this.getSerializer();
            for (T datum : testData = this.getData()) {
                Object copy = serializer.copy(datum, serializer.createInstance());
                SerializerTestBase.checkToString(copy);
                this.deepEquals("Copied element is not equal to the original element.", datum, copy);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testCopyIntoReusedElements() {
        try {
            TypeSerializer<T> serializer = this.getSerializer();
            T[] testData = this.getData();
            Object target = serializer.createInstance();
            for (T datum : testData) {
                Object copy = serializer.copy(datum, target);
                SerializerTestBase.checkToString(copy);
                this.deepEquals("Copied element is not equal to the original element.", datum, copy);
                target = copy;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testSerializeIndividually() {
        try {
            T[] testData;
            TypeSerializer<T> serializer = this.getSerializer();
            for (T value : testData = this.getData()) {
                TestOutputView out = new TestOutputView();
                serializer.serialize(value, (DataOutputView)out);
                TestInputView in = out.getInputView();
                Assert.assertTrue((String)"No data available during deserialization.", (in.available() > 0 ? 1 : 0) != 0);
                Object deserialized = serializer.deserialize(serializer.createInstance(), (DataInputView)in);
                SerializerTestBase.checkToString(deserialized);
                this.deepEquals("Deserialized value if wrong.", value, deserialized);
                Assert.assertTrue((String)"Trailing data available after deserialization.", (in.available() == 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testSerializeIndividuallyReusingValues() {
        try {
            TypeSerializer<T> serializer = this.getSerializer();
            T[] testData = this.getData();
            Object reuseValue = serializer.createInstance();
            for (T value : testData) {
                TestOutputView out = new TestOutputView();
                serializer.serialize(value, (DataOutputView)out);
                TestInputView in = out.getInputView();
                Assert.assertTrue((String)"No data available during deserialization.", (in.available() > 0 ? 1 : 0) != 0);
                Object deserialized = serializer.deserialize(reuseValue, (DataInputView)in);
                SerializerTestBase.checkToString(deserialized);
                this.deepEquals("Deserialized value if wrong.", value, deserialized);
                Assert.assertTrue((String)"Trailing data available after deserialization.", (in.available() == 0 ? 1 : 0) != 0);
                reuseValue = deserialized;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testSerializeAsSequenceNoReuse() {
        try {
            TypeSerializer<T> serializer = this.getSerializer();
            T[] testData = this.getData();
            TestOutputView out = new TestOutputView();
            for (T value : testData) {
                serializer.serialize(value, (DataOutputView)out);
            }
            TestInputView in = out.getInputView();
            int num = 0;
            while (in.available() > 0) {
                Object deserialized = serializer.deserialize((DataInputView)in);
                SerializerTestBase.checkToString(deserialized);
                this.deepEquals("Deserialized value if wrong.", testData[num], deserialized);
                ++num;
            }
            Assert.assertEquals((String)"Wrong number of elements deserialized.", (long)testData.length, (long)num);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testSerializeAsSequenceReusingValues() {
        try {
            TypeSerializer<T> serializer = this.getSerializer();
            T[] testData = this.getData();
            TestOutputView out = new TestOutputView();
            for (T value : testData) {
                serializer.serialize(value, (DataOutputView)out);
            }
            TestInputView in = out.getInputView();
            Object reuseValue = serializer.createInstance();
            int num = 0;
            while (in.available() > 0) {
                Object deserialized = serializer.deserialize(reuseValue, (DataInputView)in);
                SerializerTestBase.checkToString(deserialized);
                this.deepEquals("Deserialized value if wrong.", testData[num], deserialized);
                reuseValue = deserialized;
                ++num;
            }
            Assert.assertEquals((String)"Wrong number of elements deserialized.", (long)testData.length, (long)num);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testSerializedCopyIndividually() {
        try {
            T[] testData;
            TypeSerializer<T> serializer = this.getSerializer();
            for (T value : testData = this.getData()) {
                TestOutputView out = new TestOutputView();
                serializer.serialize(value, (DataOutputView)out);
                TestInputView source = out.getInputView();
                TestOutputView target = new TestOutputView();
                serializer.copy((DataInputView)source, (DataOutputView)target);
                TestInputView toVerify = target.getInputView();
                Assert.assertTrue((String)"No data available copying.", (toVerify.available() > 0 ? 1 : 0) != 0);
                Object deserialized = serializer.deserialize(serializer.createInstance(), (DataInputView)toVerify);
                SerializerTestBase.checkToString(deserialized);
                this.deepEquals("Deserialized value if wrong.", value, deserialized);
                Assert.assertTrue((String)"Trailing data available after deserialization.", (toVerify.available() == 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testSerializedCopyAsSequence() {
        try {
            TypeSerializer<T> serializer = this.getSerializer();
            T[] testData = this.getData();
            TestOutputView out = new TestOutputView();
            for (T value : testData) {
                serializer.serialize(value, (DataOutputView)out);
            }
            TestInputView source = out.getInputView();
            TestOutputView target = new TestOutputView();
            for (int i = 0; i < testData.length; ++i) {
                serializer.copy((DataInputView)source, (DataOutputView)target);
            }
            TestInputView toVerify = target.getInputView();
            int num = 0;
            while (toVerify.available() > 0) {
                Object deserialized = serializer.deserialize(serializer.createInstance(), (DataInputView)toVerify);
                SerializerTestBase.checkToString(deserialized);
                this.deepEquals("Deserialized value if wrong.", testData[num], deserialized);
                ++num;
            }
            Assert.assertEquals((String)"Wrong number of elements copied.", (long)testData.length, (long)num);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testSerializabilityAndEquals() {
        try {
            TypeSerializer ser2;
            TypeSerializer<T> ser1 = this.getSerializer();
            try {
                ser2 = (TypeSerializer)SerializationUtils.clone(ser1);
            }
            catch (SerializationException e) {
                Assert.fail((String)("The serializer is not serializable: " + (Object)((Object)e)));
                return;
            }
            Assert.assertEquals((String)"The copy of the serializer is not equal to the original one.", ser1, (Object)ser2);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            Assert.fail((String)("Exception in test: " + e.getMessage()));
        }
    }

    @Test
    void testNullability() {
        TypeSerializer<T> serializer = this.getSerializer();
        try {
            NullableSerializer.checkIfNullSupported(serializer);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)("Unexpected failure of null value handling: " + t.getMessage()));
        }
    }

    @Test
    void testDuplicate() throws Exception {
        int numThreads = 10;
        TypeSerializer<T> serializer = this.getSerializer();
        CyclicBarrier startLatch = new CyclicBarrier(10);
        ArrayList<SerializerRunner<T>> concurrentRunners = new ArrayList<SerializerRunner<T>>(10);
        Assert.assertEquals(serializer, (Object)serializer.duplicate());
        T[] testData = this.getData();
        for (int i = 0; i < 10; ++i) {
            SerializerRunner<T> serializerRunner = new SerializerRunner<T>(startLatch, serializer.duplicate(), testData, 120L, this.checker);
            serializerRunner.start();
            concurrentRunners.add(serializerRunner);
        }
        for (SerializerRunner serializerRunner : concurrentRunners) {
            serializerRunner.join();
            serializerRunner.checkResult();
        }
    }

    private void deepEquals(String message, T should, T is) {
        Assert.assertThat((String)message, is, (Matcher)CustomEqualityMatcher.deeplyEquals(should).withChecker(this.checker));
    }

    protected TypeSerializer<T> getSerializer() {
        TypeSerializer<T> serializer = this.createSerializer();
        if (serializer == null) {
            throw new RuntimeException("Test case corrupt. Returns null as serializer.");
        }
        return serializer;
    }

    private T[] getData() {
        T[] data = this.getTestData();
        if (data == null) {
            throw new RuntimeException("Test case corrupt. Returns null as test data.");
        }
        return data;
    }

    private static <T> void checkToString(T value) {
        if (value != null) {
            value.toString();
        }
    }

    private static final class TestInputView
    extends DataInputStream
    implements DataInputView {
        public TestInputView(byte[] data) {
            super(new ByteArrayInputStream(data));
        }

        public void skipBytesToRead(int numBytes) throws IOException {
            while (numBytes > 0) {
                int skipped = this.skipBytes(numBytes);
                numBytes -= skipped;
            }
        }
    }

    static class SerializerRunner<T>
    extends Thread {
        final CyclicBarrier allReadyBarrier;
        final TypeSerializer<T> serializer;
        final T[] testData;
        final long durationLimitMillis;
        Throwable failure;
        final DeeplyEqualsChecker checker;

        SerializerRunner(CyclicBarrier allReadyBarrier, TypeSerializer<T> serializer, T[] testData, long testTargetDurationMillis, DeeplyEqualsChecker checker) {
            this.allReadyBarrier = allReadyBarrier;
            this.serializer = serializer;
            this.testData = testData;
            this.durationLimitMillis = testTargetDurationMillis;
            this.checker = checker;
            this.failure = null;
        }

        @Override
        public void run() {
            DataInputDeserializer dataInputDeserializer = new DataInputDeserializer();
            DataOutputSerializer dataOutputSerializer = new DataOutputSerializer(128);
            try {
                this.allReadyBarrier.await();
                long endTimeNanos = System.nanoTime() + this.durationLimitMillis * 1000000L;
                block2: while (true) {
                    T[] TArray = this.testData;
                    int n = TArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block2;
                        T testItem = TArray[n2];
                        this.serializer.serialize(testItem, (DataOutputView)dataOutputSerializer);
                        dataInputDeserializer.setBuffer(dataOutputSerializer.getSharedBuffer(), 0, dataOutputSerializer.length());
                        Object serdeTestItem = this.serializer.deserialize((DataInputView)dataInputDeserializer);
                        Object copySerdeTestItem = this.serializer.copy(serdeTestItem);
                        dataOutputSerializer.clear();
                        Assert.assertThat((String)"Serialization/Deserialization cycle resulted in an object that are not equal to the original.", (Object)copySerdeTestItem, (Matcher)CustomEqualityMatcher.deeplyEquals(testItem).withChecker(this.checker));
                        if (System.nanoTime() >= endTimeNanos) {
                            return;
                        }
                        ++n2;
                    }
                    break;
                }
            }
            catch (Throwable ex) {
                this.failure = ex;
                return;
            }
        }

        void checkResult() throws Exception {
            if (this.failure != null) {
                if (this.failure instanceof AssertionError) {
                    throw (AssertionError)((Object)this.failure);
                }
                throw (Exception)this.failure;
            }
        }
    }

    private static final class TestOutputView
    extends DataOutputStream
    implements DataOutputView {
        public TestOutputView() {
            super(new ByteArrayOutputStream(4096));
        }

        public TestInputView getInputView() {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
            return new TestInputView(baos.toByteArray());
        }

        public void skipBytesToWrite(int numBytes) throws IOException {
            for (int i = 0; i < numBytes; ++i) {
                this.write(0);
            }
        }

        public void write(DataInputView source, int numBytes) throws IOException {
            byte[] buffer = new byte[numBytes];
            source.readFully(buffer);
            this.write(buffer);
        }
    }
}

