/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.util.Random;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;

class BytePrimitiveArraySerializerTest
extends SerializerTestBase<byte[]> {
    private final Random rnd = new Random(346283764872L);

    BytePrimitiveArraySerializerTest() {
    }

    @Override
    protected TypeSerializer<byte[]> createSerializer() {
        return new BytePrimitiveArraySerializer();
    }

    @Override
    protected Class<byte[]> getTypeClass() {
        return byte[].class;
    }

    @Override
    protected int getLength() {
        return -1;
    }

    protected byte[][] getTestData() {
        return new byte[][]{this.randomByteArray(), this.randomByteArray(), new byte[0], this.randomByteArray(), this.randomByteArray(), this.randomByteArray(), new byte[0], this.randomByteArray(), this.randomByteArray(), this.randomByteArray(), new byte[0]};
    }

    private final byte[] randomByteArray() {
        int len = this.rnd.nextInt(0x100000);
        byte[] data = new byte[len];
        for (int i = 0; i < len; ++i) {
            data[i] = (byte)this.rnd.nextInt();
        }
        return data;
    }
}

