/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.functions.JoinFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.MapPartitionFunction;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.MissingTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractionException;
import org.apache.flink.api.java.typeutils.TypeExtractionUtils;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.junit.Assert;
import org.junit.Test;

public class LambdaExtractionTest {
    private static final TypeInformation<Tuple2<Tuple1<Integer>, Boolean>> NESTED_TUPLE_BOOLEAN_TYPE = new TypeHint<Tuple2<Tuple1<Integer>, Boolean>>(){}.getTypeInfo();
    private static final TypeInformation<Tuple2<Tuple1<Integer>, Double>> NESTED_TUPLE_DOUBLE_TYPE = new TypeHint<Tuple2<Tuple1<Integer>, Double>>(){}.getTypeInfo();
    private static final MapFunction<String, Integer> STATIC_LAMBDA = Integer::parseInt;

    @Test
    public void testIdentifyLambdas() throws TypeExtractionException {
        MapFunction<String, Integer> anonymousFromInterface = new MapFunction<String, Integer>(){

            public Integer map(String value) {
                return Integer.parseInt(value);
            }
        };
        RichMapFunction<String, Integer> anonymousFromClass = new RichMapFunction<String, Integer>(){

            public Integer map(String value) {
                return Integer.parseInt(value);
            }
        };
        StaticMapper fromProperClass = new StaticMapper();
        ToTuple<Integer> fromDerived = new ToTuple<Integer>(){

            @Override
            public Tuple2<Integer, Long> map(Integer value) {
                return new Tuple2((Object)value, (Object)1L);
            }
        };
        MapFunction & Serializable staticLambda = Integer::parseInt;
        MapFunction & Serializable instanceLambda = Object::toString;
        MapFunction & Serializable constructorLambda = Integer::new;
        Assert.assertNull((Object)TypeExtractionUtils.checkAndExtractLambda((Function)anonymousFromInterface));
        Assert.assertNull((Object)TypeExtractionUtils.checkAndExtractLambda((Function)anonymousFromClass));
        Assert.assertNull((Object)TypeExtractionUtils.checkAndExtractLambda((Function)fromProperClass));
        Assert.assertNull((Object)TypeExtractionUtils.checkAndExtractLambda((Function)fromDerived));
        Assert.assertNotNull((Object)TypeExtractionUtils.checkAndExtractLambda((Function)staticLambda));
        Assert.assertNotNull((Object)TypeExtractionUtils.checkAndExtractLambda((Function)instanceLambda));
        Assert.assertNotNull((Object)TypeExtractionUtils.checkAndExtractLambda((Function)constructorLambda));
        Assert.assertNotNull((Object)TypeExtractionUtils.checkAndExtractLambda(STATIC_LAMBDA));
    }

    @Test
    public void testLambdaWithMemberVariable() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(new MyClass().getMapFunction(), (TypeInformation)Types.INT);
        Assert.assertEquals((Object)ti, (Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    public void testLambdaWithLocalVariable() {
        String s = "mystring";
        int k = 24;
        int j = 26;
        MapFunction & Serializable f = (MapFunction & Serializable)i -> s + 24 + j;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)Types.INT);
        Assert.assertEquals((Object)ti, (Object)BasicTypeInfo.STRING_TYPE_INFO);
    }

    @Test
    public void testLambdaWithNonGenericResultType() {
        MapFunction & Serializable f = (MapFunction & Serializable)i -> null;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof BasicTypeInfo));
        Assert.assertEquals((Object)BasicTypeInfo.BOOLEAN_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testMapLambda() {
        MapFunction & Serializable f = (MapFunction & Serializable)i -> null;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assert.assertTrue((boolean)ti.isTupleType());
            Assert.assertEquals((long)2L, (long)ti.getArity());
            Assert.assertTrue((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType());
            Assert.assertEquals((Object)((TupleTypeInfo)ti).getTypeAt(1), (Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    public void testFlatMapLambda() {
        FlatMapFunction & Serializable f = (FlatMapFunction & Serializable)(i, out) -> out.collect(null);
        TypeInformation ti = TypeExtractor.getFlatMapReturnTypes((FlatMapFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assert.assertTrue((boolean)ti.isTupleType());
            Assert.assertEquals((long)2L, (long)ti.getArity());
            Assert.assertTrue((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType());
            Assert.assertEquals((Object)((TupleTypeInfo)ti).getTypeAt(1), (Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    public void testMapPartitionLambda() {
        MapPartitionFunction & Serializable f = (MapPartitionFunction & Serializable)(i, o) -> {};
        TypeInformation ti = TypeExtractor.getMapPartitionReturnTypes((MapPartitionFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assert.assertTrue((boolean)ti.isTupleType());
            Assert.assertEquals((long)2L, (long)ti.getArity());
            Assert.assertTrue((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType());
            Assert.assertEquals((Object)((TupleTypeInfo)ti).getTypeAt(1), (Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    public void testJoinLambda() {
        JoinFunction & Serializable f = (JoinFunction & Serializable)(i1, i2) -> null;
        TypeInformation ti = TypeExtractor.getJoinReturnTypes((JoinFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, NESTED_TUPLE_DOUBLE_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assert.assertTrue((boolean)ti.isTupleType());
            Assert.assertEquals((long)2L, (long)ti.getArity());
            Assert.assertTrue((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType());
            Assert.assertEquals((Object)((TupleTypeInfo)ti).getTypeAt(1), (Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    public void testCoGroupLambda() {
        CoGroupFunction & Serializable f = (CoGroupFunction & Serializable)(i1, i2, o) -> {};
        TypeInformation ti = TypeExtractor.getCoGroupReturnTypes((CoGroupFunction)f, NESTED_TUPLE_BOOLEAN_TYPE, NESTED_TUPLE_DOUBLE_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assert.assertTrue((boolean)ti.isTupleType());
            Assert.assertEquals((long)2L, (long)ti.getArity());
            Assert.assertTrue((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType());
            Assert.assertEquals((Object)((TupleTypeInfo)ti).getTypeAt(1), (Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    public void testKeySelectorLambda() {
        KeySelector & Serializable f = (KeySelector & Serializable)i -> null;
        TypeInformation ti = TypeExtractor.getKeySelectorTypes((KeySelector)f, NESTED_TUPLE_BOOLEAN_TYPE, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assert.assertTrue((boolean)ti.isTupleType());
            Assert.assertEquals((long)2L, (long)ti.getArity());
            Assert.assertTrue((boolean)((TupleTypeInfo)ti).getTypeAt(0).isTupleType());
            Assert.assertEquals((Object)((TupleTypeInfo)ti).getTypeAt(1), (Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    public void testLambdaTypeErasure() {
        MapFunction & Serializable f = (MapFunction & Serializable)i -> null;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)new TypeHint<Tuple1<Integer>>(){}.getTypeInfo(), null, (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof MissingTypeInfo));
    }

    @Test
    public void testLambdaWithoutTypeErasure() {
        TypeInformation ti = TypeExtractor.getMapReturnTypes(Tuple1::of, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, null, (boolean)true);
        Assert.assertTrue((boolean)(ti instanceof MissingTypeInfo));
    }

    @Test
    public void testPartitionerLambda() {
        Partitioner & Serializable partitioner = (Partitioner & Serializable)(key, numPartitions) -> ((String)key.f1).length() % numPartitions;
        TypeInformation ti = TypeExtractor.getPartitionerTypes((Partitioner)partitioner, null, (boolean)true);
        if (!(ti instanceof MissingTypeInfo)) {
            Assert.assertTrue((boolean)ti.isTupleType());
            Assert.assertEquals((long)2L, (long)ti.getArity());
            Assert.assertEquals((Object)((TupleTypeInfo)ti).getTypeAt(0), (Object)BasicTypeInfo.INT_TYPE_INFO);
            Assert.assertEquals((Object)((TupleTypeInfo)ti).getTypeAt(1), (Object)BasicTypeInfo.STRING_TYPE_INFO);
        }
    }

    @Test
    public void testInstanceMethodRefSameType() {
        MapFunction & Serializable f = MyType::getKey;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)TypeExtractor.createTypeInfo(MyType.class));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testInstanceMethodRefSuperType() {
        MapFunction & Serializable f = Object::toString;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO);
        Assert.assertEquals((Object)BasicTypeInfo.STRING_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testInstanceMethodRefSuperTypeProtected() {
        MapFunction & Serializable f = MyType::getKey2;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)TypeExtractor.createTypeInfo(MySubtype.class));
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testConstructorMethodRef() {
        MapFunction & Serializable f = Integer::new;
        TypeInformation ti = TypeExtractor.getMapReturnTypes((MapFunction)f, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        Assert.assertEquals((Object)BasicTypeInfo.INT_TYPE_INFO, (Object)ti);
    }

    @Test
    public void testSamMethodExtractionInterfaceWithDefaultMethod() {
        Method sam = TypeExtractionUtils.getSingleAbstractMethod(InterfaceWithDefaultMethod.class);
        Assert.assertNotNull((Object)sam);
        Assert.assertEquals((Object)"samMethod", (Object)sam.getName());
    }

    @Test(expected=InvalidTypesException.class)
    public void getSingleAbstractMethodMultipleMethods() {
        TypeExtractionUtils.getSingleAbstractMethod(InterfaceWithMultipleMethods.class);
    }

    @Test(expected=InvalidTypesException.class)
    public void testSingleAbstractMethodNoAbstractMethods() {
        TypeExtractionUtils.getSingleAbstractMethod(InterfaceWithoutAbstractMethod.class);
    }

    @Test(expected=InvalidTypesException.class)
    public void testSingleAbstractMethodNotAnInterface() {
        TypeExtractionUtils.getSingleAbstractMethod(AbstractClassWithSingleAbstractMethod.class);
    }

    private abstract class AbstractClassWithSingleAbstractMethod {
        private AbstractClassWithSingleAbstractMethod() {
        }

        public abstract void defaultMethod();
    }

    private static interface InterfaceWithoutAbstractMethod {
        default public void defaultMethod() {
        }
    }

    private static interface InterfaceWithMultipleMethods {
        public void firstMethod();

        public void secondMethod();
    }

    private static interface InterfaceWithDefaultMethod {
        public void samMethod();

        default public void defaultMethod() {
        }
    }

    private static class MySubtype
    extends MyType {
        public boolean test;

        private MySubtype() {
        }
    }

    private static class MyType {
        private int key;

        private MyType() {
        }

        public int getKey() {
            return this.key;
        }

        public void setKey(int key) {
            this.key = key;
        }

        protected int getKey2() {
            return 0;
        }
    }

    private static class MyClass {
        private String s = "mystring";

        private MyClass() {
        }

        public MapFunction<Integer, String> getMapFunction() {
            return (MapFunction & Serializable)i -> this.s;
        }
    }

    private static interface ToTuple<T>
    extends MapFunction<T, Tuple2<T, Long>> {
        public Tuple2<T, Long> map(T var1) throws Exception;
    }

    private static class StaticMapper
    implements MapFunction<String, Integer> {
        private StaticMapper() {
        }

        public Integer map(String value) {
            return Integer.parseInt(value);
        }
    }
}

