/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.util.Objects;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.ClassRelocator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerMatchers;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerUpgradeTestBase;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class PojoSerializerUpgradeTestSpecifications {

    public static final class NewAndMissingRegisteredPojoSubclassesVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(StaticSchemaPojoSubclassB.class);
            executionConfig.registerPojoType(StaticSchemaPojoSubclassC.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<StaticSchemaPojo> testDataMatcher() {
            return Matchers.is((Object)new StaticSchemaPojoSubclassB("gt", 7, StaticSchemaPojo.Color.BLUE, false, true));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<StaticSchemaPojo>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleWithReconfiguredSerializer();
        }
    }

    public static final class NewAndMissingRegisteredPojoSubclassesSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createPriorSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(StaticSchemaPojoSubclassA.class);
            executionConfig.registerPojoType(StaticSchemaPojoSubclassB.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public StaticSchemaPojo createTestData() {
            return new StaticSchemaPojoSubclassB("gt", 7, StaticSchemaPojo.Color.BLUE, false, true);
        }
    }

    public static final class NewRegisteredPojoSubclassVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(StaticSchemaPojoSubclassA.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<StaticSchemaPojo> testDataMatcher() {
            return Matchers.is((Object)new StaticSchemaPojoSubclassA("gt", 7, StaticSchemaPojo.Color.BLUE, false, 911108));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<StaticSchemaPojo>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleWithReconfiguredSerializer();
        }
    }

    public static final class NewRegisteredPojoSubclassSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createPriorSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public StaticSchemaPojo createTestData() {
            return new StaticSchemaPojoSubclassA("gt", 7, StaticSchemaPojo.Color.BLUE, false, 911108);
        }
    }

    public static final class MissingRegisteredPojoSubclassVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(StaticSchemaPojoSubclassB.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<StaticSchemaPojo> testDataMatcher() {
            return Matchers.is((Object)new StaticSchemaPojoSubclassB("gt", 7, StaticSchemaPojo.Color.BLUE, false, true));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<StaticSchemaPojo>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleWithReconfiguredSerializer();
        }
    }

    public static final class MissingRegisteredPojoSubclassSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createPriorSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(StaticSchemaPojoSubclassA.class);
            executionConfig.registerPojoType(StaticSchemaPojoSubclassB.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public StaticSchemaPojo createTestData() {
            return new StaticSchemaPojoSubclassB("gt", 7, StaticSchemaPojo.Color.BLUE, false, true);
        }
    }

    public static final class DifferentPojoSubclassRegistrationOrderVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(StaticSchemaPojoSubclassB.class);
            executionConfig.registerPojoType(StaticSchemaPojoSubclassA.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<StaticSchemaPojo> testDataMatcher() {
            return Matchers.is((Object)new StaticSchemaPojoSubclassB("gt", 7, StaticSchemaPojo.Color.BLUE, false, true));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<StaticSchemaPojo>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleWithReconfiguredSerializer();
        }
    }

    public static final class DifferentPojoSubclassRegistrationOrderSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createPriorSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(StaticSchemaPojoSubclassA.class);
            executionConfig.registerPojoType(StaticSchemaPojoSubclassB.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public StaticSchemaPojo createTestData() {
            return new StaticSchemaPojoSubclassB("gt", 7, StaticSchemaPojo.Color.BLUE, false, true);
        }
    }

    public static final class NonRegisteredPojoSubclassVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(new ExecutionConfig());
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<StaticSchemaPojo> testDataMatcher() {
            return Matchers.is((Object)new StaticSchemaPojoSubclassA("gt", 7, StaticSchemaPojo.Color.BLUE, false, 911108));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<StaticSchemaPojo>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleWithReconfiguredSerializer();
        }
    }

    public static final class NonRegisteredPojoSubclassSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(new ExecutionConfig());
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public StaticSchemaPojo createTestData() {
            return new StaticSchemaPojoSubclassA("gt", 7, StaticSchemaPojo.Color.BLUE, false, 911108);
        }
    }

    public static final class DifferentFieldTypePojoSubclassSchemaVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(SubclassPojoWithStringField.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<StaticSchemaPojo> testDataMatcher() {
            return Matchers.is((Object)new SubclassPojoWithStringField("gt", 7, StaticSchemaPojo.Color.BLUE, false, "911108"));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<StaticSchemaPojo>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isIncompatible();
        }

        @ClassRelocator.RelocateClass(value="TestPojoSubclassWithDifferentFieldType")
        public static class SubclassPojoWithStringField
        extends StaticSchemaPojo {
            public String fieldValue;

            public SubclassPojoWithStringField() {
            }

            public SubclassPojoWithStringField(String name, int age, StaticSchemaPojo.Color favoriteColor, boolean married, String fieldValue) {
                super(name, age, favoriteColor, married);
                this.fieldValue = fieldValue;
            }
        }
    }

    public static final class DifferentFieldTypePojoSubclassSchemaSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createPriorSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(SubclassPojoWithIntField.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public StaticSchemaPojo createTestData() {
            return new SubclassPojoWithIntField("gt", 7, StaticSchemaPojo.Color.BLUE, false, 911108);
        }

        @ClassRelocator.RelocateClass(value="TestPojoSubclassWithDifferentFieldType")
        public static class SubclassPojoWithIntField
        extends StaticSchemaPojo {
            public int fieldValue;

            public SubclassPojoWithIntField() {
            }

            public SubclassPojoWithIntField(String name, int age, StaticSchemaPojo.Color favoriteColor, boolean married, int fieldValue) {
                super(name, age, favoriteColor, married);
                this.fieldValue = fieldValue;
            }
        }
    }

    public static final class ModifiedRegisteredPojoSubclassSchemaVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<BasePojo> {
        @Override
        public TypeSerializer<BasePojo> createUpgradedSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(SubclassPojoAfterSchemaUpgrade.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(BasePojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<BasePojo> testDataMatcher() {
            return Matchers.is((Object)new SubclassPojoAfterSchemaUpgrade(911108, "Gordon", true, 0L, 0.0));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<BasePojo>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAfterMigration();
        }

        @ClassRelocator.RelocateClass(value="SublassPojo")
        public static class SubclassPojoAfterSchemaUpgrade
        extends BasePojo {
            public boolean subclassFieldC;
            public long subclassFieldE;
            public double subclassFieldF;

            public SubclassPojoAfterSchemaUpgrade() {
            }

            public SubclassPojoAfterSchemaUpgrade(int baseFieldA, String baseFieldB, boolean subclassFieldC, long subclassFieldE, double subclassFieldF) {
                super(baseFieldA, baseFieldB);
                this.subclassFieldC = subclassFieldC;
                this.subclassFieldE = subclassFieldE;
                this.subclassFieldF = subclassFieldF;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof SubclassPojoAfterSchemaUpgrade)) {
                    return false;
                }
                SubclassPojoAfterSchemaUpgrade other = (SubclassPojoAfterSchemaUpgrade)obj;
                return other.baseFieldA == this.baseFieldA && Objects.equals(other.baseFieldB, this.baseFieldB) && other.subclassFieldC == this.subclassFieldC && other.subclassFieldE == this.subclassFieldE && other.subclassFieldF == this.subclassFieldF;
            }

            public int hashCode() {
                return Objects.hash(this.baseFieldA, this.baseFieldB, this.subclassFieldC, this.subclassFieldE, this.subclassFieldF);
            }
        }

        @ClassRelocator.RelocateClass(value="BasePojo")
        public static class BasePojo {
            public int baseFieldA;
            public String baseFieldB;

            public BasePojo() {
            }

            public BasePojo(int baseFieldA, String baseFieldB) {
                this.baseFieldA = baseFieldA;
                this.baseFieldB = baseFieldB;
            }
        }
    }

    public static final class ModifiedRegisteredPojoSubclassSchemaSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<BasePojo> {
        @Override
        public TypeSerializer<BasePojo> createPriorSerializer() {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.registerPojoType(SubclassPojoBeforeSchemaUpgrade.class);
            TypeSerializer serializer = TypeExtractor.createTypeInfo(BasePojo.class).createSerializer(executionConfig);
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public BasePojo createTestData() {
            return new SubclassPojoBeforeSchemaUpgrade(911108, "Gordon", true, 66.7);
        }

        @ClassRelocator.RelocateClass(value="SublassPojo")
        public static class SubclassPojoBeforeSchemaUpgrade
        extends BasePojo {
            public boolean subclassFieldC;
            public double subclassFieldD;

            public SubclassPojoBeforeSchemaUpgrade() {
            }

            public SubclassPojoBeforeSchemaUpgrade(int baseFieldA, String baseFieldB, boolean subclassFieldC, double subclassFieldD) {
                super(baseFieldA, baseFieldB);
                this.subclassFieldC = subclassFieldC;
                this.subclassFieldD = subclassFieldD;
            }
        }

        @ClassRelocator.RelocateClass(value="BasePojo")
        public static class BasePojo {
            public int baseFieldA;
            public String baseFieldB;

            public BasePojo() {
            }

            public BasePojo(int baseFieldA, String baseFieldB) {
                this.baseFieldA = baseFieldA;
                this.baseFieldB = baseFieldB;
            }
        }
    }

    public static final class DifferentFieldTypePojoSchemaVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<PojoWithStringField> {
        @Override
        public TypeSerializer<PojoWithStringField> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(PojoWithStringField.class).createSerializer(new ExecutionConfig());
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<PojoWithStringField> testDataMatcher() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<PojoWithStringField>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isIncompatible();
        }

        @ClassRelocator.RelocateClass(value="TestPojoWithDifferentFieldType")
        public static class PojoWithStringField {
            public String fieldValue;

            public PojoWithStringField() {
            }

            public PojoWithStringField(String fieldValue) {
                this.fieldValue = fieldValue;
            }
        }
    }

    public static final class DifferentFieldTypePojoSchemaSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<PojoWithIntField> {
        @Override
        public TypeSerializer<PojoWithIntField> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(PojoWithIntField.class).createSerializer(new ExecutionConfig());
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public PojoWithIntField createTestData() {
            return new PojoWithIntField(911108);
        }

        @ClassRelocator.RelocateClass(value="TestPojoWithDifferentFieldType")
        public static class PojoWithIntField {
            public int fieldValue;

            public PojoWithIntField() {
            }

            public PojoWithIntField(int fieldValue) {
                this.fieldValue = fieldValue;
            }
        }
    }

    public static final class ModifiedPojoSchemaVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<PojoAfterSchemaUpgrade> {
        @Override
        public TypeSerializer<PojoAfterSchemaUpgrade> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(PojoAfterSchemaUpgrade.class).createSerializer(new ExecutionConfig());
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<PojoAfterSchemaUpgrade> testDataMatcher() {
            return Matchers.is((Object)new PojoAfterSchemaUpgrade("Gordon", 27, null, false));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<PojoAfterSchemaUpgrade>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAfterMigration();
        }

        @ClassRelocator.RelocateClass(value="TestPojoWithModifiedSchema")
        public static class PojoAfterSchemaUpgrade {
            public String name;
            public int age;
            public Color favoriteColor;
            public boolean married;

            public PojoAfterSchemaUpgrade() {
            }

            public PojoAfterSchemaUpgrade(String name, int age, Color favoriteColor, boolean married) {
                this.name = name;
                this.age = age;
                this.favoriteColor = favoriteColor;
                this.married = married;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof PojoAfterSchemaUpgrade)) {
                    return false;
                }
                PojoAfterSchemaUpgrade other = (PojoAfterSchemaUpgrade)obj;
                return Objects.equals(other.name, this.name) && other.age == this.age && other.favoriteColor == this.favoriteColor && other.married == this.married;
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.name, this.age, this.favoriteColor, this.married});
            }

            public static enum Color {
                RED,
                BLUE,
                GREEN;

            }
        }
    }

    public static final class ModifiedPojoSchemaSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<PojoBeforeSchemaUpgrade> {
        @Override
        public TypeSerializer<PojoBeforeSchemaUpgrade> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(PojoBeforeSchemaUpgrade.class).createSerializer(new ExecutionConfig());
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public PojoBeforeSchemaUpgrade createTestData() {
            return new PojoBeforeSchemaUpgrade(911108, "Gordon", 27, 172.8);
        }

        @ClassRelocator.RelocateClass(value="TestPojoWithModifiedSchema")
        public static class PojoBeforeSchemaUpgrade {
            public int id;
            public String name;
            public int age;
            public double height;

            public PojoBeforeSchemaUpgrade() {
            }

            public PojoBeforeSchemaUpgrade(int id, String name, int age, double height) {
                this.id = id;
                this.name = name;
                this.age = age;
                this.height = height;
            }
        }
    }

    public static final class IdenticalPojoSchemaVerifier
    implements TypeSerializerUpgradeTestBase.UpgradeVerifier<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createUpgradedSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(new ExecutionConfig());
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public Matcher<StaticSchemaPojo> testDataMatcher() {
            return Matchers.is((Object)new StaticSchemaPojo("Gordon", 27, StaticSchemaPojo.Color.BLUE, false));
        }

        @Override
        public Matcher<TypeSerializerSchemaCompatibility<StaticSchemaPojo>> schemaCompatibilityMatcher(FlinkVersion version) {
            return TypeSerializerMatchers.isCompatibleAsIs();
        }
    }

    public static final class IdenticalPojoSchemaSetup
    implements TypeSerializerUpgradeTestBase.PreUpgradeSetup<StaticSchemaPojo> {
        @Override
        public TypeSerializer<StaticSchemaPojo> createPriorSerializer() {
            TypeSerializer serializer = TypeExtractor.createTypeInfo(StaticSchemaPojo.class).createSerializer(new ExecutionConfig());
            Assert.assertSame(PojoSerializer.class, serializer.getClass());
            return serializer;
        }

        @Override
        public StaticSchemaPojo createTestData() {
            return new StaticSchemaPojo("Gordon", 27, StaticSchemaPojo.Color.BLUE, false);
        }
    }

    public static class StaticSchemaPojoSubclassC
    extends StaticSchemaPojo {
        public double subclassField;

        public StaticSchemaPojoSubclassC() {
        }

        public StaticSchemaPojoSubclassC(String name, int age, StaticSchemaPojo.Color favoriteColor, boolean married, double subclassField) {
            super(name, age, favoriteColor, married);
            this.subclassField = subclassField;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StaticSchemaPojoSubclassC)) {
                return false;
            }
            StaticSchemaPojoSubclassC other = (StaticSchemaPojoSubclassC)obj;
            return Objects.equals(this.name, other.name) && this.age == other.age && this.favoriteColor == other.favoriteColor && this.married == other.married && this.subclassField == other.subclassField;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.age, this.favoriteColor, this.married, this.subclassField});
        }
    }

    public static class StaticSchemaPojoSubclassB
    extends StaticSchemaPojo {
        public boolean subclassField;

        public StaticSchemaPojoSubclassB() {
        }

        public StaticSchemaPojoSubclassB(String name, int age, StaticSchemaPojo.Color favoriteColor, boolean married, boolean subclassField) {
            super(name, age, favoriteColor, married);
            this.subclassField = subclassField;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StaticSchemaPojoSubclassB)) {
                return false;
            }
            StaticSchemaPojoSubclassB other = (StaticSchemaPojoSubclassB)obj;
            return Objects.equals(this.name, other.name) && this.age == other.age && this.favoriteColor == other.favoriteColor && this.married == other.married && this.subclassField == other.subclassField;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.age, this.favoriteColor, this.married, this.subclassField});
        }
    }

    public static class StaticSchemaPojoSubclassA
    extends StaticSchemaPojo {
        public int subclassField;

        public StaticSchemaPojoSubclassA() {
        }

        public StaticSchemaPojoSubclassA(String name, int age, StaticSchemaPojo.Color favoriteColor, boolean married, int subclassField) {
            super(name, age, favoriteColor, married);
            this.subclassField = subclassField;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StaticSchemaPojoSubclassA)) {
                return false;
            }
            StaticSchemaPojoSubclassA other = (StaticSchemaPojoSubclassA)obj;
            return Objects.equals(this.name, other.name) && this.age == other.age && this.favoriteColor == other.favoriteColor && this.married == other.married && this.subclassField == other.subclassField;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.age, this.favoriteColor, this.married, this.subclassField});
        }
    }

    public static class StaticSchemaPojo {
        public String name;
        public int age;
        public Color favoriteColor;
        public boolean married;

        public StaticSchemaPojo() {
        }

        public StaticSchemaPojo(String name, int age, Color favoriteColor, boolean married) {
            this.name = name;
            this.age = age;
            this.favoriteColor = favoriteColor;
            this.married = married;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StaticSchemaPojo)) {
                return false;
            }
            StaticSchemaPojo other = (StaticSchemaPojo)obj;
            return Objects.equals(this.name, other.name) && this.age == other.age && this.favoriteColor == other.favoriteColor && this.married == other.married;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.age, this.favoriteColor, this.married});
        }

        public static enum Color {
            RED,
            BLUE,
            GREEN;

        }
    }
}

