/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import com.esotericsoftware.kryo.Kryo;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.ComparatorTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.AbstractGenericTypeSerializerTest;
import org.apache.flink.api.java.typeutils.runtime.TestDataOutputSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.junit.Assert;
import org.junit.Test;

public class KryoGenericTypeSerializerTest
extends AbstractGenericTypeSerializerTest {
    ExecutionConfig ec = new ExecutionConfig();

    @Test
    public void testJavaList() {
        ArrayList<Integer> a = new ArrayList<Integer>();
        this.fillCollection(a);
        this.runTests(a);
    }

    @Test
    public void testJavaSet() {
        HashSet<Integer> b = new HashSet<Integer>();
        this.fillCollection(b);
        this.runTests(b);
    }

    @Test
    public void testJavaDequeue() {
        LinkedList<Integer> c = new LinkedList<Integer>();
        this.fillCollection(c);
        this.runTests(c);
    }

    private void fillCollection(Collection<Integer> coll) {
        coll.add(42);
        coll.add(1337);
        coll.add(49);
        coll.add(1);
    }

    @Override
    protected <T> TypeSerializer<T> createSerializer(Class<T> type) {
        return new KryoSerializer(type, this.ec);
    }

    @Test
    public void testForwardEOFExceptionWhileSerializing() {
        try {
            char[] charData = new char[40000];
            Random rnd = new Random();
            for (int i = 0; i < charData.length; ++i) {
                charData[i] = (char)rnd.nextInt(10000);
            }
            String str = new String(charData);
            TestDataOutputSerializer target = new TestDataOutputSerializer(10000, 30000);
            KryoSerializer serializer = new KryoSerializer(String.class, new ExecutionConfig());
            try {
                serializer.serialize((Object)str, (DataOutputView)target);
                Assert.fail((String)"should throw a java.io.EOFException");
            }
            catch (EOFException i) {
            }
            catch (Exception e) {
                Assert.fail((String)("throws wrong exception: should throw a java.io.EOFException, has thrown a " + e.getClass().getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testForwardEOFExceptionWhileDeserializing() {
        try {
            int numElements = 100;
            TestDataOutputSerializer target = new TestDataOutputSerializer(5 * numElements, 5 * numElements);
            KryoSerializer serializer = new KryoSerializer(Integer.class, new ExecutionConfig());
            for (int i = 0; i < numElements; ++i) {
                serializer.serialize((Object)i, (DataOutputView)target);
            }
            ComparatorTestBase.TestInputView source = new ComparatorTestBase.TestInputView(target.copyByteBuffer());
            for (int i = 0; i < numElements; ++i) {
                int value = (Integer)serializer.deserialize((DataInputView)source);
                Assert.assertEquals((long)i, (long)value);
            }
            try {
                serializer.deserialize((DataInputView)source);
                Assert.fail((String)"should throw a java.io.EOFException");
            }
            catch (EOFException i) {
            }
            catch (Exception e) {
                Assert.fail((String)("throws wrong exception: should throw a java.io.EOFException, has thrown a " + e.getClass().getName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void validateReferenceMappingEnabled() {
        KryoSerializer serializer = new KryoSerializer(String.class, new ExecutionConfig());
        Kryo kryo = serializer.getKryo();
        Assert.assertTrue((boolean)kryo.getReferences());
    }
}

