/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class ConfigurationUtilsTest
extends TestLogger {
    @Test
    public void testPropertiesToConfiguration() {
        Properties properties = new Properties();
        int entries = 10;
        for (int i = 0; i < 10; ++i) {
            properties.setProperty("key" + i, "value" + i);
        }
        Configuration configuration = ConfigurationUtils.createConfiguration((Properties)properties);
        for (String key : properties.stringPropertyNames()) {
            Assertions.assertThat((String)configuration.getString(key, "")).isEqualTo(properties.getProperty(key));
        }
        Assertions.assertThat((Map)configuration.toMap()).hasSize(properties.size());
    }

    @Test
    public void testHideSensitiveValues() {
        HashMap<String, String> keyValuePairs = new HashMap<String, String>();
        keyValuePairs.put("foobar", "barfoo");
        String secretKey1 = "secret.key";
        keyValuePairs.put("secret.key", "12345");
        String secretKey2 = "my.password";
        keyValuePairs.put("my.password", "12345");
        HashMap<String, String> expectedKeyValuePairs = new HashMap<String, String>(keyValuePairs);
        for (String secretKey : Arrays.asList("secret.key", "my.password")) {
            expectedKeyValuePairs.put(secretKey, "******");
        }
        Map hiddenSensitiveValues = ConfigurationUtils.hideSensitiveValues(keyValuePairs);
        Assertions.assertThat((Map)hiddenSensitiveValues).isEqualTo(expectedKeyValuePairs);
    }

    @Test
    public void testGetPrefixedKeyValuePairs() {
        String prefix = "test.prefix.";
        HashMap<String, String> expectedKeyValuePairs = new HashMap<String, String>(){
            {
                this.put("k1", "v1");
                this.put("k2", "v2");
            }
        };
        Configuration configuration = new Configuration();
        expectedKeyValuePairs.forEach((k, v) -> configuration.setString("test.prefix." + k, v));
        Map resultKeyValuePairs = ConfigurationUtils.getPrefixedKeyValuePairs((String)"test.prefix.", (Configuration)configuration);
        Assertions.assertThat((Map)resultKeyValuePairs).isEqualTo((Object)expectedKeyValuePairs);
    }

    @Test
    public void testConvertToString() {
        Assert.assertEquals((Object)"Simple String", (Object)ConfigurationUtils.convertToString((Object)"Simple String"));
        Assert.assertEquals((Object)"0 ms", (Object)ConfigurationUtils.convertToString((Object)Duration.ZERO));
        Assert.assertEquals((Object)"123 ms", (Object)ConfigurationUtils.convertToString((Object)Duration.ofMillis(123L)));
        Assert.assertEquals((Object)"1234 s", (Object)ConfigurationUtils.convertToString((Object)Duration.ofMillis(1234000L)));
        Assert.assertEquals((Object)"25 h", (Object)ConfigurationUtils.convertToString((Object)Duration.ofHours(25L)));
        ArrayList<Object> listElements = new ArrayList<Object>();
        listElements.add("Test;String");
        listElements.add(Duration.ZERO);
        listElements.add(42);
        Assert.assertEquals((Object)"'Test;String';0 ms;42", (Object)ConfigurationUtils.convertToString(listElements));
        HashMap<Object, Object> mapElements = new HashMap<Object, Object>();
        mapElements.put("A:,B", "C:,D");
        mapElements.put(10, 20);
        Assert.assertEquals((Object)"'''A:,B'':''C:,D''',10:20", (Object)ConfigurationUtils.convertToString(mapElements));
    }

    @Test
    public void testRandomTempDirectorySelection() {
        Configuration configuration = new Configuration();
        StringBuilder tempDirectories = new StringBuilder();
        int numberTempDirectories = 20;
        for (int i = 0; i < 20; ++i) {
            tempDirectories.append(UUID.randomUUID()).append(',');
        }
        configuration.set(CoreOptions.TMP_DIRS, (Object)tempDirectories.toString());
        Set allTempDirectories = Arrays.stream(ConfigurationUtils.parseTempDirectories((Configuration)configuration)).map(File::new).collect(Collectors.toSet());
        HashSet<File> drawnTempDirectories = new HashSet<File>();
        int numberDraws = 100;
        for (int i = 0; i < 100; ++i) {
            drawnTempDirectories.add(ConfigurationUtils.getRandomTempDirectory((Configuration)configuration));
        }
        Assertions.assertThat(drawnTempDirectories).hasSizeGreaterThan(1);
        Assertions.assertThat(drawnTempDirectories).isSubsetOf(allTempDirectories);
    }
}

