/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.net.URI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.LimitedConnectionsFileSystem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LimitedConnectionsConfigurationTest {
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfiguration() throws Exception {
        String fsScheme = "test";
        FileSystem schemeFs = FileSystem.get((URI)URI.create("test:///a/b/c"));
        FileSystem localFs = FileSystem.get((URI)this.tempDir.newFile().toURI());
        Assert.assertFalse((boolean)(schemeFs instanceof LimitedConnectionsFileSystem));
        Assert.assertFalse((boolean)(localFs instanceof LimitedConnectionsFileSystem));
        Configuration config = new Configuration();
        config.setInteger("fs.test.limit.total", 42);
        config.setInteger("fs.test.limit.input", 11);
        config.setInteger("fs.test.limit.output", 40);
        config.setInteger("fs.test.limit.timeout", 12345);
        config.setInteger("fs.test.limit.stream-timeout", 98765);
        try {
            FileSystem.initialize((Configuration)config);
            schemeFs = FileSystem.get((URI)URI.create("test:///a/b/c"));
            localFs = FileSystem.get((URI)this.tempDir.newFile().toURI());
            Assert.assertTrue((boolean)(schemeFs instanceof LimitedConnectionsFileSystem));
            Assert.assertFalse((boolean)(localFs instanceof LimitedConnectionsFileSystem));
            LimitedConnectionsFileSystem limitedFs = (LimitedConnectionsFileSystem)schemeFs;
            Assert.assertEquals((long)42L, (long)limitedFs.getMaxNumOpenStreamsTotal());
            Assert.assertEquals((long)11L, (long)limitedFs.getMaxNumOpenInputStreams());
            Assert.assertEquals((long)40L, (long)limitedFs.getMaxNumOpenOutputStreams());
            Assert.assertEquals((long)12345L, (long)limitedFs.getStreamOpenTimeout());
            Assert.assertEquals((long)98765L, (long)limitedFs.getStreamInactivityTimeout());
        }
        finally {
            FileSystem.initialize((Configuration)new Configuration());
        }
    }

    @Test
    public void testConnectionLimitingSettings() {
        String scheme = "testscheme";
        Assert.assertNull((Object)LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)new Configuration(), (String)"testscheme"));
        Configuration conf = new Configuration();
        conf.setInteger(CoreOptions.fileSystemConnectionLimit((String)"testscheme"), 10);
        LimitedConnectionsFileSystem.ConnectionLimitingSettings settings = LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)conf, (String)"testscheme");
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((long)10L, (long)settings.limitTotal);
        Assert.assertEquals((long)0L, (long)settings.limitInput);
        Assert.assertEquals((long)0L, (long)settings.limitOutput);
        conf = new Configuration();
        conf.setInteger(CoreOptions.fileSystemConnectionLimitIn((String)"testscheme"), 10);
        settings = LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)conf, (String)"testscheme");
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((long)0L, (long)settings.limitTotal);
        Assert.assertEquals((long)10L, (long)settings.limitInput);
        Assert.assertEquals((long)0L, (long)settings.limitOutput);
        conf = new Configuration();
        conf.setInteger(CoreOptions.fileSystemConnectionLimitOut((String)"testscheme"), 10);
        settings = LimitedConnectionsFileSystem.ConnectionLimitingSettings.fromConfig((Configuration)conf, (String)"testscheme");
        Assert.assertNotNull((Object)settings);
        Assert.assertEquals((long)0L, (long)settings.limitTotal);
        Assert.assertEquals((long)0L, (long)settings.limitInput);
        Assert.assertEquals((long)10L, (long)settings.limitOutput);
    }
}

