/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.flink.core.fs.RefCountedFile;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RefCountedFileTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void releaseToZeroRefCounterShouldDeleteTheFile() throws IOException {
        File newFile = new File(this.temporaryFolder.getRoot(), ".tmp_" + UUID.randomUUID());
        Preconditions.checkState((boolean)newFile.createNewFile());
        RefCountedFile fileUnderTest = new RefCountedFile(newFile);
        this.verifyTheFileIsStillThere();
        fileUnderTest.release();
        try (Stream<Path> files = Files.list(this.temporaryFolder.getRoot().toPath());){
            Assert.assertEquals((long)0L, (long)files.count());
        }
    }

    @Test
    public void retainsShouldRequirePlusOneReleasesToDeleteTheFile() throws IOException {
        File newFile = new File(this.temporaryFolder.getRoot(), ".tmp_" + UUID.randomUUID());
        Preconditions.checkState((boolean)newFile.createNewFile());
        RefCountedFile fileUnderTest = new RefCountedFile(newFile);
        this.verifyTheFileIsStillThere();
        fileUnderTest.retain();
        fileUnderTest.retain();
        Assert.assertEquals((long)3L, (long)fileUnderTest.getReferenceCounter());
        fileUnderTest.release();
        Assert.assertEquals((long)2L, (long)fileUnderTest.getReferenceCounter());
        this.verifyTheFileIsStillThere();
        fileUnderTest.release();
        Assert.assertEquals((long)1L, (long)fileUnderTest.getReferenceCounter());
        this.verifyTheFileIsStillThere();
        fileUnderTest.release();
        try (Stream<Path> files = Files.list(this.temporaryFolder.getRoot().toPath());){
            Assert.assertEquals((long)0L, (long)files.count());
        }
    }

    private void verifyTheFileIsStillThere() throws IOException {
        try (Stream<Path> files = Files.list(this.temporaryFolder.getRoot().toPath());){
            Assert.assertEquals((long)1L, (long)files.count());
        }
    }

    private static byte[] bytesOf(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }
}

