/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.ThrowingConsumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalFileSystemTest
extends TestLogger {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testLocalFilesystem() throws Exception {
        File tempdir = new File(this.temporaryFolder.getRoot(), UUID.randomUUID().toString());
        File testfile1 = new File(tempdir, UUID.randomUUID().toString());
        File testfile2 = new File(tempdir, UUID.randomUUID().toString());
        Path pathtotestfile1 = new Path(testfile1.toURI().getPath());
        Path pathtotestfile2 = new Path(testfile2.toURI().getPath());
        LocalFileSystem lfs = new LocalFileSystem();
        Path pathtotmpdir = new Path(tempdir.toURI().getPath());
        Assert.assertFalse((boolean)lfs.exists(pathtotmpdir));
        Assert.assertTrue((boolean)tempdir.mkdirs());
        Assert.assertTrue((boolean)lfs.exists(pathtotmpdir));
        FileStatus localstatus1 = lfs.getFileStatus(pathtotmpdir);
        Assert.assertTrue((boolean)localstatus1.isDir());
        FileStatus[] statusforfiles = lfs.listStatus(pathtotmpdir);
        Assert.assertTrue((statusforfiles.length == 0 ? 1 : 0) != 0);
        lfs.delete(pathtotmpdir, true);
        Assert.assertFalse((boolean)lfs.exists(pathtotmpdir));
        Assert.assertFalse((boolean)tempdir.exists());
        lfs.mkdirs(pathtotmpdir);
        Assert.assertTrue((boolean)tempdir.exists());
        FSDataOutputStream lfsoutput1 = lfs.create(pathtotestfile1, FileSystem.WriteMode.NO_OVERWRITE);
        Assert.assertTrue((boolean)testfile2.createNewFile());
        Assert.assertTrue((boolean)testfile1.exists());
        Assert.assertTrue((boolean)lfs.exists(pathtotestfile2));
        byte[] testbytes = new byte[]{1, 2, 3, 4, 5};
        lfsoutput1.write(testbytes);
        lfsoutput1.close();
        Assert.assertEquals((long)testfile1.length(), (long)5L);
        byte[] testbytestest = new byte[5];
        try (FileInputStream fisfile1 = new FileInputStream(testfile1);){
            Assert.assertEquals((long)testbytestest.length, (long)fisfile1.read(testbytestest));
        }
        Assert.assertArrayEquals((byte[])testbytes, (byte[])testbytestest);
        Assert.assertEquals((long)lfs.getFileStatus(pathtotestfile1).getLen(), (long)testfile1.length());
        Assert.assertEquals((long)lfs.listStatus(pathtotestfile1)[0].getLen(), (long)testfile1.length());
        FileOutputStream fosfile2 = new FileOutputStream(testfile2);
        fosfile2.write(testbytes);
        fosfile2.close();
        testbytestest = new byte[5];
        FSDataInputStream lfsinput2 = lfs.open(pathtotestfile2);
        Assert.assertEquals((long)lfsinput2.read(testbytestest), (long)5L);
        lfsinput2.close();
        Assert.assertTrue((boolean)Arrays.equals(testbytes, testbytestest));
        Assert.assertEquals((long)lfs.listStatus(pathtotmpdir).length, (long)2L);
        Assert.assertEquals((long)lfs.getFileBlockLocations(lfs.getFileStatus(pathtotestfile1), 0L, 0L).length, (long)1L);
        Assert.assertTrue((boolean)lfs.delete(pathtotestfile1, false));
        Assert.assertTrue((boolean)lfs.delete(pathtotmpdir, true));
        Assert.assertTrue((!tempdir.exists() ? 1 : 0) != 0);
    }

    @Test
    public void testRenamePath() throws IOException {
        File rootDirectory = this.temporaryFolder.newFolder();
        File srcDirectory = new File(new File(rootDirectory, "src"), "B");
        Assert.assertTrue((boolean)srcDirectory.mkdirs());
        File srcFile = new File(srcDirectory, "test.csv");
        Assert.assertTrue((boolean)srcFile.createNewFile());
        File destDirectory = new File(new File(rootDirectory, "dst"), "B");
        File destFile = new File(destDirectory, "test.csv");
        Path srcDirPath = new Path(srcDirectory.toURI());
        Path srcFilePath = new Path(srcFile.toURI());
        Path destDirPath = new Path(destDirectory.toURI());
        Path destFilePath = new Path(destFile.toURI());
        FileSystem fs = FileSystem.getLocalFileSystem();
        Assert.assertTrue((boolean)fs.exists(srcDirPath));
        Assert.assertFalse((boolean)fs.exists(destDirPath));
        Assert.assertTrue((boolean)fs.rename(srcDirPath, destDirPath));
        Assert.assertTrue((boolean)fs.exists(destFilePath));
        Assert.assertFalse((boolean)fs.exists(srcDirPath));
        Assert.assertTrue((boolean)srcDirectory.mkdirs());
        Assert.assertTrue((boolean)srcFile.createNewFile());
        Assert.assertTrue((boolean)fs.rename(srcFilePath, destFilePath));
        Assert.assertFalse((boolean)fs.exists(srcFilePath));
        Assert.assertTrue((boolean)fs.exists(srcDirPath));
        Assert.assertTrue((boolean)fs.exists(destFilePath));
    }

    @Test
    public void testRenameNonExistingFile() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        File srcFile = new File(this.temporaryFolder.newFolder(), "someFile.txt");
        File destFile = new File(this.temporaryFolder.newFolder(), "target");
        Path srcFilePath = new Path(srcFile.toURI());
        Path destFilePath = new Path(destFile.toURI());
        Assert.assertFalse((boolean)fs.rename(srcFilePath, destFilePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameFileWithNoAccess() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        File srcFile = this.temporaryFolder.newFile("someFile.txt");
        File destFile = new File(this.temporaryFolder.newFolder(), "target");
        Assume.assumeTrue((boolean)srcFile.getParentFile().setWritable(false, false));
        Assume.assumeTrue((boolean)srcFile.setWritable(false, false));
        try {
            Path srcFilePath = new Path(srcFile.toURI());
            Path destFilePath = new Path(destFile.toURI());
            Assert.assertFalse((boolean)fs.rename(srcFilePath, destFilePath));
        }
        finally {
            srcFile.getParentFile().setWritable(true, false);
            srcFile.setWritable(true, false);
        }
    }

    @Test
    public void testRenameToNonEmptyTargetDir() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        File srcFolder = this.temporaryFolder.newFolder();
        File srcFile = new File(srcFolder, "someFile.txt");
        Assert.assertTrue((boolean)srcFile.createNewFile());
        File dstFolder = this.temporaryFolder.newFolder();
        File dstFile = new File(dstFolder, "target");
        Assert.assertTrue((boolean)dstFile.createNewFile());
        Assert.assertFalse((boolean)fs.rename(new Path(srcFolder.toURI()), new Path(dstFolder.toURI())));
        Assert.assertTrue((boolean)dstFile.delete());
        Assert.assertTrue((boolean)fs.rename(new Path(srcFolder.toURI()), new Path(dstFolder.toURI())));
        Assert.assertTrue((boolean)new File(dstFolder, srcFile.getName()).exists());
    }

    @Test
    public void testKind() {
        FileSystem fs = FileSystem.getLocalFileSystem();
        Assert.assertEquals((Object)FileSystemKind.FILE_SYSTEM, (Object)fs.getKind());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentMkdirs() throws Exception {
        FileSystem fs = FileSystem.getLocalFileSystem();
        File root = this.temporaryFolder.getRoot();
        int directoryDepth = 10;
        int concurrentOperations = 10;
        Collection<File> targetDirectories = this.createTargetDirectories(root, 10, 10);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        CyclicBarrier cyclicBarrier = new CyclicBarrier(10);
        try {
            ArrayList<CompletableFuture<Void>> mkdirsFutures = new ArrayList<CompletableFuture<Void>>(10);
            for (File targetDirectory : targetDirectories) {
                CompletableFuture<Void> mkdirsFuture = CompletableFuture.runAsync(() -> {
                    try {
                        cyclicBarrier.await();
                        Assert.assertThat((Object)fs.mkdirs(Path.fromLocalFile((File)targetDirectory)), (Matcher)Matchers.is((Object)true));
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }, executor);
                mkdirsFutures.add(mkdirsFuture);
            }
            CompletableFuture<Void> allFutures = CompletableFuture.allOf(mkdirsFutures.toArray(new CompletableFuture[10]));
            allFutures.get();
            long timeout = 10000L;
        }
        catch (Throwable throwable) {
            long timeout = 10000L;
            ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)10000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreatingFileInCurrentDirectoryWithRelativePath() throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        Path filePath = new Path("local_fs_test_" + RandomStringUtils.randomAlphanumeric((int)16));
        try {
            FSDataOutputStream outputStream = fs.create(filePath, FileSystem.WriteMode.OVERWRITE);
            Throwable throwable = null;
            if (outputStream != null) {
                if (throwable != null) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    outputStream.close();
                }
            }
        }
        finally {
            for (int i = 0; i < 10 && fs.exists(filePath); ++i) {
                fs.delete(filePath, true);
            }
        }
    }

    @Test(expected=ClosedChannelException.class)
    public void testFlushMethodFailsOnClosedOutputStream() throws IOException {
        this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)FSDataOutputStream::flush));
    }

    @Test(expected=ClosedChannelException.class)
    public void testWriteIntegerMethodFailsOnClosedOutputStream() throws IOException {
        this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(0)));
    }

    @Test(expected=ClosedChannelException.class)
    public void testWriteBytesMethodFailsOnClosedOutputStream() throws IOException {
        this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(new byte[0])));
    }

    @Test(expected=ClosedChannelException.class)
    public void testWriteBytesSubArrayMethodFailsOnClosedOutputStream() throws IOException {
        this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)os -> os.write(new byte[0], 0, 0)));
    }

    @Test(expected=ClosedChannelException.class)
    public void testGetPosMethodFailsOnClosedOutputStream() throws IOException {
        this.testMethodCallFailureOnClosedStream((ThrowingConsumer<FSDataOutputStream, IOException>)((ThrowingConsumer)FSDataOutputStream::getPos));
    }

    private void testMethodCallFailureOnClosedStream(ThrowingConsumer<FSDataOutputStream, IOException> callback) throws IOException {
        FileSystem fs = FileSystem.getLocalFileSystem();
        FSDataOutputStream outputStream = fs.create(new Path(this.temporaryFolder.getRoot().toString(), "close_fs_test_" + UUID.randomUUID()), FileSystem.WriteMode.OVERWRITE);
        outputStream.close();
        callback.accept((Object)outputStream);
    }

    private Collection<File> createTargetDirectories(File root, int directoryDepth, int numberDirectories) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < directoryDepth; ++i) {
            stringBuilder.append('/').append(i);
        }
        ArrayList<File> targetDirectories = new ArrayList<File>(numberDirectories);
        for (int i = 0; i < numberDirectories; ++i) {
            targetDirectories.add(new File(root, stringBuilder.toString() + '/' + i));
        }
        return targetDirectories;
    }
}

