/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializerTypeSerializerProxy;
import org.apache.flink.util.function.SerializableSupplier;
import org.junit.Assert;

class SimpleVersionedSerializerTypeSerializerProxyTest
extends SerializerTestBase<String> {
    SimpleVersionedSerializerTypeSerializerProxyTest() {
    }

    @Override
    protected TypeSerializer<String> createSerializer() {
        return new SimpleVersionedSerializerTypeSerializerProxy((SerializableSupplier & Serializable)() -> new TestStringSerializer());
    }

    @Override
    protected int getLength() {
        return -1;
    }

    @Override
    protected Class<String> getTypeClass() {
        return String.class;
    }

    protected String[] getTestData() {
        return new String[]{"a", "", "bcd", "jbmbmner8 jhk hj \n \t \u00fc\u00e4\u00df\u00df@\u00b5", "", "non-empty"};
    }

    @Override
    public void testInstantiate() {
    }

    @Override
    public void testConfigSnapshotInstantiation() {
    }

    @Override
    public void testSnapshotConfigurationAndReconfigure() {
    }

    private static final class TestStringSerializer
    implements SimpleVersionedSerializer<String> {
        private static final int VERSION = 1;

        private TestStringSerializer() {
        }

        public int getVersion() {
            return 1;
        }

        public byte[] serialize(String str) {
            return str.getBytes(StandardCharsets.UTF_8);
        }

        public String deserialize(int version, byte[] serialized) {
            Assert.assertEquals((long)1L, (long)version);
            return new String(serialized, StandardCharsets.UTF_8);
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof TestStringSerializer;
        }
    }
}

