/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.core.io.VersionMismatchException;
import org.apache.flink.core.io.VersionedIOReadableWritable;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.junit.Assert;
import org.junit.Test;

public class VersionedIOWriteableTest {
    @Test
    public void testReadSameVersion() throws Exception {
        byte[] serialized;
        String payload = "test";
        TestWriteable testWriteable = new TestWriteable(1, payload);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            testWriteable.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        testWriteable = new TestWriteable(1);
        var5_4 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            testWriteable.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        Assert.assertEquals((Object)payload, (Object)testWriteable.getData());
    }

    @Test
    public void testReadCompatibleVersion() throws Exception {
        byte[] serialized;
        String payload = "test";
        TestWriteable testWriteable = new TestWriteable(1, payload);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            testWriteable.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        testWriteable = new TestWriteable(2){

            public int[] getCompatibleVersions() {
                return new int[]{1, 2};
            }
        };
        var5_4 = null;
        try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
            testWriteable.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        Assert.assertEquals((Object)payload, (Object)testWriteable.getData());
    }

    @Test
    public void testReadMismatchVersion() throws Exception {
        byte[] serialized;
        String payload = "test";
        TestWriteable testWriteable = new TestWriteable(1, payload);
        try (ByteArrayOutputStreamWithPos out = new ByteArrayOutputStreamWithPos();){
            testWriteable.write((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        testWriteable = new TestWriteable(2);
        try {
            var5_5 = null;
            try (ByteArrayInputStreamWithPos in = new ByteArrayInputStreamWithPos(serialized);){
                testWriteable.read((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
                Assert.fail((String)"Version mismatch expected.");
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
        }
        catch (VersionMismatchException versionMismatchException) {
            // empty catch block
        }
        Assert.assertEquals(null, (Object)testWriteable.getData());
    }

    static class TestWriteable
    extends VersionedIOReadableWritable {
        private final int version;
        private String data;

        public TestWriteable(int version) {
            this(version, null);
        }

        public TestWriteable(int version, String data) {
            this.version = version;
            this.data = data;
        }

        public int getVersion() {
            return this.version;
        }

        public void write(DataOutputView out) throws IOException {
            super.write(out);
            out.writeUTF(this.data);
        }

        public void read(DataInputView in) throws IOException {
            super.read(in);
            this.data = in.readUTF();
        }

        public String getData() {
            return this.data;
        }
    }
}

