/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.testutils.serialization.types;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.testutils.serialization.types.SerializationTestType;

public class DoubleType
implements SerializationTestType {
    private double value;

    public DoubleType() {
        this.value = 0.0;
    }

    private DoubleType(double value) {
        this.value = value;
    }

    @Override
    public DoubleType getRandom(Random rnd) {
        return new DoubleType(rnd.nextDouble());
    }

    @Override
    public int length() {
        return 8;
    }

    public void write(DataOutputView out) throws IOException {
        out.writeDouble(this.value);
    }

    public void read(DataInputView in) throws IOException {
        this.value = in.readDouble();
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleType) {
            DoubleType other = (DoubleType)obj;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other.value);
        }
        return false;
    }
}

