/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import org.apache.flink.types.BooleanValue;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.CharValue;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.DoubleValue;
import org.apache.flink.types.FloatValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.apache.flink.types.NullValue;
import org.apache.flink.types.ShortValue;
import org.apache.flink.types.StringValue;
import org.junit.Assert;
import org.junit.Test;

public class CopyableValueTest {
    @Test
    public void testCopy() {
        CopyableValue[] value_types;
        for (CopyableValue type : value_types = new CopyableValue[]{new BooleanValue(true), new ByteValue(42), new CharValue('q'), new DoubleValue(Math.PI), new FloatValue((float)Math.PI), new IntValue(42), new LongValue(42L), new NullValue(), new ShortValue(42), new StringValue((CharSequence)"QED")}) {
            Assert.assertEquals((Object)type, (Object)type.copy());
        }
    }

    @Test
    public void testCopyTo() {
        BooleanValue boolean_from = new BooleanValue(true);
        BooleanValue boolean_to = new BooleanValue(false);
        boolean_from.copyTo(boolean_to);
        Assert.assertEquals((Object)boolean_from, (Object)boolean_to);
        ByteValue byte_from = new ByteValue(3);
        ByteValue byte_to = new ByteValue(7);
        byte_from.copyTo(byte_to);
        Assert.assertEquals((Object)byte_from, (Object)byte_to);
        CharValue char_from = new CharValue('\u03b1');
        CharValue char_to = new CharValue('\u03c9');
        char_from.copyTo(char_to);
        Assert.assertEquals((Object)char_from, (Object)char_to);
        DoubleValue double_from = new DoubleValue(Math.E);
        DoubleValue double_to = new DoubleValue(0.0);
        double_from.copyTo(double_to);
        Assert.assertEquals((Object)double_from, (Object)double_to);
        FloatValue float_from = new FloatValue((float)Math.E);
        FloatValue float_to = new FloatValue(1.4142135f);
        float_from.copyTo(float_to);
        Assert.assertEquals((Object)float_from, (Object)float_to);
        IntValue int_from = new IntValue(8191);
        IntValue int_to = new IntValue(131071);
        int_from.copyTo(int_to);
        Assert.assertEquals((Object)int_from, (Object)int_to);
        LongValue long_from = new LongValue(524287L);
        LongValue long_to = new LongValue(Integer.MAX_VALUE);
        long_from.copyTo(long_to);
        Assert.assertEquals((Object)long_from, (Object)long_to);
        NullValue null_from = new NullValue();
        NullValue null_to = new NullValue();
        null_from.copyTo(null_to);
        Assert.assertEquals((Object)null_from, (Object)null_to);
        ShortValue short_from = new ShortValue(31);
        ShortValue short_to = new ShortValue(127);
        short_from.copyTo(short_to);
        Assert.assertEquals((Object)short_from, (Object)short_to);
        StringValue string_from = new StringValue((CharSequence)"2305843009213693951");
        StringValue string_to = new StringValue((CharSequence)"618970019642690137449562111");
        string_from.copyTo(string_to);
        Assert.assertEquals((Object)string_from, (Object)string_to);
    }
}

