/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.types.RowUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class RowTest {
    @Test
    public void testRowNamed() {
        Row row = Row.withNames((RowKind)RowKind.DELETE);
        row.setField("a", (Object)42);
        row.setField("b", (Object)true);
        row.setField("c", null);
        Assert.assertThat((Object)row.getFieldNames(false), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"a", "b", "c"}));
        Assert.assertThat((Object)row.getArity(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)row.getKind(), (Matcher)Matchers.equalTo((Object)RowKind.DELETE));
        Assert.assertThat((Object)row.getField("a"), (Matcher)Matchers.equalTo((Object)42));
        Assert.assertThat((Object)row.getField("b"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)row.getField("c"), (Matcher)Matchers.equalTo(null));
        Assert.assertThat((Object)row.toString(), (Matcher)Matchers.equalTo((Object)"-D{a=42, b=true, c=null}"));
        row.setField("a", (Object)13);
        row.setField("c", (Object)"Hello");
        Assert.assertThat((Object)row.getField("a"), (Matcher)Matchers.equalTo((Object)13));
        Assert.assertThat((Object)row.getField("b"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)row.getField("c"), (Matcher)Matchers.equalTo((Object)"Hello"));
        Row otherRow1 = Row.withNames((RowKind)RowKind.DELETE);
        otherRow1.setField("a", (Object)13);
        otherRow1.setField("b", (Object)true);
        otherRow1.setField("c", (Object)"Hello");
        Assert.assertThat((Object)row.hashCode(), (Matcher)Matchers.equalTo((Object)otherRow1.hashCode()));
        Assert.assertThat((Object)row, (Matcher)Matchers.equalTo((Object)otherRow1));
        Row otherRow2 = Row.withNames((RowKind)RowKind.DELETE);
        otherRow2.setField("a", (Object)13);
        otherRow2.setField("b", (Object)false);
        otherRow2.setField("c", (Object)"Hello");
        Assert.assertThat((Object)row.hashCode(), (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)otherRow2.hashCode())));
        Assert.assertThat((Object)row, (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)otherRow2)));
        row.clear();
        Assert.assertThat((Object)row.getArity(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)row.getFieldNames(false), (Matcher)Matchers.empty());
        Assert.assertThat((Object)row.toString(), (Matcher)Matchers.equalTo((Object)"-D{}"));
        try {
            row.setField(0, (Object)13);
            Assert.fail();
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"not supported in name-based field mode")));
        }
        try {
            Assert.assertNull((Object)row.getField(0));
            Assert.fail();
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"not supported in name-based field mode")));
        }
    }

    @Test
    public void testRowPositioned() {
        Row row = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        row.setField(0, (Object)42);
        row.setField(1, (Object)true);
        row.setField(2, null);
        Assert.assertThat((Object)row.getFieldNames(false), (Matcher)Matchers.equalTo(null));
        Assert.assertThat((Object)row.getArity(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)row.getKind(), (Matcher)Matchers.equalTo((Object)RowKind.DELETE));
        Assert.assertThat((Object)row.getField(0), (Matcher)Matchers.equalTo((Object)42));
        Assert.assertThat((Object)row.getField(1), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)row.getField(2), (Matcher)Matchers.equalTo(null));
        Assert.assertThat((Object)row.toString(), (Matcher)Matchers.equalTo((Object)"-D[42, true, null]"));
        row.setField(0, (Object)13);
        row.setField(2, (Object)"Hello");
        Assert.assertThat((Object)row.getField(0), (Matcher)Matchers.equalTo((Object)13));
        Assert.assertThat((Object)row.getField(1), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)row.getField(2), (Matcher)Matchers.equalTo((Object)"Hello"));
        Row otherRow1 = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        otherRow1.setField(0, (Object)13);
        otherRow1.setField(1, (Object)true);
        otherRow1.setField(2, (Object)"Hello");
        Assert.assertThat((Object)row.hashCode(), (Matcher)Matchers.equalTo((Object)otherRow1.hashCode()));
        Assert.assertThat((Object)row, (Matcher)Matchers.equalTo((Object)otherRow1));
        Row otherRow2 = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        otherRow2.setField(0, (Object)13);
        otherRow2.setField(1, (Object)false);
        otherRow2.setField(2, (Object)"Hello");
        Assert.assertThat((Object)row.hashCode(), (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)otherRow2.hashCode())));
        Assert.assertThat((Object)row, (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)otherRow2)));
        row.clear();
        Assert.assertThat((Object)row.getArity(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)row.getFieldNames(false), (Matcher)Matchers.equalTo(null));
        Assert.assertThat((Object)row.toString(), (Matcher)Matchers.equalTo((Object)"-D[null, null, null]"));
        try {
            row.setField("a", (Object)13);
            Assert.fail();
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"not supported in position-based field mode")));
        }
        try {
            Assert.assertNull((Object)row.getField("a"));
            Assert.fail();
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"not supported in position-based field mode")));
        }
    }

    @Test
    public void testRowNamedPositioned() {
        LinkedHashMap<String, Integer> positionByName = new LinkedHashMap<String, Integer>();
        positionByName.put("a", 0);
        positionByName.put("b", 1);
        positionByName.put("c", 2);
        Row row = RowUtils.createRowWithNamedPositions((RowKind)RowKind.DELETE, (Object[])new Object[3], positionByName);
        row.setField(0, (Object)42);
        row.setField("b", (Object)true);
        row.setField(2, null);
        Assert.assertThat((Object)row.getFieldNames(false), (Matcher)Matchers.equalTo(null));
        Assert.assertThat((Object)row.getFieldNames(true), (Matcher)Matchers.contains((Object[])new String[]{"a", "b", "c"}));
        Assert.assertThat((Object)row.getArity(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)row.getKind(), (Matcher)Matchers.equalTo((Object)RowKind.DELETE));
        Assert.assertThat((Object)row.getField(0), (Matcher)Matchers.equalTo((Object)42));
        Assert.assertThat((Object)row.getField(1), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)row.getField("c"), (Matcher)Matchers.equalTo(null));
        Assert.assertThat((Object)row.toString(), (Matcher)Matchers.equalTo((Object)"-D[42, true, null]"));
        row.setField("a", (Object)13);
        row.setField(2, (Object)"Hello");
        Assert.assertThat((Object)row.getField(0), (Matcher)Matchers.equalTo((Object)13));
        Assert.assertThat((Object)row.getField("b"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)row.getField(2), (Matcher)Matchers.equalTo((Object)"Hello"));
        Row otherRow1 = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        otherRow1.setField(0, (Object)13);
        otherRow1.setField(1, (Object)true);
        otherRow1.setField(2, (Object)"Hello");
        Assert.assertThat((Object)row.hashCode(), (Matcher)Matchers.equalTo((Object)otherRow1.hashCode()));
        Assert.assertThat((Object)row, (Matcher)Matchers.equalTo((Object)otherRow1));
        Row otherRow2 = Row.withPositions((RowKind)RowKind.DELETE, (int)3);
        otherRow2.setField(0, (Object)13);
        otherRow2.setField(1, (Object)false);
        otherRow2.setField(2, (Object)"Hello");
        Assert.assertThat((Object)row.hashCode(), (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)otherRow2.hashCode())));
        Assert.assertThat((Object)row, (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)otherRow2)));
        row.clear();
        Assert.assertThat((Object)row.getArity(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat((Object)row.getFieldNames(true), (Matcher)Matchers.contains((Object[])new String[]{"a", "b", "c"}));
        Assert.assertThat((Object)row.toString(), (Matcher)Matchers.equalTo((Object)"-D[null, null, null]"));
        try {
            row.setField("DOES_NOT_EXIST", (Object)13);
            Assert.fail();
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Unknown field name 'DOES_NOT_EXIST'")));
        }
        try {
            Assert.assertNull((Object)row.getField("DOES_NOT_EXIST"));
            Assert.fail();
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Unknown field name 'DOES_NOT_EXIST'")));
        }
    }

    @Test
    public void testRowOf() {
        Row row1 = Row.of((Object[])new Object[]{1, "hello", null, Tuple2.of((Object)2L, (Object)"hi"), true});
        Row row2 = Row.withPositions((int)5);
        row2.setField(0, (Object)1);
        row2.setField(1, (Object)"hello");
        row2.setField(2, null);
        row2.setField(3, (Object)new Tuple2((Object)2L, (Object)"hi"));
        row2.setField(4, (Object)true);
        Assert.assertEquals((Object)row1, (Object)row2);
    }

    @Test
    public void testRowCopyPositioned() {
        Row row = Row.withPositions((int)5);
        row.setField(0, (Object)1);
        row.setField(1, (Object)"hello");
        row.setField(2, null);
        row.setField(3, (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField(4, (Object)"hello world");
        Row copy = Row.copy((Row)row);
        Assert.assertEquals((Object)row, (Object)copy);
        Assert.assertNotSame((Object)row, (Object)copy);
    }

    @Test
    public void testRowCopyNamed() {
        Row row = Row.withNames();
        row.setField("a", (Object)1);
        row.setField("b", (Object)"hello");
        row.setField("c", null);
        row.setField("d", (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField("e", (Object)"hello world");
        Row copy = Row.copy((Row)row);
        Assert.assertEquals((Object)row, (Object)copy);
        Assert.assertNotSame((Object)row, (Object)copy);
    }

    @Test
    public void testRowProjectPositioned() {
        Row row = Row.withPositions((int)5);
        row.setField(0, (Object)1);
        row.setField(1, (Object)"hello");
        row.setField(2, null);
        row.setField(3, (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField(4, (Object)"hello world");
        Row projected = Row.project((Row)row, (int[])new int[]{0, 2, 4});
        Row expected = Row.withPositions((int)3);
        expected.setField(0, (Object)1);
        expected.setField(1, null);
        expected.setField(2, (Object)"hello world");
        Assert.assertEquals((Object)expected, (Object)projected);
    }

    @Test
    public void testRowProjectNamed() {
        Row row = Row.withNames();
        row.setField("a", (Object)1);
        row.setField("b", (Object)"hello");
        row.setField("c", null);
        row.setField("d", (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField("e", (Object)"hello world");
        Row projected = Row.project((Row)row, (String[])new String[]{"a", "c", "e"});
        Row expected = Row.withNames();
        expected.setField("a", (Object)1);
        expected.setField("c", null);
        expected.setField("e", (Object)"hello world");
        Assert.assertEquals((Object)expected, (Object)projected);
    }

    @Test
    public void testRowJoinPositioned() {
        Row row1 = new Row(2);
        row1.setField(0, (Object)1);
        row1.setField(1, (Object)"hello");
        Row row2 = new Row(2);
        row2.setField(0, null);
        row2.setField(1, (Object)new Tuple2((Object)2, (Object)"hi"));
        Row row3 = new Row(1);
        row3.setField(0, (Object)"hello world");
        Row joinedRow = Row.join((Row)row1, (Row[])new Row[]{row2, row3});
        Row expected = new Row(5);
        expected.setField(0, (Object)1);
        expected.setField(1, (Object)"hello");
        expected.setField(2, null);
        expected.setField(3, (Object)new Tuple2((Object)2, (Object)"hi"));
        expected.setField(4, (Object)"hello world");
        Assert.assertEquals((Object)expected, (Object)joinedRow);
    }

    @Test
    public void testDeepEqualsAndHashCodePositioned() {
        HashMap<String, byte[]> originalMap = new HashMap<String, byte[]>();
        originalMap.put("k1", new byte[]{1, 2, 3});
        originalMap.put("k2", new byte[]{3, 4, 6});
        Row originalRow = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3}, Arrays.asList(1, null, 3), originalMap, Collections.emptyMap(), new int[][]{{1, 2, 3}, new int[0], {4, 5}}, 1.44});
        Assert.assertEquals((Object)originalRow, (Object)originalRow);
        Assert.assertEquals((long)originalRow.hashCode(), (long)originalRow.hashCode());
        Row row = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3}, Arrays.asList(1, null, 3), originalMap, Collections.emptyMap(), new int[][]{{1, 2, 3}, new int[0], {4, 5}}, 1.44});
        Assert.assertEquals((Object)row, (Object)originalRow);
        Assert.assertEquals((long)row.hashCode(), (long)originalRow.hashCode());
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        map.put("k1", new byte[]{1, 2, 3});
        map.put("k2", new byte[]{3, 4, 6});
        Row row2 = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3, 99}, Arrays.asList(1, null, 3), map, Collections.emptyMap(), new int[][]{{1, 2, 3}, new int[0], {4, 5}}, 1.44});
        Assert.assertNotEquals((Object)row2, (Object)originalRow);
        Assert.assertNotEquals((long)row2.hashCode(), (long)originalRow.hashCode());
        map = new HashMap();
        map.put("k1", new byte[]{1, 2, 2});
        map.put("k2", new byte[]{3, 4, 6});
        row2 = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3}, Arrays.asList(1, null, 3), map, Collections.emptyMap(), new int[][]{{1, 2, 3}, new int[0], {4, 5}}, 1.44});
        Assert.assertNotEquals((Object)row2, (Object)originalRow);
        Assert.assertNotEquals((long)row2.hashCode(), (long)originalRow.hashCode());
        map = new HashMap();
        map.put("k1", new byte[]{1, 2, 3});
        map.put("k2", new byte[]{3, 4, 6});
        row2 = Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{true, new Integer[]{1, null, 3}, Arrays.asList(1, null, 3), map, Collections.emptyMap(), new Integer[][]{{1, 2, 3}, new Integer[0], {4, 5}}, 1.44});
        Assert.assertNotEquals((Object)row2, (Object)originalRow);
        Assert.assertNotEquals((long)row2.hashCode(), (long)originalRow.hashCode());
    }

    @Test
    public void testDeepEqualsCodeNamed() {
        Row named = Row.withNames((RowKind)RowKind.DELETE);
        named.setField("a", (Object)12);
        named.setField("c", (Object)true);
        LinkedHashMap<String, Integer> positionByName = new LinkedHashMap<String, Integer>();
        positionByName.put("a", 0);
        positionByName.put("b", 1);
        positionByName.put("c", 2);
        Row namedPositioned = RowUtils.createRowWithNamedPositions((RowKind)RowKind.DELETE, (Object[])new Object[3], positionByName);
        namedPositioned.setField("a", (Object)12);
        namedPositioned.setField("b", null);
        namedPositioned.setField("c", (Object)true);
        Assert.assertThat((Object)named, (Matcher)Matchers.equalTo((Object)namedPositioned));
        Assert.assertThat((Object)namedPositioned, (Matcher)Matchers.equalTo((Object)named));
        named.setField("b", (Object)"Hello");
        Assert.assertThat((Object)named, (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)namedPositioned)));
        Assert.assertThat((Object)namedPositioned, (Matcher)CoreMatchers.not((Matcher)Matchers.equalTo((Object)named)));
    }

    @Test
    public void testDeepToString() {
        Row row = Row.withNames((RowKind)RowKind.UPDATE_BEFORE);
        row.setField("a", (Object)1);
        row.setField("b", (Object)"hello");
        row.setField("c", null);
        row.setField("d", (Object)new Tuple2((Object)2, (Object)"hi"));
        row.setField("e", (Object)"hello world");
        row.setField("f", (Object)new int[][]{{1}, null, {3, 4}});
        row.setField("g", (Object)new Boolean[][]{{true}, null, {false, false}});
        HashMap<String, Integer[]> map = new HashMap<String, Integer[]>();
        map.put("a", new Integer[]{1, 2, 3, 4});
        map.put("b", new Integer[0]);
        map.put("c", null);
        row.setField("h", map);
        Assert.assertThat((Object)row.toString(), (Matcher)Matchers.equalTo((Object)"-U{a=1, b=hello, c=null, d=(2,hi), e=hello world, f=[[1], null, [3, 4]], g=[[true], null, [false, false]], h={a=[1, 2, 3, 4], b=[], c=null}}"));
    }
}

