/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.util.Preconditions;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.mockito.verification.VerificationMode;

public class MethodForwardingTestUtil {
    public static <D, W> void testMethodForwarding(Class<D> delegateClass, Function<D, W> wrapperFactory) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        MethodForwardingTestUtil.testMethodForwarding(delegateClass, wrapperFactory, () -> Mockito.spy((Class)delegateClass), Collections.emptySet());
    }

    public static <D, W, I extends D> void testMethodForwarding(Class<D> delegateClass, Function<I, W> wrapperFactory, Supplier<I> delegateObjectSupplier) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        MethodForwardingTestUtil.testMethodForwarding(delegateClass, wrapperFactory, delegateObjectSupplier, Collections.emptySet());
    }

    public static <D, W, I extends D> void testMethodForwarding(Class<D> delegateClass, Function<I, W> wrapperFactory, Supplier<I> delegateObjectSupplier, Set<Method> skipMethodSet) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Preconditions.checkNotNull(delegateClass);
        Preconditions.checkNotNull(wrapperFactory);
        Preconditions.checkNotNull(skipMethodSet);
        Object delegate = delegateObjectSupplier.get();
        if (!MockUtil.isSpy(delegate) || !MockUtil.isMock(delegate)) {
            delegate = Mockito.spy(delegate);
        }
        W wrapper = wrapperFactory.apply(delegate);
        Preconditions.checkArgument((boolean)delegateClass.isAssignableFrom(wrapper.getClass()));
        for (Method delegateMethod : delegateClass.getMethods()) {
            if (MethodForwardingTestUtil.checkSkipMethodForwardCheck(delegateMethod, skipMethodSet)) continue;
            Method wrapperMethod = wrapper.getClass().getMethod(delegateMethod.getName(), delegateMethod.getParameterTypes());
            if (wrapperMethod.isBridge()) {
                for (Method method : wrapper.getClass().getMethods()) {
                    if (method.isBridge() || !method.getName().equals(wrapperMethod.getName()) || method.getParameterCount() != wrapperMethod.getParameterCount()) continue;
                    wrapperMethod = method;
                    break;
                }
            }
            Class<?>[] parameterTypes = wrapperMethod.getParameterTypes();
            Object[] arguments = new Object[parameterTypes.length];
            for (int j = 0; j < arguments.length; ++j) {
                Class<?> parameterType = parameterTypes[j];
                if (parameterType.isArray()) {
                    arguments[j] = Array.newInstance(parameterType.getComponentType(), 0);
                    continue;
                }
                if (parameterType.isPrimitive()) {
                    if (Boolean.TYPE.equals(parameterType)) {
                        arguments[j] = false;
                        continue;
                    }
                    if (Character.TYPE.equals(parameterType)) {
                        arguments[j] = Character.valueOf('a');
                        continue;
                    }
                    arguments[j] = (byte)0;
                    continue;
                }
                arguments[j] = Mockito.mock(parameterType);
            }
            wrapperMethod.invoke(wrapper, arguments);
            delegateMethod.invoke(Mockito.verify(delegate, (VerificationMode)Mockito.times((int)1)), arguments);
            Mockito.reset((Object[])new Object[]{delegate});
        }
    }

    private static boolean checkSkipMethodForwardCheck(Method delegateMethod, Set<Method> skipMethods) {
        if (delegateMethod.isBridge() || delegateMethod.isDefault() || skipMethods.contains(delegateMethod)) {
            return true;
        }
        try {
            Object.class.getMethod(delegateMethod.getName(), delegateMethod.getParameterTypes());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

