/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.base.FlatMapOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class FlatMapOperatorCollectionTest
implements Serializable {
    @Test
    public void testExecuteOnCollection() {
        try {
            IdRichFlatMap udf = new IdRichFlatMap();
            this.testExecuteOnCollection((FlatMapFunction<String, String>)udf, Arrays.asList("f", "l", "i", "n", "k"), true);
            Assert.assertTrue((boolean)udf.isClosed);
            udf = new IdRichFlatMap();
            this.testExecuteOnCollection((FlatMapFunction<String, String>)udf, Arrays.asList("f", "l", "i", "n", "k"), false);
            Assert.assertTrue((boolean)udf.isClosed);
            udf = new IdRichFlatMap();
            this.testExecuteOnCollection((FlatMapFunction<String, String>)udf, Collections.emptyList(), true);
            Assert.assertTrue((boolean)udf.isClosed);
            udf = new IdRichFlatMap();
            this.testExecuteOnCollection((FlatMapFunction<String, String>)udf, Collections.emptyList(), false);
            Assert.assertTrue((boolean)udf.isClosed);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    private void testExecuteOnCollection(FlatMapFunction<String, String> udf, List<String> input, boolean mutableSafe) throws Exception {
        ExecutionConfig executionConfig = new ExecutionConfig();
        if (mutableSafe) {
            executionConfig.disableObjectReuse();
        } else {
            executionConfig.enableObjectReuse();
        }
        TaskInfoImpl taskInfo = new TaskInfoImpl("Test UDF", 4, 0, 4, 0);
        List result = this.getTestFlatMapOperator(udf).executeOnCollections(input, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, new HashMap(), new HashMap(), UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
        Assert.assertEquals((long)input.size(), (long)result.size());
        Assert.assertEquals(input, (Object)result);
    }

    private FlatMapOperatorBase<String, String, FlatMapFunction<String, String>> getTestFlatMapOperator(FlatMapFunction<String, String> udf) {
        UnaryOperatorInformation typeInfo = new UnaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        return new FlatMapOperatorBase(udf, typeInfo, "flatMap on Collections");
    }

    public class IdRichFlatMap<IN>
    extends RichFlatMapFunction<IN, IN> {
        private boolean isOpened = false;
        private boolean isClosed = false;

        public void open(OpenContext openContext) throws Exception {
            this.isOpened = true;
            RuntimeContext ctx = this.getRuntimeContext();
            Assert.assertEquals((Object)"Test UDF", (Object)ctx.getTaskInfo().getTaskName());
            Assert.assertEquals((long)4L, (long)ctx.getTaskInfo().getNumberOfParallelSubtasks());
            Assert.assertEquals((long)0L, (long)ctx.getTaskInfo().getIndexOfThisSubtask());
        }

        public void flatMap(IN value, Collector<IN> out) throws Exception {
            Assert.assertTrue((boolean)this.isOpened);
            Assert.assertFalse((boolean)this.isClosed);
            out.collect(value);
        }

        public void close() throws Exception {
            this.isClosed = true;
        }
    }
}

