/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.TaskInfoImpl;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.RuntimeUDFContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.base.InnerJoinOperatorBase;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.util.Collector;
import org.junit.Assert;
import org.junit.Test;

public class InnerJoinOperatorBaseTest
implements Serializable {
    @Test
    public void testJoinPlain() {
        FlatJoinFunction<String, String, Integer> joiner = new FlatJoinFunction<String, String, Integer>(){

            public void join(String first, String second, Collector<Integer> out) throws Exception {
                out.collect((Object)first.length());
                out.collect((Object)second.length());
            }
        };
        InnerJoinOperatorBase base = new InnerJoinOperatorBase((FlatJoinFunction)joiner, new BinaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), new int[0], new int[0], "TestJoiner");
        ArrayList<String> inputData1 = new ArrayList<String>(Arrays.asList("foo", "bar", "foobar"));
        ArrayList<String> inputData2 = new ArrayList<String>(Arrays.asList("foobar", "foo"));
        ArrayList<Integer> expected = new ArrayList<Integer>(Arrays.asList(3, 3, 6, 6));
        try {
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultSafe = base.executeOnCollections(inputData1, inputData2, null, executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = base.executeOnCollections(inputData1, inputData2, null, executionConfig);
            Assert.assertEquals(expected, (Object)resultSafe);
            Assert.assertEquals(expected, (Object)resultRegular);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testJoinRich() {
        final AtomicBoolean opened = new AtomicBoolean(false);
        final AtomicBoolean closed = new AtomicBoolean(false);
        String taskName = "Test rich join function";
        RichFlatJoinFunction<String, String, Integer> joiner = new RichFlatJoinFunction<String, String, Integer>(){

            public void open(OpenContext openContext) throws Exception {
                opened.compareAndSet(false, true);
                Assert.assertEquals((long)0L, (long)this.getRuntimeContext().getTaskInfo().getIndexOfThisSubtask());
                Assert.assertEquals((long)1L, (long)this.getRuntimeContext().getTaskInfo().getNumberOfParallelSubtasks());
            }

            public void close() throws Exception {
                closed.compareAndSet(false, true);
            }

            public void join(String first, String second, Collector<Integer> out) throws Exception {
                out.collect((Object)first.length());
                out.collect((Object)second.length());
            }
        };
        InnerJoinOperatorBase base = new InnerJoinOperatorBase((FlatJoinFunction)joiner, new BinaryOperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO, (TypeInformation)BasicTypeInfo.INT_TYPE_INFO), new int[0], new int[0], "Test rich join function");
        ArrayList<String> inputData1 = new ArrayList<String>(Arrays.asList("foo", "bar", "foobar"));
        ArrayList<String> inputData2 = new ArrayList<String>(Arrays.asList("foobar", "foo"));
        ArrayList<Integer> expected = new ArrayList<Integer>(Arrays.asList(3, 3, 6, 6));
        try {
            TaskInfoImpl taskInfo = new TaskInfoImpl("Test rich join function", 1, 0, 1, 0);
            HashMap accumulatorMap = new HashMap();
            HashMap cpTasks = new HashMap();
            ExecutionConfig executionConfig = new ExecutionConfig();
            executionConfig.disableObjectReuse();
            List resultSafe = base.executeOnCollections(inputData1, inputData2, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            executionConfig.enableObjectReuse();
            List resultRegular = base.executeOnCollections(inputData1, inputData2, (RuntimeContext)new RuntimeUDFContext((TaskInfo)taskInfo, null, executionConfig, cpTasks, accumulatorMap, UnregisteredMetricsGroup.createOperatorMetricGroup()), executionConfig);
            Assert.assertEquals(expected, (Object)resultSafe);
            Assert.assertEquals(expected, (Object)resultRegular);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)opened.get());
        Assert.assertTrue((boolean)closed.get());
    }
}

