/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.flink.api.common.serialization.SimpleStringSchema;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class SimpleStringSchemaTest {
    @Test
    public void testSerializationWithAnotherCharset() {
        Charset charset = StandardCharsets.UTF_16BE;
        String string = "\u4e4b\u6383\u63cf\u53e4\u7c4d\u7248\u5be6\u4e43\u59da\u9f10\u7684";
        byte[] bytes = "\u4e4b\u6383\u63cf\u53e4\u7c4d\u7248\u5be6\u4e43\u59da\u9f10\u7684".getBytes(charset);
        Assert.assertArrayEquals((byte[])bytes, (byte[])new SimpleStringSchema(charset).serialize("\u4e4b\u6383\u63cf\u53e4\u7c4d\u7248\u5be6\u4e43\u59da\u9f10\u7684"));
        Assert.assertEquals((Object)"\u4e4b\u6383\u63cf\u53e4\u7c4d\u7248\u5be6\u4e43\u59da\u9f10\u7684", (Object)new SimpleStringSchema(charset).deserialize(bytes));
    }

    @Test
    public void testSerializability() throws Exception {
        SimpleStringSchema schema = new SimpleStringSchema(StandardCharsets.UTF_16LE);
        SimpleStringSchema copy = (SimpleStringSchema)CommonTestUtils.createCopySerializable((Serializable)schema);
        Assert.assertEquals((Object)schema.getCharset(), (Object)copy.getCharset());
    }
}

