/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.state;

import java.io.Serializable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MapStateDescriptorTest {
    @Test
    public void testMapStateDescriptor() throws Exception {
        KryoSerializer keySerializer = new KryoSerializer(Integer.class, (SerializerConfig)new SerializerConfigImpl());
        KryoSerializer valueSerializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        MapStateDescriptor descr = new MapStateDescriptor("testName", (TypeSerializer)keySerializer, (TypeSerializer)valueSerializer);
        Assert.assertEquals((Object)"testName", (Object)descr.getName());
        Assert.assertNotNull((Object)descr.getSerializer());
        Assert.assertTrue((boolean)(descr.getSerializer() instanceof MapSerializer));
        Assert.assertNotNull((Object)descr.getKeySerializer());
        Assert.assertEquals((Object)keySerializer, (Object)descr.getKeySerializer());
        Assert.assertNotNull((Object)descr.getValueSerializer());
        Assert.assertEquals((Object)valueSerializer, (Object)descr.getValueSerializer());
        MapStateDescriptor copy = (MapStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)descr);
        Assert.assertEquals((Object)"testName", (Object)copy.getName());
        Assert.assertNotNull((Object)copy.getSerializer());
        Assert.assertTrue((boolean)(copy.getSerializer() instanceof MapSerializer));
        Assert.assertNotNull((Object)copy.getKeySerializer());
        Assert.assertEquals((Object)keySerializer, (Object)copy.getKeySerializer());
        Assert.assertNotNull((Object)copy.getValueSerializer());
        Assert.assertEquals((Object)valueSerializer, (Object)copy.getValueSerializer());
    }

    @Test
    public void testHashCodeEquals() throws Exception {
        String name = "testName";
        MapStateDescriptor original = new MapStateDescriptor("testName", String.class, String.class);
        MapStateDescriptor same = new MapStateDescriptor("testName", String.class, String.class);
        MapStateDescriptor sameBySerializer = new MapStateDescriptor("testName", (TypeSerializer)StringSerializer.INSTANCE, (TypeSerializer)StringSerializer.INSTANCE);
        Assert.assertEquals((long)original.hashCode(), (long)same.hashCode());
        Assert.assertEquals((long)original.hashCode(), (long)sameBySerializer.hashCode());
        Assert.assertEquals((Object)original, (Object)same);
        Assert.assertEquals((Object)original, (Object)sameBySerializer);
        MapStateDescriptor clone = (MapStateDescriptor)CommonTestUtils.createCopySerializable((Serializable)original);
        Assert.assertEquals((Object)original, (Object)clone);
        clone.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals((Object)original, (Object)clone);
        original.initializeSerializerUnlessSet(new ExecutionConfig());
        Assert.assertEquals((Object)original, (Object)same);
    }

    @Test
    public void testSerializerDuplication() {
        KryoSerializer keySerializer = new KryoSerializer(String.class, (SerializerConfig)new SerializerConfigImpl());
        KryoSerializer valueSerializer = new KryoSerializer(Long.class, (SerializerConfig)new SerializerConfigImpl());
        MapStateDescriptor descr = new MapStateDescriptor("foobar", (TypeSerializer)keySerializer, (TypeSerializer)valueSerializer);
        TypeSerializer keySerializerA = descr.getKeySerializer();
        TypeSerializer keySerializerB = descr.getKeySerializer();
        TypeSerializer valueSerializerA = descr.getValueSerializer();
        TypeSerializer valueSerializerB = descr.getValueSerializer();
        Assert.assertNotSame((Object)keySerializerA, (Object)keySerializerB);
        Assert.assertNotSame((Object)valueSerializerA, (Object)valueSerializerB);
        TypeSerializer serializerA = descr.getSerializer();
        TypeSerializer serializerB = descr.getSerializer();
        Assert.assertNotSame((Object)serializerA, (Object)serializerB);
    }
}

