/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.Arrays;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.testutils.migration.SchemaCompatibilityTestingSerializer;
import org.junit.Assert;
import org.junit.Test;

public class CompositeTypeSerializerUtilTest {
    @Test
    public void testCompatibleAsIsIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] previousSerializerSnapshots = new TypeSerializerSnapshot[]{new SchemaCompatibilityTestingSerializer("first serializer").snapshotConfiguration(), new SchemaCompatibilityTestingSerializer("second serializer").snapshotConfiguration()};
        TypeSerializerSnapshot[] newSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer("first serializer"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer("second serializer")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializerSnapshot[])newSerializerSnapshots, (TypeSerializerSnapshot[])previousSerializerSnapshots);
        Assert.assertTrue((boolean)intermediateCompatibilityResult.isCompatibleAsIs());
        Assert.assertTrue((boolean)intermediateCompatibilityResult.getFinalResult().isCompatibleAsIs());
        Assert.assertArrayEquals((Object[])Arrays.stream(newSerializerSnapshots).map(TypeSerializerSnapshot::restoreSerializer).toArray(), (Object[])intermediateCompatibilityResult.getNestedSerializers());
    }

    @Test
    public void testCompatibleWithReconfiguredSerializerIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] previousSerializerSnapshots = new TypeSerializerSnapshot[]{new SchemaCompatibilityTestingSerializer("a").snapshotConfiguration(), new SchemaCompatibilityTestingSerializer("b").snapshotConfiguration()};
        TypeSerializerSnapshot[] newSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer("a"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterReconfiguration("b")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializerSnapshot[])newSerializerSnapshots, (TypeSerializerSnapshot[])previousSerializerSnapshots);
        Object[] expectedReconfiguredNestedSerializers = new TypeSerializer[]{new SchemaCompatibilityTestingSerializer("a"), new SchemaCompatibilityTestingSerializer("b")};
        Assert.assertTrue((boolean)intermediateCompatibilityResult.isCompatibleWithReconfiguredSerializer());
        Assert.assertArrayEquals((Object[])expectedReconfiguredNestedSerializers, (Object[])intermediateCompatibilityResult.getNestedSerializers());
    }

    @Test
    public void testCompatibleAfterMigrationIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] previousSerializerSnapshots = new TypeSerializerSnapshot[]{new SchemaCompatibilityTestingSerializer("a").snapshotConfiguration(), new SchemaCompatibilityTestingSerializer("b").snapshotConfiguration(), new SchemaCompatibilityTestingSerializer("c").snapshotConfiguration()};
        TypeSerializerSnapshot[] newSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterReconfiguration("a"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterMigration("b"), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer("c")};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializerSnapshot[])newSerializerSnapshots, (TypeSerializerSnapshot[])previousSerializerSnapshots);
        Assert.assertTrue((boolean)intermediateCompatibilityResult.isCompatibleAfterMigration());
        Assert.assertTrue((boolean)intermediateCompatibilityResult.getFinalResult().isCompatibleAfterMigration());
    }

    @Test
    public void testIncompatibleIntermediateCompatibilityResult() {
        TypeSerializerSnapshot[] previousSerializerSnapshots = new TypeSerializerSnapshot[]{new SchemaCompatibilityTestingSerializer().snapshotConfiguration(), new SchemaCompatibilityTestingSerializer().snapshotConfiguration(), new SchemaCompatibilityTestingSerializer().snapshotConfiguration(), new SchemaCompatibilityTestingSerializer().snapshotConfiguration()};
        TypeSerializerSnapshot[] newSerializerSnapshots = new TypeSerializerSnapshot[]{SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializer(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsIncompatibleWithTheLastSerializer(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterReconfiguration(), SchemaCompatibilityTestingSerializer.SchemaCompatibilityTestingSnapshot.thatIsCompatibleWithLastSerializerAfterMigration()};
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.constructIntermediateCompatibilityResult((TypeSerializerSnapshot[])newSerializerSnapshots, (TypeSerializerSnapshot[])previousSerializerSnapshots);
        Assert.assertTrue((boolean)intermediateCompatibilityResult.isIncompatible());
        Assert.assertTrue((boolean)intermediateCompatibilityResult.getFinalResult().isIncompatible());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetFinalResultOnUndefinedReconfigureIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.undefinedReconfigureResult((TypeSerializer[])new TypeSerializer[]{IntSerializer.INSTANCE});
        intermediateCompatibilityResult.getFinalResult();
    }

    @Test(expected=IllegalStateException.class)
    public void testGetNestedSerializersOnCompatibleAfterMigrationIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.definedCompatibleAfterMigrationResult();
        intermediateCompatibilityResult.getNestedSerializers();
    }

    @Test(expected=IllegalStateException.class)
    public void testGetNestedSerializersOnIncompatibleIntermediateCompatibilityResultFails() {
        CompositeTypeSerializerUtil.IntermediateCompatibilityResult intermediateCompatibilityResult = CompositeTypeSerializerUtil.IntermediateCompatibilityResult.definedIncompatibleResult();
        intermediateCompatibilityResult.getNestedSerializers();
    }
}

