/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.operators.Keys;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializer;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PojoSerializerTest
extends SerializerTestBase<TestUserClass> {
    private TypeInformation<TestUserClass> type = TypeExtractor.getForClass(TestUserClass.class);

    PojoSerializerTest() {
    }

    @Override
    protected TypeSerializer<TestUserClass> createSerializer() {
        TypeSerializer serializer = this.type.createSerializer((SerializerConfig)new SerializerConfigImpl());
        assert (serializer instanceof PojoSerializer);
        return serializer;
    }

    @Override
    protected int getLength() {
        return -1;
    }

    @Override
    protected Class<TestUserClass> getTypeClass() {
        return TestUserClass.class;
    }

    protected TestUserClass[] getTestData() {
        Random rnd = new Random(874597969123412341L);
        return new TestUserClass[]{new TestUserClass(rnd.nextInt(), "foo", rnd.nextDouble(), new int[]{1, 2, 3}, new Date(), new NestedTestUserClass(rnd.nextInt(), "foo@boo", rnd.nextDouble(), new int[]{10, 11, 12})), new TestUserClass(rnd.nextInt(), "bar", rnd.nextDouble(), new int[]{4, 5, 6}, null, new NestedTestUserClass(rnd.nextInt(), "bar@bas", rnd.nextDouble(), new int[]{20, 21, 22})), new TestUserClass(rnd.nextInt(), null, rnd.nextDouble(), null, null, null), new TestUserClass(rnd.nextInt(), "bar", rnd.nextDouble(), new int[]{4, 5, 6}, new Date(), new NestedTestUserClass(rnd.nextInt(), "bar@bas", rnd.nextDouble(), new int[]{20, 21, 22}))};
    }

    @Test
    void testTuplePojoTestEquality() throws Keys.IncompatibleKeysException {
        PojoTypeInfo pType = (PojoTypeInfo)this.type;
        ArrayList result = new ArrayList();
        pType.getFlatFields("nestedClass.dumm2", 0, result);
        int[] fields = new int[]{((CompositeType.FlatFieldDescriptor)result.get(0)).getPosition()};
        TypeComparator pojoComp = pType.createComparator(fields, new boolean[]{true}, 0, new ExecutionConfig());
        TestUserClass pojoTestRecord = new TestUserClass(0, "abc", 3.0, new int[]{1, 2, 3}, new Date(), new NestedTestUserClass(1, "haha", 4.0, new int[]{5, 4, 3}));
        int pHash = pojoComp.hash((Object)pojoTestRecord);
        Tuple1 tupleTest = new Tuple1((Object)"haha");
        TupleTypeInfo tType = (TupleTypeInfo)TypeExtractor.getForObject((Object)tupleTest);
        TypeComparator tupleComp = tType.createComparator(new int[]{0}, new boolean[]{true}, 0, new ExecutionConfig());
        int tHash = tupleComp.hash((Object)tupleTest);
        Assertions.assertThat((int)tHash).isEqualTo(pHash).withFailMessage("The hashing for tuples and pojos must be the same, so that they are mixable", new Object[0]);
        Tuple3 multiTupleTest = new Tuple3((Object)1, (Object)"haha", (Object)4.0);
        TupleTypeInfo multiTupleType = (TupleTypeInfo)TypeExtractor.getForObject((Object)multiTupleTest);
        Keys.ExpressionKeys fieldKey = new Keys.ExpressionKeys(new int[]{1, 0, 2}, (TypeInformation)multiTupleType);
        Keys.ExpressionKeys expressKey = new Keys.ExpressionKeys(new String[]{"nestedClass.dumm2", "nestedClass.dumm1", "nestedClass.dumm3"}, (TypeInformation)pType);
        Assertions.assertThat((boolean)fieldKey.areCompatible((Keys)expressKey)).isTrue().withFailMessage("Expecting the keys to be compatible", new Object[0]);
        TypeComparator multiPojoComp = pType.createComparator(expressKey.computeLogicalKeyPositions(), new boolean[]{true, true, true}, 0, new ExecutionConfig());
        int multiPojoHash = multiPojoComp.hash((Object)pojoTestRecord);
        TypeComparator multiTupleComp = multiTupleType.createComparator(fieldKey.computeLogicalKeyPositions(), new boolean[]{true, true, true}, 0, new ExecutionConfig());
        int multiTupleHash = multiTupleComp.hash((Object)multiTupleTest);
        Assertions.assertThat((int)multiPojoHash).isEqualTo(multiTupleHash).withFailMessage("The hashing for tuples and pojos must be the same, so that they are mixable. Also for those with multiple key fields", new Object[0]);
    }

    @Test
    void testReconfigureWithDifferentPojoType() throws Exception {
        byte[] serializedConfig;
        PojoSerializer pojoSerializer1 = (PojoSerializer)TypeExtractor.getForClass(SubTestUserClassB.class).createSerializer((SerializerConfig)new SerializerConfigImpl());
        PojoSerializerSnapshot pojoSerializerConfigSnapshot = pojoSerializer1.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)pojoSerializerConfigSnapshot);
            serializedConfig = out.toByteArray();
        }
        PojoSerializer pojoSerializer2 = (PojoSerializer)TypeExtractor.getForClass(SubTestUserClassA.class).createSerializer((SerializerConfig)new SerializerConfigImpl());
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            pojoSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        TypeSerializerSchemaCompatibility compatResult = pojoSerializer2.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)pojoSerializerConfigSnapshot);
        Assertions.assertThat((boolean)compatResult.isIncompatible()).isTrue();
    }

    @Test
    void testReconfigureDifferentSubclassRegistrationOrder() throws Exception {
        byte[] serializedConfig;
        SerializerConfigImpl serializerConfig = new SerializerConfigImpl();
        serializerConfig.registerPojoType(SubTestUserClassA.class);
        serializerConfig.registerPojoType(SubTestUserClassB.class);
        PojoSerializer pojoSerializer = (PojoSerializer)this.type.createSerializer((SerializerConfig)serializerConfig);
        int subClassATag = (Integer)pojoSerializer.getRegisteredClasses().get(SubTestUserClassA.class);
        int subClassBTag = (Integer)pojoSerializer.getRegisteredClasses().get(SubTestUserClassB.class);
        PojoSerializerSnapshot pojoSerializerConfigSnapshot = pojoSerializer.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)pojoSerializerConfigSnapshot);
            serializedConfig = out.toByteArray();
        }
        serializerConfig = new SerializerConfigImpl();
        serializerConfig.registerPojoType(SubTestUserClassB.class);
        serializerConfig.registerPojoType(SubTestUserClassA.class);
        pojoSerializer = (PojoSerializer)this.type.createSerializer((SerializerConfig)serializerConfig);
        var8_7 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            pojoSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        TypeSerializerSchemaCompatibility compatResult = pojoSerializer.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)pojoSerializerConfigSnapshot);
        Assertions.assertThat((boolean)compatResult.isCompatibleWithReconfiguredSerializer()).isTrue();
        Assertions.assertThat((Object)compatResult.getReconfiguredSerializer()).isInstanceOf(PojoSerializer.class);
        PojoSerializer reconfiguredPojoSerializer = (PojoSerializer)compatResult.getReconfiguredSerializer();
        Assertions.assertThat((int)subClassATag).isEqualTo(((Integer)reconfiguredPojoSerializer.getRegisteredClasses().get(SubTestUserClassA.class)).intValue());
        Assertions.assertThat((int)subClassBTag).isEqualTo(((Integer)reconfiguredPojoSerializer.getRegisteredClasses().get(SubTestUserClassB.class)).intValue());
    }

    @Test
    void testReconfigureRepopulateNonregisteredSubclassSerializerCache() throws Exception {
        byte[] serializedConfig;
        PojoSerializer pojoSerializer = (PojoSerializer)this.type.createSerializer((SerializerConfig)new SerializerConfigImpl());
        pojoSerializer.getSubclassSerializer(SubTestUserClassA.class);
        pojoSerializer.getSubclassSerializer(SubTestUserClassB.class);
        Assertions.assertThat((Map)pojoSerializer.getSubclassSerializerCache()).containsOnlyKeys((Object[])new Class[]{SubTestUserClassA.class, SubTestUserClassB.class});
        PojoSerializerSnapshot pojoSerializerConfigSnapshot = pojoSerializer.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)pojoSerializerConfigSnapshot);
            serializedConfig = out.toByteArray();
        }
        pojoSerializer = (PojoSerializer)this.type.createSerializer((SerializerConfig)new SerializerConfigImpl());
        var5_4 = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            pojoSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        TypeSerializerSchemaCompatibility compatResult = pojoSerializer.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)pojoSerializerConfigSnapshot);
        Assertions.assertThat((boolean)compatResult.isCompatibleWithReconfiguredSerializer()).isTrue();
        Assertions.assertThat((Object)compatResult.getReconfiguredSerializer()).isInstanceOf(PojoSerializer.class);
        PojoSerializer reconfiguredPojoSerializer = (PojoSerializer)compatResult.getReconfiguredSerializer();
        Assertions.assertThat((Map)reconfiguredPojoSerializer.getSubclassSerializerCache()).containsOnlyKeys((Object[])new Class[]{SubTestUserClassA.class, SubTestUserClassB.class});
    }

    @Test
    void testReconfigureWithPreviouslyNonregisteredSubclasses() throws Exception {
        byte[] serializedConfig;
        PojoSerializer pojoSerializer = (PojoSerializer)this.type.createSerializer((SerializerConfig)new SerializerConfigImpl());
        pojoSerializer.getSubclassSerializer(SubTestUserClassA.class);
        pojoSerializer.getSubclassSerializer(SubTestUserClassB.class);
        Assertions.assertThat((Map)pojoSerializer.getSubclassSerializerCache()).containsOnlyKeys((Object[])new Class[]{SubTestUserClassA.class, SubTestUserClassB.class});
        Assertions.assertThat((Map)pojoSerializer.getRegisteredClasses()).isEmpty();
        Assertions.assertThat((Object[])pojoSerializer.getRegisteredSerializers()).isEmpty();
        PojoSerializerSnapshot pojoSerializerConfigSnapshot = pojoSerializer.snapshotConfiguration();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot((DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out), (TypeSerializerSnapshot)pojoSerializerConfigSnapshot);
            serializedConfig = out.toByteArray();
        }
        SerializerConfigImpl serializerConfig = new SerializerConfigImpl();
        serializerConfig.registerPojoType(SubTestUserClassA.class);
        serializerConfig.registerPojoType(SubTestUserClassB.class);
        pojoSerializer = (PojoSerializer)this.type.createSerializer((SerializerConfig)serializerConfig);
        try (ByteArrayInputStream in = new ByteArrayInputStream(serializedConfig);){
            pojoSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot((DataInputView)new DataInputViewStreamWrapper((InputStream)in), (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        TypeSerializerSchemaCompatibility compatResult = pojoSerializer.snapshotConfiguration().resolveSchemaCompatibility((TypeSerializerSnapshot)pojoSerializerConfigSnapshot);
        Assertions.assertThat((boolean)compatResult.isCompatibleWithReconfiguredSerializer()).isTrue();
        Assertions.assertThat((Object)compatResult.getReconfiguredSerializer()).isInstanceOf(PojoSerializer.class);
        PojoSerializer reconfiguredPojoSerializer = (PojoSerializer)compatResult.getReconfiguredSerializer();
        Assertions.assertThat((Map)reconfiguredPojoSerializer.getSubclassSerializerCache()).containsOnlyKeys((Object[])new Class[]{SubTestUserClassA.class, SubTestUserClassB.class});
        Assertions.assertThat((Map)reconfiguredPojoSerializer.getRegisteredClasses()).containsOnlyKeys((Object[])new Class[]{SubTestUserClassA.class, SubTestUserClassB.class});
    }

    public static class SubTestUserClassB
    extends TestUserClass {
        public Double subDumm1;
        public float subDumm2;
    }

    public static class SubTestUserClassA
    extends TestUserClass {
        public int subDumm1;
        public String subDumm2;
    }

    public static class NestedTestUserClass {
        public int dumm1;
        public String dumm2;
        public double dumm3;
        public int[] dumm4;

        public NestedTestUserClass() {
        }

        public NestedTestUserClass(int dumm1, String dumm2, double dumm3, int[] dumm4) {
            this.dumm1 = dumm1;
            this.dumm2 = dumm2;
            this.dumm3 = dumm3;
            this.dumm4 = dumm4;
        }

        public int hashCode() {
            return Objects.hash(this.dumm1, this.dumm2, this.dumm3, this.dumm4);
        }

        public boolean equals(Object other) {
            if (!(other instanceof NestedTestUserClass)) {
                return false;
            }
            NestedTestUserClass otherTUC = (NestedTestUserClass)other;
            if (this.dumm1 != otherTUC.dumm1) {
                return false;
            }
            if (!this.dumm2.equals(otherTUC.dumm2)) {
                return false;
            }
            if (this.dumm3 != otherTUC.dumm3) {
                return false;
            }
            if (this.dumm4.length != otherTUC.dumm4.length) {
                return false;
            }
            for (int i = 0; i < this.dumm4.length; ++i) {
                if (this.dumm4[i] == otherTUC.dumm4[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static class TestUserClass {
        public int dumm1;
        public String dumm2;
        public double dumm3;
        public int[] dumm4;
        public Date dumm5;
        public NestedTestUserClass nestedClass;

        public TestUserClass() {
        }

        public TestUserClass(int dumm1, String dumm2, double dumm3, int[] dumm4, Date dumm5, NestedTestUserClass nestedClass) {
            this.dumm1 = dumm1;
            this.dumm2 = dumm2;
            this.dumm3 = dumm3;
            this.dumm4 = dumm4;
            this.dumm5 = dumm5;
            this.nestedClass = nestedClass;
        }

        public int hashCode() {
            return Objects.hash(this.dumm1, this.dumm2, this.dumm3, this.dumm4, this.dumm5, this.nestedClass);
        }

        public boolean equals(Object other) {
            if (!(other instanceof TestUserClass)) {
                return false;
            }
            TestUserClass otherTUC = (TestUserClass)other;
            if (this.dumm1 != otherTUC.dumm1) {
                return false;
            }
            if (this.dumm2 == null && otherTUC.dumm2 != null || this.dumm2 != null && !this.dumm2.equals(otherTUC.dumm2)) {
                return false;
            }
            if (this.dumm3 != otherTUC.dumm3) {
                return false;
            }
            if (this.dumm4 != null && otherTUC.dumm4 == null || this.dumm4 == null && otherTUC.dumm4 != null || this.dumm4 != null && otherTUC.dumm4 != null && this.dumm4.length != otherTUC.dumm4.length) {
                return false;
            }
            if (this.dumm4 != null && otherTUC.dumm4 != null) {
                for (int i = 0; i < this.dumm4.length; ++i) {
                    if (this.dumm4[i] == otherTUC.dumm4[i]) continue;
                    return false;
                }
            }
            if (this.dumm5 == null && otherTUC.dumm5 != null || this.dumm5 != null && !this.dumm5.equals(otherTUC.dumm5)) {
                return false;
            }
            return (this.nestedClass != null || otherTUC.nestedClass == null) && (this.nestedClass == null || this.nestedClass.equals(otherTUC.nestedClass));
        }
    }
}

